/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.fx.anchors.FXStaticAnchor;
import org.eclipse.gef4.fx.anchors.IFXAnchor;
import org.eclipse.gef4.fx.nodes.FXConnection;
import org.eclipse.gef4.geometry.convert.fx.JavaFX2Geometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.fx.operations.FXBendOperation;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.models.GridModel;

public class FXRelocateConnectionPolicy
extends FXTransformPolicy {
    private FXBendOperation op;
    private Point[] initialPositions;

    @Override
    public IUndoableOperation commit() {
        return this.op;
    }

    protected List<Integer> getIndicesOfMovableAnchors() {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        if (!this.op.getConnection().isStartConnected()) {
            indices.add(0);
        }
        int i = 0;
        while (i < this.op.getNewAnchors().size() - 2) {
            if (!this.op.getConnection().isWayConnected(i)) {
                indices.add(i + 1);
            }
            ++i;
        }
        if (!this.op.getConnection().isEndConnected()) {
            indices.add(this.op.getNewAnchors().size() - 1);
        }
        return indices;
    }

    @Override
    public void init() {
        this.op = new FXBendOperation((FXConnection)this.getHost().getVisual());
        this.initialPositions = this.op.getConnection().getPoints();
    }

    protected void locallyExecuteOperation() {
        try {
            this.op.execute(null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setConcatenation(AffineTransform transform) {
        this.setPreConcatenation(transform);
    }

    @Override
    public void setPreConcatenation(AffineTransform transform) {
        double dx = transform.getTranslateX();
        double dy = transform.getTranslateY();
        for (int i : this.getIndicesOfMovableAnchors()) {
            Point p = this.initialPositions[i];
            Dimension snapToGridOffset = FXRelocateConnectionPolicy.getSnapToGridOffset((GridModel)this.getHost().getRoot().getViewer().getAdapter(GridModel.class), p.x + dx, p.y + dy, 0.5, 0.5);
            this.op.getNewAnchors().set(i, (IFXAnchor)new FXStaticAnchor(JavaFX2Geometry.toPoint((Point2D)((Node)this.getHost().getVisual()).localToScene(p.x + dx - snapToGridOffset.width, p.y + dy - snapToGridOffset.height))));
        }
        this.locallyExecuteOperation();
    }

    @Override
    public void setTransform(AffineTransform newTransform) {
        double dx = newTransform.getTranslateX() - this.getNodeTransform().getTx();
        double dy = newTransform.getTranslateY() - this.getNodeTransform().getTy();
        this.setPreConcatenation(new AffineTransform().translate(dx, dy));
    }
}

