/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef4.fx.nodes.FXConnection;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.fx.parts.FXCircleSegmentHandlePart;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXOnDragPolicy;
import org.eclipse.gef4.mvc.fx.policies.FXBendPolicy;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.parts.PartUtils;
import org.eclipse.gef4.mvc.policies.IPolicy;

public class FXBendOnSegmentHandleDragPolicy
extends AbstractFXOnDragPolicy {
    private int createdSegmentIndex;
    private boolean initialRefreshVisual = true;

    private void adjustHandles(List<Point> oldWaypoints, List<Point> newWaypoints) {
        if (oldWaypoints.size() != newWaypoints.size()) {
            List parts = PartUtils.filterParts((Collection)PartUtils.getAnchoreds((Collection)this.getHost().getAnchorages().keySet()), FXCircleSegmentHandlePart.class);
            Collections.sort(parts);
            Iterator it = parts.iterator();
            FXCircleSegmentHandlePart part = null;
            int i = 0;
            while (i <= newWaypoints.size()) {
                part = (FXCircleSegmentHandlePart)it.next();
                this.setSegmentIndex(part, i);
                this.setSegmentParameter(part, 0.0);
                if (this.createdSegmentIndex < 0 || part.getSegmentIndex() != this.createdSegmentIndex - 1 && part.getSegmentIndex() != this.createdSegmentIndex) {
                    part = (FXCircleSegmentHandlePart)it.next();
                    this.setSegmentIndex(part, i);
                    this.setSegmentParameter(part, 0.5);
                }
                ++i;
            }
            part = (FXCircleSegmentHandlePart)it.next();
            this.setSegmentIndex(part, newWaypoints.size());
            this.setSegmentParameter(part, 1.0);
            while (it.hasNext()) {
                part = (FXCircleSegmentHandlePart)it.next();
                this.setSegmentIndex(part, -1);
            }
        }
    }

    protected void disableRefreshVisuals() {
        IVisualPart anchorage = (IVisualPart)this.getHost().getAnchorages().keySet().iterator().next();
        anchorage.setRefreshVisual(false);
        this.initialRefreshVisual = anchorage.isRefreshVisual();
    }

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        IVisualPart anchorage = (IVisualPart)this.getHost().getAnchorages().keySet().iterator().next();
        FXConnection connection = (FXConnection)anchorage.getVisual();
        ArrayList<Point> before = new ArrayList<Point>(connection.getWayPoints());
        this.getBendPolicy((IVisualPart<Node, ? extends Node>)anchorage).moveSelectedSegmentPoint(new Point(e.getSceneX(), e.getSceneY()));
        ArrayList<Point> after = new ArrayList<Point>(connection.getWayPoints());
        this.adjustHandles(before, after);
    }

    protected void enableRefreshVisuals() {
        IVisualPart anchorage = (IVisualPart)this.getHost().getAnchorages().keySet().iterator().next();
        anchorage.setRefreshVisual(this.initialRefreshVisual);
    }

    protected FXBendPolicy getBendPolicy(IVisualPart<Node, ? extends Node> targetPart) {
        return (FXBendPolicy)((Object)targetPart.getAdapter(FXBendPolicy.class));
    }

    public FXCircleSegmentHandlePart getHost() {
        return (FXCircleSegmentHandlePart)super.getHost();
    }

    @Override
    public void press(MouseEvent e) {
        this.createdSegmentIndex = -1;
        FXCircleSegmentHandlePart hp = this.getHost();
        IVisualPart anchorage = (IVisualPart)this.getHost().getAnchorages().keySet().iterator().next();
        this.disableRefreshVisuals(anchorage);
        this.init((IPolicy)this.getBendPolicy((IVisualPart<Node, ? extends Node>)anchorage));
        if (hp.getSegmentParameter() == 0.5) {
            this.getBendPolicy((IVisualPart<Node, ? extends Node>)anchorage).createAndSelectSegmentPoint(hp.getSegmentIndex(), new Point(e.getSceneX(), e.getSceneY()));
            List parts = PartUtils.filterParts((Collection)PartUtils.getAnchoreds((Collection)this.getHost().getAnchorages().keySet()), FXCircleSegmentHandlePart.class);
            Collections.sort(parts);
            for (FXCircleSegmentHandlePart p : parts) {
                if (p.getSegmentIndex() <= hp.getSegmentIndex() && (p.getSegmentIndex() != hp.getSegmentIndex() || p.getSegmentParameter() != 1.0)) continue;
                p.setSegmentIndex(p.getSegmentIndex() + 1);
            }
            hp.setSegmentIndex(hp.getSegmentIndex() + 1);
            hp.setSegmentParameter(0.0);
            this.createdSegmentIndex = hp.getSegmentIndex();
        } else {
            this.getBendPolicy((IVisualPart<Node, ? extends Node>)anchorage).selectSegmentPoint(hp.getSegmentIndex(), hp.getSegmentParameter(), new Point(e.getSceneX(), e.getSceneY()));
        }
    }

    @Override
    public void release(MouseEvent e, Dimension delta) {
        IVisualPart anchorage = (IVisualPart)this.getHost().getAnchorages().keySet().iterator().next();
        this.enableRefreshVisuals();
        this.commit((IPolicy)this.getBendPolicy((IVisualPart<Node, ? extends Node>)anchorage));
    }

    private void setSegmentIndex(FXCircleSegmentHandlePart part, int value) {
        if (part.getSegmentIndex() != value) {
            part.setSegmentIndex(value);
        }
    }

    private void setSegmentParameter(FXCircleSegmentHandlePart part, double value) {
        if (part.getSegmentParameter() != value) {
            part.setSegmentParameter(value);
        }
    }
}

