/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import com.google.common.collect.SetMultimap;
import com.google.inject.Provider;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.StrokeType;
import org.eclipse.gef4.fx.nodes.FXConnection;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXSegmentHandlePart;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXCircleSegmentHandlePart
extends AbstractFXSegmentHandlePart<Circle> {
    public static final Color DEFAULT_STROKE = Color.web((String)"#5a61af");
    public static final Color DEFAULT_FILL = Color.WHITE;
    public static final Color CONNECTED_FILL = Color.web((String)"#ff0000");
    public static final Color UNCONNECTED_FILL = Color.web((String)"#d5faff");
    public static final double DEFAULT_SIZE = 5.0;

    public FXCircleSegmentHandlePart(Provider<BezierCurve[]> segmentsProvider, int segmentIndex, double segmentParameter) {
        super(segmentsProvider, segmentIndex, segmentParameter);
    }

    protected Circle createVisual() {
        Circle circle = new Circle(2.5);
        circle.setStroke((Paint)DEFAULT_STROKE);
        circle.setFill((Paint)DEFAULT_FILL);
        circle.setStrokeWidth(1.0);
        circle.setStrokeType(StrokeType.OUTSIDE);
        return circle;
    }

    @Override
    public void doRefreshVisual(Circle visual) {
        super.doRefreshVisual(visual);
        this.updateColor();
    }

    protected void updateColor() {
        SetMultimap anchorages = this.getAnchorages();
        if (this.getRoot() == null || anchorages.keySet().size() != 1) {
            return;
        }
        Circle visual = (Circle)this.getVisual();
        if (!visual.isVisible()) {
            return;
        }
        if (this.getSegmentParameter() != 0.0 && this.getSegmentParameter() != 1.0) {
            visual.setFill((Paint)DEFAULT_FILL);
        } else {
            boolean connected = false;
            IVisualPart targetPart = (IVisualPart)anchorages.keySet().iterator().next();
            if (targetPart.getVisual() instanceof FXConnection) {
                FXConnection connection = (FXConnection)targetPart.getVisual();
                if ((double)this.getSegmentIndex() + this.getSegmentParameter() == 0.0) {
                    connected = connection.isStartConnected();
                } else if (this.getSegmentParameter() + (double)this.getSegmentIndex() == (double)this.getSegmentsInScene().length) {
                    connected = connection.isEndConnected();
                }
            }
            if (connected) {
                visual.setFill((Paint)CONNECTED_FILL);
            } else {
                visual.setFill((Paint)UNCONNECTED_FILL);
            }
        }
    }
}

