/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.operations;

import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.mvc.models.ViewportModel;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXRevealOperation
extends AbstractOperation {
    private double tx = 0.0;
    private double ty = 0.0;
    private IViewer<Node> viewer;
    private ViewportModel viewportModel;
    private IVisualPart<Node, ? extends Node> part = null;

    public FXRevealOperation(IVisualPart<Node, ? extends Node> part) {
        super("Reveal");
        this.part = part;
        this.viewer = part.getRoot().getViewer();
        this.viewportModel = (ViewportModel)this.viewer.getAdapter(ViewportModel.class);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.tx = this.viewportModel.getTranslateX();
        this.ty = this.viewportModel.getTranslateY();
        this.viewer.reveal(this.part);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.viewportModel.setTranslateX(this.tx);
        this.viewportModel.setTranslateY(this.ty);
        return Status.OK_STATUS;
    }
}

