/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.ui.properties;

import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.gef4.mvc.fx.ui.properties.FXFillSelectionDialog;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class FXFillCellEditor
extends DialogCellEditor {
    private Image image;

    public FXFillCellEditor(Composite parent) {
        this(parent, 0);
    }

    public FXFillCellEditor(Composite parent, int style) {
        super(parent, style);
        this.doSetValue(Color.TRANSPARENT);
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        int result;
        FXFillSelectionDialog dialog = new FXFillSelectionDialog(cellEditorWindow.getShell(), "Select Fill");
        Object value = this.getValue();
        if (value != null) {
            dialog.setPaint((Paint)value);
        }
        if ((result = dialog.open()) == 1) {
            return value;
        }
        return dialog.getPaint();
    }

    ImageData createPaintImage(Control w, Paint paint) {
        int width = 64;
        int height = 16;
        if (w instanceof Table) {
            height = ((Table)w).getItemHeight() - 1;
        } else if (w instanceof Tree) {
            height = ((Tree)w).getItemHeight() - 1;
        } else if (w instanceof TableTree) {
            height = ((TableTree)w).getItemHeight() - 1;
        }
        return FXFillSelectionDialog.createPaintImage(width, height, paint);
    }

    protected void updateContents(Object value) {
        Color paint;
        Object object = paint = value == null ? Color.TRANSPARENT : (Paint)value;
        if (this.image != null) {
            this.image.dispose();
        }
        ImageData id = this.createPaintImage((Control)this.getDefaultLabel().getParent().getParent(), (Paint)paint);
        this.image = new Image((Device)this.getDefaultLabel().getDisplay(), id, id.getTransparencyMask());
        this.getDefaultLabel().setImage(this.image);
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        super.dispose();
    }
}

