/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.ui.properties;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import org.eclipse.gef4.common.properties.IPropertyChangeNotifier;
import org.eclipse.gef4.mvc.fx.ui.properties.AbstractFXColorPicker;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class FXColorPicker
implements IPropertyChangeNotifier {
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Color color;
    private Control control;
    private AbstractFXColorPicker colorPicker;

    public FXColorPicker(Composite parent) {
        this.control = this.createControl(parent);
        this.setColor(Color.WHITE);
    }

    public Control getControl() {
        return this.control;
    }

    protected Control createControl(final Composite parent) {
        FXCanvas canvas = new FXCanvas(parent, 0);
        this.colorPicker = new AbstractFXColorPicker(){

            @Override
            public Color pickColor() {
                return FXColorPicker.pickColor(parent.getShell(), this.getColor());
            }
        };
        this.colorPicker.colorProperty().addListener((ChangeListener)new ChangeListener<Color>(){

            public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
                FXColorPicker.this.setColor(newValue);
            }
        });
        Scene scene = new Scene((Parent)this.colorPicker);
        canvas.setScene(scene);
        return canvas;
    }

    protected static Color pickColor(Shell shell, Color initial) {
        ColorDialog cd = new ColorDialog(shell);
        RGB rgb = new RGB((int)(255.0 * initial.getRed()), (int)(255.0 * initial.getGreen()), (int)(255.0 * initial.getBlue()));
        cd.setRGB(rgb);
        RGB newRgb = cd.open();
        if (newRgb != null) {
            return Color.rgb((int)newRgb.red, (int)newRgb.green, (int)newRgb.blue);
        }
        return null;
    }

    public void setColor(Color color) {
        if (this.color == null ? color != null : !this.color.equals((Object)color)) {
            Color oldColor = this.color;
            this.color = color;
            this.colorPicker.setColor(color);
            this.pcs.firePropertyChange("color", oldColor, color);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }
}

