/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.Shape;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.anchors.IFXAnchor;
import org.eclipse.gef4.fx.nodes.FXConnection;
import org.eclipse.gef4.fx.nodes.FXPolyBezierConnectionRouter;
import org.eclipse.gef4.fx.nodes.IFXConnectionRouter;
import org.eclipse.gef4.fx.nodes.IFXDecoration;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.examples.logo.model.AbstractFXGeometricElement;
import org.eclipse.gef4.mvc.examples.logo.model.FXGeometricCurve;
import org.eclipse.gef4.mvc.examples.logo.parts.AbstractFXGeometricElementPart;
import org.eclipse.gef4.mvc.fx.policies.FXBendPolicy;
import org.eclipse.gef4.mvc.fx.policies.FXRelocateConnectionPolicy;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.ContentPolicy;

public class FXGeometricCurvePart
extends AbstractFXGeometricElementPart<FXConnection> {
    private final CircleHead START_CIRCLE_HEAD = new CircleHead();
    private final CircleHead END_CIRCLE_HEAD = new CircleHead();
    private final ArrowHead START_ARROW_HEAD = new ArrowHead();
    private final ArrowHead END_ARROW_HEAD = new ArrowHead();
    private FXGeometricCurve previousContent;

    public FXGeometricCurvePart() {
        this.setAdapter(AdapterKey.get(FXTransformPolicy.class), new FXRelocateConnectionPolicy(){

            public IUndoableOperation commit() {
                return FXGeometricCurvePart.this.chainModelChanges(super.commit());
            }
        });
        this.setAdapter(AdapterKey.get(FXBendPolicy.class), new FXBendPolicy(){

            public IUndoableOperation commit() {
                return FXGeometricCurvePart.this.chainModelChanges(super.commit());
            }
        });
    }

    protected void attachToAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        IFXAnchor anchor = (IFXAnchor)((Provider)anchorage.getAdapter((TypeToken)new TypeToken<Provider<? extends IFXAnchor>>(){})).get();
        if (role.equals("START")) {
            ((FXConnection)this.getVisual()).setStartAnchor(anchor);
        } else if (role.equals("END")) {
            ((FXConnection)this.getVisual()).setEndAnchor(anchor);
        } else {
            throw new IllegalStateException("Cannot attach to anchor with role <" + role + ">.");
        }
    }

    public void attachToContentAnchorage(Object contentAnchorage, String role) {
        if (!(contentAnchorage instanceof AbstractFXGeometricElement)) {
            throw new IllegalArgumentException("Inappropriate content anchorage: wrong type.");
        }
        AbstractFXGeometricElement geom = (AbstractFXGeometricElement)contentAnchorage;
        if ("START".equals(role)) {
            this.getContent().getSourceAnchorages().add(geom);
        } else if ("END".equals(role)) {
            this.getContent().getTargetAnchorages().add(geom);
        }
    }

    IUndoableOperation chainModelChanges(IUndoableOperation updateVisualOperation) {
        AbstractFXGeometricElement<?> targetContentAnchorage;
        if (updateVisualOperation == null) {
            return null;
        }
        FXGeometricCurve curve = this.getContent();
        List<Point> oldWayPoints = curve.getWayPointsCopy();
        List newWayPoints = ((FXConnection)this.getVisual()).getWayPoints();
        ChangeWayPointsOperation updateModelOperation = new ChangeWayPointsOperation("Update Model", curve, oldWayPoints, newWayPoints);
        ContentPolicy contentPolicy = (ContentPolicy)this.getAdapter(ContentPolicy.class);
        contentPolicy.init();
        contentPolicy.detachFromAllContentAnchorages();
        IUndoableOperation detachOperation = contentPolicy.commit();
        contentPolicy.init();
        AbstractFXGeometricElement<?> sourceContentAnchorage = this.getAnchorageContent(((FXConnection)this.getVisual()).getStartAnchor());
        if (sourceContentAnchorage != null) {
            contentPolicy.attachToContentAnchorage(sourceContentAnchorage, "START");
        }
        if ((targetContentAnchorage = this.getAnchorageContent(((FXConnection)this.getVisual()).getEndAnchor())) != null) {
            contentPolicy.attachToContentAnchorage(targetContentAnchorage, "END");
        }
        IUndoableOperation attachOperation = contentPolicy.commit();
        return new ForwardUndoCompositeOperation(updateVisualOperation.getLabel(), updateVisualOperation, (IUndoableOperation)updateModelOperation, detachOperation, attachOperation){
            {
                this.add(iUndoableOperation);
                this.add(iUndoableOperation2);
                if (iUndoableOperation3 != null || iUndoableOperation4 != null) {
                    this.add((IUndoableOperation)new ReverseUndoCompositeOperation("Change Anchorages", iUndoableOperation3, iUndoableOperation4){
                        {
                            if (iUndoableOperation != null) {
                                this.add(iUndoableOperation);
                            }
                            if (iUndoableOperation2 != null) {
                                this.add(iUndoableOperation2);
                            }
                        }
                    });
                }
            }
        };
    }

    protected FXConnection createVisual() {
        FXConnection visual = new FXConnection();
        visual.setRouter((IFXConnectionRouter)new FXPolyBezierConnectionRouter());
        return visual;
    }

    protected void detachFromAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        if (role.equals("START")) {
            ((FXConnection)this.getVisual()).setStartPoint(((FXConnection)this.getVisual()).getStartPoint());
        } else if (role.equals("END")) {
            ((FXConnection)this.getVisual()).setEndPoint(((FXConnection)this.getVisual()).getEndPoint());
        } else {
            throw new IllegalStateException("Cannot detach from anchor with role <" + role + ">.");
        }
    }

    public void detachFromContentAnchorage(Object contentAnchorage, String role) {
        if ("START".equals(role)) {
            this.getContent().getSourceAnchorages().remove(contentAnchorage);
        } else if ("END".equals(role)) {
            this.getContent().getTargetAnchorages().remove(contentAnchorage);
        }
    }

    @Override
    public void doRefreshVisual(FXConnection visual) {
        Shape endDecorationVisual;
        FXGeometricCurve content = this.getContent();
        List<Point> wayPoints = content.getWayPoints();
        AffineTransform transform = content.getTransform();
        if ((this.previousContent == null || transform != null && !transform.equals((Object)this.previousContent.getTransform()) || transform == null && this.previousContent.getTransform() != null) && transform != null) {
            Point[] transformedWayPoints = transform.getTransformed(wayPoints.toArray(new Point[0]));
            wayPoints = Arrays.asList(transformedWayPoints);
        }
        if (!visual.getWayPoints().equals(wayPoints)) {
            visual.setWayPoints(wayPoints);
        }
        switch (content.getSourceDecoration()) {
            case NONE: {
                if (visual.getStartDecoration() == null) break;
                visual.setStartDecoration(null);
                break;
            }
            case CIRCLE: {
                if (visual.getStartDecoration() != null && visual.getStartDecoration() instanceof CircleHead) break;
                visual.setStartDecoration((IFXDecoration)this.START_CIRCLE_HEAD);
                break;
            }
            case ARROW: {
                if (visual.getStartDecoration() != null && visual.getStartDecoration() instanceof ArrowHead) break;
                visual.setStartDecoration((IFXDecoration)this.START_ARROW_HEAD);
            }
        }
        switch (content.getTargetDecoration()) {
            case NONE: {
                if (visual.getEndDecoration() == null) break;
                visual.setEndDecoration(null);
                break;
            }
            case CIRCLE: {
                if (visual.getEndDecoration() != null && visual.getEndDecoration() instanceof CircleHead) break;
                visual.setEndDecoration((IFXDecoration)this.END_CIRCLE_HEAD);
                break;
            }
            case ARROW: {
                if (visual.getEndDecoration() != null && visual.getEndDecoration() instanceof ArrowHead) break;
                visual.setEndDecoration((IFXDecoration)this.END_ARROW_HEAD);
            }
        }
        Shape startDecorationVisual = visual.getStartDecoration() != null ? (Shape)visual.getStartDecoration().getVisual() : null;
        Shape shape = endDecorationVisual = visual.getEndDecoration() != null ? (Shape)visual.getEndDecoration().getVisual() : null;
        if (visual.getCurveNode().getStroke() != content.getStroke()) {
            visual.getCurveNode().setStroke(content.getStroke());
        }
        if (startDecorationVisual != null && startDecorationVisual.getStroke() != content.getStroke()) {
            startDecorationVisual.setStroke(content.getStroke());
        }
        if (endDecorationVisual != null && endDecorationVisual.getStroke() != content.getStroke()) {
            endDecorationVisual.setStroke(content.getStroke());
        }
        if (visual.getCurveNode().getStrokeWidth() != content.getStrokeWidth()) {
            visual.getCurveNode().setStrokeWidth(content.getStrokeWidth());
        }
        if (startDecorationVisual != null && startDecorationVisual.getStrokeWidth() != content.getStrokeWidth()) {
            startDecorationVisual.setStrokeWidth(content.getStrokeWidth());
        }
        if (endDecorationVisual != null && endDecorationVisual.getStrokeWidth() != content.getStrokeWidth()) {
            endDecorationVisual.setStrokeWidth(content.getStrokeWidth());
        }
        ArrayList<Double> dashList = new ArrayList<Double>(content.dashes.length);
        double[] dArray = content.dashes;
        int n = content.dashes.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            dashList.add(d);
            ++n2;
        }
        if (!visual.getCurveNode().getStrokeDashArray().equals(dashList)) {
            visual.getCurveNode().getStrokeDashArray().setAll(dashList);
        }
        this.previousContent = content;
        super.doRefreshVisual(visual);
    }

    protected AbstractFXGeometricElement<?> getAnchorageContent(IFXAnchor anchor) {
        Object content;
        Node anchorageNode = anchor.getAnchorage();
        IVisualPart part = (IVisualPart)this.getViewer().getVisualPartMap().get(anchorageNode);
        if (part instanceof IContentPart && (content = ((IContentPart)part).getContent()) instanceof AbstractFXGeometricElement) {
            return (AbstractFXGeometricElement)content;
        }
        return null;
    }

    @Override
    public FXGeometricCurve getContent() {
        return (FXGeometricCurve)super.getContent();
    }

    public SetMultimap<Object, String> getContentAnchorages() {
        HashMultimap anchorages = HashMultimap.create();
        Set<AbstractFXGeometricElement<? extends IGeometry>> sourceAnchorages = this.getContent().getSourceAnchorages();
        for (AbstractFXGeometricElement<? extends IGeometry> src : sourceAnchorages) {
            anchorages.put(src, (Object)"START");
        }
        Set<AbstractFXGeometricElement<? extends IGeometry>> targetAnchorages = this.getContent().getTargetAnchorages();
        for (AbstractFXGeometricElement<? extends IGeometry> dst : targetAnchorages) {
            anchorages.put(dst, (Object)"END");
        }
        return anchorages;
    }

    public void setContent(Object model) {
        if (model != null && !(model instanceof FXGeometricCurve)) {
            throw new IllegalArgumentException("Only ICurve models are supported.");
        }
        super.setContent(model);
    }

    public static class ArrowHead
    extends Polyline
    implements IFXDecoration {
        public ArrowHead() {
            super(new double[]{15.0, 0.0, 10.0, 0.0, 10.0, 3.0, 0.0, 0.0, 10.0, -3.0, 10.0, 0.0});
        }

        public Point getLocalEndPoint() {
            return new Point(15.0, 0.0);
        }

        public Point getLocalStartPoint() {
            return new Point(0.0, 0.0);
        }

        public Node getVisual() {
            return this;
        }
    }

    private static final class ChangeWayPointsOperation
    extends AbstractOperation {
        private final FXGeometricCurve curve;
        private final List<Point> newWayPoints;
        private final List<Point> oldWayPoints;

        public ChangeWayPointsOperation(String label, FXGeometricCurve curve, List<Point> oldWayPoints, List<Point> newWayPoints) {
            super(label);
            this.curve = curve;
            this.oldWayPoints = oldWayPoints;
            this.newWayPoints = newWayPoints;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
            this.curve.setWayPoints(this.newWayPoints.toArray(new Point[0]));
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
            return this.execute(monitor, info);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
            this.curve.setWayPoints(this.oldWayPoints.toArray(new Point[0]));
            return Status.OK_STATUS;
        }
    }

    public static class CircleHead
    extends Circle
    implements IFXDecoration {
        public CircleHead() {
            super(5.0);
        }

        public Point getLocalEndPoint() {
            return new Point(0.0, 0.0);
        }

        public Point getLocalStartPoint() {
            return new Point(0.0, 0.0);
        }

        public Node getVisual() {
            return this;
        }
    }
}

