/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Paint;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.PolyBezier;
import org.eclipse.gef4.mvc.examples.logo.model.AbstractFXGeometricElement;

public class FXGeometricCurve
extends AbstractFXGeometricElement<ICurve> {
    public static final String SOURCE_DECORATION_PROPERTY = "sourceDecoration";
    public static final String TARGET_DECORATION_PROPERTY = "targetDecoration";
    private final List<Point> waypoints = new ArrayList<Point>();
    private Decoration sourceDecoration = Decoration.NONE;
    private Decoration targetDecoration = Decoration.NONE;
    public double[] dashes = new double[0];
    private final Set<AbstractFXGeometricElement<? extends IGeometry>> sourceAnchorages = new HashSet<AbstractFXGeometricElement<? extends IGeometry>>();
    private final Set<AbstractFXGeometricElement<? extends IGeometry>> targetAnchorages = new HashSet<AbstractFXGeometricElement<? extends IGeometry>>();

    public static ICurve constructCurveFromWayPoints(Point ... waypoints) {
        if (waypoints == null || waypoints.length == 0) {
            waypoints = new Point[]{new Point(), new Point()};
        } else if (waypoints.length == 1) {
            waypoints = new Point[]{new Point(), waypoints[0]};
        }
        return PolyBezier.interpolateCubic((Point[])waypoints);
    }

    public FXGeometricCurve(Point[] waypoints, Paint stroke, double strokeWidth, double[] dashes, Effect effect) {
        super(FXGeometricCurve.constructCurveFromWayPoints(waypoints), stroke, strokeWidth, effect);
        this.waypoints.addAll(Arrays.asList(waypoints));
        this.dashes = dashes;
    }

    public void addSourceAnchorage(AbstractFXGeometricElement<? extends IGeometry> anchored) {
        this.sourceAnchorages.add(anchored);
    }

    public void addTargetAnchorage(AbstractFXGeometricElement<? extends IGeometry> anchored) {
        this.targetAnchorages.add(anchored);
    }

    public void addWayPoint(int i, Point p) {
        List<Point> points = this.getWayPointsCopy();
        points.add(i, p);
        this.setWayPoints(points.toArray(new Point[0]));
    }

    public double[] getDashes() {
        return Arrays.copyOf(this.dashes, this.dashes.length);
    }

    public Set<AbstractFXGeometricElement<? extends IGeometry>> getSourceAnchorages() {
        return this.sourceAnchorages;
    }

    public Decoration getSourceDecoration() {
        return this.sourceDecoration;
    }

    public Set<AbstractFXGeometricElement<? extends IGeometry>> getTargetAnchorages() {
        return this.targetAnchorages;
    }

    public Decoration getTargetDecoration() {
        return this.targetDecoration;
    }

    public List<Point> getWayPoints() {
        return Collections.unmodifiableList(this.waypoints);
    }

    public List<Point> getWayPointsCopy() {
        return new ArrayList<Point>(this.waypoints);
    }

    public void removeWayPoint(int i) {
        List<Point> points = this.getWayPointsCopy();
        points.remove(i);
        this.setWayPoints(points.toArray(new Point[0]));
    }

    public void setSourceDecoration(Decoration sourceDecoration) {
        Decoration oldSourceDecoration = this.sourceDecoration;
        this.sourceDecoration = sourceDecoration;
        this.pcs.firePropertyChange(SOURCE_DECORATION_PROPERTY, (Object)oldSourceDecoration, (Object)sourceDecoration);
    }

    public void setTargetDecoration(Decoration targetDecoration) {
        Decoration oldTargetDecoration = this.targetDecoration;
        this.targetDecoration = targetDecoration;
        this.pcs.firePropertyChange(TARGET_DECORATION_PROPERTY, (Object)oldTargetDecoration, (Object)targetDecoration);
    }

    public void setWayPoint(int i, Point p) {
        List<Point> points = this.getWayPointsCopy();
        points.set(i, p);
        this.setWayPoints(points.toArray(new Point[0]));
    }

    public void setWayPoints(Point ... waypoints) {
        this.waypoints.clear();
        this.waypoints.addAll(Arrays.asList(waypoints));
        this.setGeometry(FXGeometricCurve.constructCurveFromWayPoints(waypoints));
    }

    public static enum Decoration {
        NONE,
        ARROW,
        CIRCLE;

    }
}

