/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.gef4.common.properties.IPropertyChangeNotifier;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.IGeometry;

public abstract class AbstractFXGeometricElement<G extends IGeometry>
implements IPropertyChangeNotifier {
    public static final String GEOMETRY_PROPERTY = "Geometry";
    public static final String TRANSFORM_PROPERTY = "Transform";
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private G geometry;
    private AffineTransform transform;
    private Paint stroke = new Color(0.0, 0.0, 0.0, 1.0);
    private Effect effect;
    private double strokeWidth = 0.5;

    public AbstractFXGeometricElement(G geometry, AffineTransform transform, Paint stroke, double strokeWidth, Effect effect) {
        this(geometry);
        this.setTransform(transform);
        this.setEffect(effect);
        this.setStroke(stroke);
        this.setStrokeWidth(strokeWidth);
    }

    public AbstractFXGeometricElement(G geometry, Paint stroke, double strokeWidth, Effect effect) {
        this.setGeometry(geometry);
        this.setEffect(effect);
        this.setStroke(stroke);
        this.setStrokeWidth(strokeWidth);
    }

    public AbstractFXGeometricElement(G geometry) {
        this.setGeometry(geometry);
    }

    public G getGeometry() {
        return this.geometry;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void setGeometry(G geometry) {
        G old = this.geometry;
        this.geometry = geometry;
        this.pcs.firePropertyChange(GEOMETRY_PROPERTY, old, geometry);
    }

    public void setTransform(AffineTransform transform) {
        AffineTransform old = this.transform;
        this.transform = transform;
        this.pcs.firePropertyChange(TRANSFORM_PROPERTY, old, transform);
    }

    public Effect getEffect() {
        return this.effect;
    }

    public void setEffect(Effect effect) {
        this.effect = effect;
    }

    public Paint getStroke() {
        return this.stroke;
    }

    public void setStroke(Paint stroke) {
        this.stroke = stroke;
    }

    public double getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(double strokeWidth) {
        this.strokeWidth = strokeWidth;
    }
}

