/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout;

import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.layout.IConnectionLayout;
import org.eclipse.gef4.layout.IEntityLayout;
import org.eclipse.gef4.layout.ILayoutContext;
import org.eclipse.gef4.layout.INodeLayout;
import org.eclipse.gef4.layout.ISubgraphLayout;

public class LayoutProperties {
    public static final String BOUNDS_PROPERTY = "bounds";
    public static final Rectangle DEFAULT_BOUNDS = new Rectangle();
    public static final String BOUNDS_EXPANDABLE_PROPERTY = "bounds-expandable";
    public static final Boolean DEFAULT_BOUNDS_EXPANDABLE = false;
    public static final String PRUNING_ENABLED_PROPERTY = "pruning-enabled";
    public static final Boolean DEFAULT_PRUNING_ENABLED = true;
    public static final String DYNAMIC_LAYOUT_ENABLED_PROPERTY = "dynamic-layout-enabled";
    public static final Boolean DEFAULT_DYNAMIC_LAYOUT_ENABLED = true;
    public static final String LOCATION_PROPERTY = "location";
    public static final Point DEFAULT_LOCATION = new Point();
    public static final String SIZE_PROPERTY = "size";
    public static final Dimension DEFAULT_SIZE = new Dimension();
    public static final String MOVABLE_PROPERTY = "movable";
    public static final Boolean DEFAULT_MOVABLE = true;
    public static final String RESIZABLE_PROPERTY = "resizable";
    public static final Boolean DEFAULT_RESIZABLE = true;
    public static final String ASPECT_RATIO_PROPERTY = "aspect-ratio";
    public static final Double DEFAULT_ASPECT_RATIO = 0.0;
    public static final String VISIBLE_PROPERTY = "visible";
    public static final Boolean DEFAULT_VISIBLE = true;
    public static final String MINIMIZED_PROPERTY = "minimized";
    public static final Boolean DEFAULT_MINIMIZED = false;
    public static final String PRUNABLE_PROPERTY = "prunable";
    public static final Boolean DEFAULT_PRUNABLE = true;
    public static final String WEIGHT_PROPERTY = "weight";
    public static final Double DEFAULT_WEIGHT = 0.0;
    public static final String DIRECTED_PROPERTY = "directed";
    public static final Boolean DEFAULT_DIRECTED = true;
    public static final int DIRECTION_TOP_DOWN = 1;
    public static final int DIRECTION_BOTTOM_UP = 2;
    public static final int DIRECTION_LEFT_RIGHT = 3;
    public static final int DIRECTION_RIGHT_LEFT = 4;
    public static final String DIRECTION_PROPERTY = "direction";
    public static final Integer DEFAULT_DIRECTION = 1;
    public static final String DIRECTION_DEPENDANT_PROPERTY = "direction-dependant";
    public static final Boolean DEFAULT_DIRECTION_DEPENDANT = true;

    public static Rectangle getBounds(ILayoutContext graph) {
        Object bounds = graph.getProperty(BOUNDS_PROPERTY);
        if (bounds instanceof Rectangle) {
            return ((Rectangle)bounds).getCopy();
        }
        return DEFAULT_BOUNDS.getCopy();
    }

    public static void setBounds(ILayoutContext graph, Rectangle bounds) {
        graph.setProperty(BOUNDS_PROPERTY, bounds);
    }

    public static Boolean isBoundsExpandable(ILayoutContext graph) {
        Object boundsExpandable = graph.getProperty(BOUNDS_EXPANDABLE_PROPERTY);
        if (boundsExpandable instanceof Boolean) {
            return (Boolean)boundsExpandable;
        }
        return DEFAULT_BOUNDS_EXPANDABLE;
    }

    public static void setBoundsExpandable(ILayoutContext graph, boolean boundsExpandable) {
        graph.setProperty(BOUNDS_EXPANDABLE_PROPERTY, boundsExpandable);
    }

    public static Boolean isDynamicLayoutEnables(ILayoutContext graph) {
        Object dynamicLayoutEnabled = graph.getProperty(DYNAMIC_LAYOUT_ENABLED_PROPERTY);
        if (dynamicLayoutEnabled instanceof Boolean) {
            return (Boolean)dynamicLayoutEnabled;
        }
        return DEFAULT_DYNAMIC_LAYOUT_ENABLED;
    }

    public static void setDynamicLayoutEnabled(ILayoutContext graph, boolean dynamicLayoutEnabled) {
        graph.setProperty(DYNAMIC_LAYOUT_ENABLED_PROPERTY, dynamicLayoutEnabled);
    }

    public static Point getLocation(IEntityLayout entity) {
        Object location = entity.getProperty(LOCATION_PROPERTY);
        if (location instanceof Point) {
            return ((Point)location).getCopy();
        }
        return DEFAULT_LOCATION.getCopy();
    }

    public static Dimension getSize(IEntityLayout entity) {
        Object size = entity.getProperty(SIZE_PROPERTY);
        if (size instanceof Dimension) {
            return ((Dimension)size).getCopy();
        }
        return DEFAULT_SIZE.getCopy();
    }

    public static Double getPreferredAspectRatio(IEntityLayout entity) {
        Object ar = entity.getProperty(ASPECT_RATIO_PROPERTY);
        if (ar instanceof Double) {
            return (Double)ar;
        }
        return DEFAULT_ASPECT_RATIO;
    }

    public static Boolean isResizable(IEntityLayout entity) {
        Object resizable = entity.getProperty(RESIZABLE_PROPERTY);
        if (resizable instanceof Boolean) {
            return (Boolean)resizable;
        }
        return DEFAULT_RESIZABLE;
    }

    public static Boolean isMovable(IEntityLayout entity) {
        Object movable = entity.getProperty(MOVABLE_PROPERTY);
        if (movable instanceof Boolean) {
            return (Boolean)movable;
        }
        return DEFAULT_MOVABLE;
    }

    public static void setLocation(IEntityLayout entity, double x, double y) {
        if (Double.isNaN(x)) {
            x = 0.0;
        }
        if (Double.isNaN(y)) {
            y = 0.0;
        }
        entity.setProperty(LOCATION_PROPERTY, new Point(x, y));
    }

    public static void setSize(IEntityLayout entity, double w, double h) {
        if (Double.isNaN(w)) {
            w = 0.0;
        }
        if (Double.isNaN(h)) {
            h = 0.0;
        }
        entity.setProperty(SIZE_PROPERTY, new Dimension(w, h));
    }

    public static void setResizable(IEntityLayout entity, boolean resizable) {
        entity.setProperty(RESIZABLE_PROPERTY, resizable);
    }

    public static Boolean isMinimized(INodeLayout node) {
        Object minimized = node.getProperty(MINIMIZED_PROPERTY);
        if (minimized instanceof Boolean) {
            return (Boolean)minimized;
        }
        return DEFAULT_MINIMIZED;
    }

    public static void setMinimized(INodeLayout node, boolean minimized) {
        node.setProperty(MINIMIZED_PROPERTY, minimized);
    }

    public static Boolean isPrunable(INodeLayout node) {
        Object prunable = node.getProperty(PRUNABLE_PROPERTY);
        if (prunable instanceof Boolean) {
            return (Boolean)prunable;
        }
        return DEFAULT_PRUNABLE;
    }

    public static Boolean isPruned(INodeLayout node) {
        if (node.getSubgraph() != null) {
            return true;
        }
        return false;
    }

    public static void setPrunable(INodeLayout node, boolean prunable) {
        node.setProperty(PRUNABLE_PROPERTY, prunable);
    }

    public static Boolean isDirected(IConnectionLayout edge) {
        Object directed = edge.getProperty(DIRECTED_PROPERTY);
        if (directed instanceof Boolean) {
            return (Boolean)directed;
        }
        return DEFAULT_DIRECTED;
    }

    public static Boolean isVisible(IConnectionLayout edge) {
        Object visible = edge.getProperty(VISIBLE_PROPERTY);
        if (visible instanceof Boolean) {
            return (Boolean)visible;
        }
        return DEFAULT_VISIBLE;
    }

    public static Boolean isVisible(IEntityLayout entity) {
        Object visible = entity.getProperty(VISIBLE_PROPERTY);
        if (visible instanceof Boolean) {
            return (Boolean)visible;
        }
        return DEFAULT_VISIBLE;
    }

    public static Double getWeight(IConnectionLayout edge) {
        Object weight = edge.getProperty(WEIGHT_PROPERTY);
        if (weight instanceof Double) {
            return (Double)weight;
        }
        return DEFAULT_WEIGHT;
    }

    public static void setDirected(IConnectionLayout edge, boolean directed) {
        edge.setProperty(DIRECTED_PROPERTY, directed);
    }

    public static void setVisible(IConnectionLayout edge, boolean visible) {
        edge.setProperty(VISIBLE_PROPERTY, visible);
    }

    public static void setWeight(IConnectionLayout edge, double weight) {
        edge.setProperty(WEIGHT_PROPERTY, weight);
    }

    public static void setDirectionDependant(ISubgraphLayout subgraph, boolean isDirectionDependant) {
        subgraph.setProperty(DIRECTION_DEPENDANT_PROPERTY, isDirectionDependant);
    }

    public static void setDirection(ISubgraphLayout subgraph, int direction) {
        subgraph.setProperty(DIRECTION_PROPERTY, direction);
    }

    public static Boolean isDirectionDependant(ISubgraphLayout subgraph) {
        Object directionDependant = subgraph.getProperty(DIRECTION_DEPENDANT_PROPERTY);
        if (directionDependant instanceof Boolean) {
            return (Boolean)directionDependant;
        }
        return DEFAULT_DIRECTION_DEPENDANT;
    }

    public static Integer getDirection(ISubgraphLayout subgraph) {
        Object direction = subgraph.getProperty(DIRECTION_PROPERTY);
        if (direction instanceof Integer) {
            return (Integer)direction;
        }
        return DEFAULT_DIRECTION;
    }
}

