/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.graph;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.gef4.common.notify.IMapObserver;
import org.eclipse.gef4.common.notify.ObservableMap;
import org.eclipse.gef4.common.properties.IPropertyChangeNotifier;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.graph.Node;

public final class Edge
implements IPropertyChangeNotifier {
    public static final String ATTRIBUTES_PROPERTY = "attributes";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private IMapObserver<String, Object> attributesObserver = new IMapObserver<String, Object>(){

        public void afterChange(ObservableMap<String, Object> observableMap, Map<String, Object> previousMap) {
            Edge.this.pcs.firePropertyChange(Edge.ATTRIBUTES_PROPERTY, previousMap, observableMap);
        }
    };
    private final ObservableMap<String, Object> attrs = new ObservableMap();
    private Node source;
    private Node target;
    private Graph graph;

    public Edge(Map<String, Object> attrs, Node source, Node target) {
        this.attrs.putAll(attrs);
        this.attrs.addMapObserver(this.attributesObserver);
        this.source = source;
        this.target = target;
    }

    public Edge(Node source, Node target) {
        this(new HashMap<String, Object>(), source, target);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Edge)) {
            return false;
        }
        Edge thatEdge = (Edge)that;
        boolean attrsEqual = this.getAttrs().equals(thatEdge.getAttrs());
        boolean sourceEqual = this.getSource().equals(thatEdge.getSource());
        boolean targetEqual = this.getTarget().equals(thatEdge.getTarget());
        return attrsEqual && sourceEqual && targetEqual;
    }

    public Map<String, Object> getAttrs() {
        return this.attrs;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Node getSource() {
        return this.source;
    }

    public Node getTarget() {
        return this.target;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getAttrs().hashCode();
        result = 31 * result + this.getSource().hashCode();
        result = 31 * result + this.getTarget().hashCode();
        return result;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void setSource(Node source) {
        this.source = source;
    }

    public void setTarget(Node target) {
        this.target = target;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Edge {");
        boolean separator = false;
        TreeMap<String, Object> sortedAttrs = new TreeMap<String, Object>();
        sortedAttrs.putAll((Map<String, Object>)this.attrs);
        for (Object attrKey : sortedAttrs.keySet()) {
            if (separator) {
                sb.append(", ");
            } else {
                separator = true;
            }
            sb.append(String.valueOf(attrKey.toString()) + " : " + this.attrs.get(attrKey));
        }
        sb.append("} from " + this.getSource() + " to " + this.getTarget());
        return sb.toString();
    }

    public static class Builder {
        private Map<String, Object> attrs = new HashMap<String, Object>();
        private Node source;
        private Node target;

        public Builder(Node source, Node target) {
            this.source = source;
            this.target = target;
        }

        public Builder attr(String key, Object value) {
            this.attrs.put(key, value);
            return this;
        }

        public Edge build() {
            return new Edge(this.attrs, this.source, this.target);
        }
    }
}

