/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.convert.fx;

import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.transform.Affine;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;

public class Geometry2JavaFX {
    private Geometry2JavaFX() {
    }

    public static final Bounds toFXBounds(Rectangle r) {
        return new BoundingBox(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public static final Affine toFXAffine(AffineTransform transform) {
        Affine affine = new Affine();
        affine.setMxx(transform.getM00());
        affine.setMxy(transform.getM01());
        affine.setMyx(transform.getM10());
        affine.setMyy(transform.getM11());
        affine.setTx(transform.getTranslateX());
        affine.setTy(transform.getTranslateY());
        return affine;
    }

    public static final Point2D toFXPoint(Point p) {
        return new Point2D(p.x, p.y);
    }

    public static PathElement[] toPathElements(org.eclipse.gef4.geometry.planar.Path path) {
        Path.Segment[] segments = path.getSegments();
        PathElement[] elements = new PathElement[segments.length];
        int i = 0;
        while (i < segments.length) {
            Point[] points = segments[i].getPoints();
            switch (segments[i].getType()) {
                case 0: {
                    elements[i] = new MoveTo(points[0].x, points[0].y);
                    break;
                }
                case 1: {
                    elements[i] = new LineTo(points[0].x, points[0].y);
                    break;
                }
                case 2: {
                    elements[i] = new QuadCurveTo(points[0].x, points[0].y, points[1].x, points[1].y);
                    break;
                }
                case 3: {
                    elements[i] = new CubicCurveTo(points[0].x, points[0].y, points[1].x, points[1].y, points[2].x, points[2].y);
                    break;
                }
                case 4: {
                    elements[i] = new ClosePath();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown Path.Segment: <" + segments[i] + ">");
                }
            }
            ++i;
        }
        return elements;
    }

    public static Path toPath(org.eclipse.gef4.geometry.planar.Path path) {
        Path fxPath = new Path(Geometry2JavaFX.toPathElements(path));
        fxPath.setFillRule(path.getWindingRule() == 0 ? FillRule.EVEN_ODD : FillRule.NON_ZERO);
        return fxPath;
    }
}

