/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.anchors;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.ReadOnlyMapWrapper;
import javafx.collections.MapChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.fx.anchors.AbstractFXAnchor;
import org.eclipse.gef4.fx.anchors.AnchorKey;
import org.eclipse.gef4.fx.nodes.FXGeometryNode;
import org.eclipse.gef4.fx.nodes.FXUtils;
import org.eclipse.gef4.geometry.convert.fx.Geometry2JavaFX;
import org.eclipse.gef4.geometry.convert.fx.JavaFX2Geometry;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IShape;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;

public class FXChopBoxAnchor
extends AbstractFXAnchor {
    private Map<AnchorKey, ReferencePointProvider> anchoredReferencePointProviders = new HashMap<AnchorKey, ReferencePointProvider>();
    private MapChangeListener<AnchorKey, Point> anchoredReferencePointsChangeListener = new MapChangeListener<AnchorKey, Point>(){

        public void onChanged(MapChangeListener.Change<? extends AnchorKey, ? extends Point> change) {
            if (change.wasAdded()) {
                if (change.getKey() == null) {
                    throw new IllegalStateException("Attempt to put <null> key into reference point map!");
                }
                if (change.getValueAdded() == null) {
                    throw new IllegalStateException("Attempt to put <null> value into reference point map!");
                }
                if (FXChopBoxAnchor.this.anchoredReferencePointProviders.containsKey(change.getKey())) {
                    FXChopBoxAnchor.this.updatePosition((AnchorKey)change.getKey());
                }
            }
        }
    };
    private ComputationStrategy computationStrategy;

    public FXChopBoxAnchor(Node anchorage) {
        this(anchorage, new ComputationStrategy.Impl());
    }

    public FXChopBoxAnchor(Node anchorage, ComputationStrategy computationStrategy) {
        super(anchorage);
        this.computationStrategy = computationStrategy;
    }

    @Override
    public void attach(AnchorKey key, IAdaptable info) {
        ReferencePointProvider referencePointProvider = (ReferencePointProvider)info.getAdapter(ReferencePointProvider.class);
        if (referencePointProvider == null) {
            throw new IllegalArgumentException("No ReferencePointProvider could be obtained via info.");
        }
        this.anchoredReferencePointProviders.put(key, referencePointProvider);
        super.attach(key, info);
        referencePointProvider.referencePointProperty().addListener(this.anchoredReferencePointsChangeListener);
    }

    @Override
    protected Point computePosition(AnchorKey key) {
        Point referencePoint = (Point)this.anchoredReferencePointProviders.get(key).referencePointProperty().get((Object)key);
        if (referencePoint == null) {
            throw new IllegalStateException("The ReferencePointProvider does not provide a reference point for this key: " + key);
        }
        return this.computePosition(key.getAnchored(), referencePoint);
    }

    protected Point computePosition(Node anchored, Point anchoredReferencePointInLocal) {
        return JavaFX2Geometry.toPoint((Point2D)anchored.sceneToLocal(Geometry2JavaFX.toFXPoint((Point)this.computationStrategy.computePositionInScene(this.getAnchorage(), anchored, anchoredReferencePointInLocal))));
    }

    @Override
    public void detach(AnchorKey key, IAdaptable info) {
        ReferencePointProvider helper = (ReferencePointProvider)info.getAdapter(ReferencePointProvider.class);
        if (helper == null) {
            throw new IllegalArgumentException("No FXChopBoxHelper could be obtained via info.");
        }
        if (this.anchoredReferencePointProviders.get(key) != helper) {
            throw new IllegalStateException("The passed in FXChopBoxHelper had not been obtained for " + key + " within attach() before.");
        }
        helper.referencePointProperty().removeListener(this.anchoredReferencePointsChangeListener);
        super.detach(key, info);
        this.anchoredReferencePointProviders.remove(key);
    }

    public static interface ComputationStrategy {
        public Point computePositionInScene(Node var1, Node var2, Point var3);

        public static class Impl
        implements ComputationStrategy {
            public Point computeAnchorageReferencePointInLocal(Node node, IGeometry geometryInLocal) {
                if (!(geometryInLocal instanceof IShape) && !(geometryInLocal instanceof ICurve)) {
                    throw new IllegalArgumentException("The given IGeometry is neither an IShape nor an ICurve.");
                }
                Point boundsCenterInLocal = geometryInLocal.getBounds().getCenter();
                if (!geometryInLocal.contains(boundsCenterInLocal)) {
                    if (geometryInLocal instanceof IShape) {
                        Point nearestVertex = this.getNearestVertex(boundsCenterInLocal, (IShape)geometryInLocal);
                        if (nearestVertex != null) {
                            return nearestVertex;
                        }
                        throw new IllegalArgumentException("The given IShape does not provide any vertices.");
                    }
                    return ((ICurve)geometryInLocal).getP1();
                }
                return boundsCenterInLocal;
            }

            protected Point computeAnchorageReferencePointInScene(Node node, IGeometry geometryInLocal) {
                return FXUtils.localToScene(node, this.computeAnchorageReferencePointInLocal(node, geometryInLocal));
            }

            @Override
            public Point computePositionInScene(Node anchorage, Node anchored, Point anchoredReferencePointInLocal) {
                IGeometry anchorageReferenceGeometryInLocal = this.getAnchorageReferenceGeometryInLocal(anchorage);
                Point anchoredReferencePointInScene = FXUtils.localToScene(anchored, anchoredReferencePointInLocal);
                Point anchorageReferencePointInScene = this.computeAnchorageReferencePointInScene(anchorage, anchorageReferenceGeometryInLocal);
                Line referenceLineInScene = new Line(anchorageReferencePointInScene, anchoredReferencePointInScene);
                IGeometry anchorageGeometryInScene = FXUtils.localToScene(anchorage, anchorageReferenceGeometryInLocal);
                ICurve anchorageOutlineInScene = this.getOutline(anchorageGeometryInScene);
                Point nearestIntersectionInScene = anchorageOutlineInScene.getNearestIntersection((ICurve)referenceLineInScene, anchoredReferencePointInScene);
                if (nearestIntersectionInScene != null) {
                    return nearestIntersectionInScene;
                }
                return anchorageReferencePointInScene;
            }

            protected IGeometry getAnchorageReferenceGeometryInLocal(Node anchorage) {
                Rectangle geometry = null;
                if (anchorage instanceof FXGeometryNode) {
                    geometry = (Rectangle)((FXGeometryNode)anchorage).getGeometry();
                }
                if (!(geometry instanceof IShape)) {
                    geometry = JavaFX2Geometry.toRectangle((Bounds)anchorage.getLayoutBounds());
                }
                return geometry;
            }

            protected Point getNearestVertex(Point boundsCenter, IShape shape) {
                ICurve[] outlineSegments = shape.getOutlineSegments();
                if (outlineSegments.length == 0) {
                    return null;
                }
                Point nearestVertex = outlineSegments[0].getP1();
                double minDistance = boundsCenter.getDistance(nearestVertex);
                int i = 1;
                while (i < outlineSegments.length) {
                    Point v = outlineSegments[i].getP1();
                    double d = boundsCenter.getDistance(v);
                    if (d < minDistance) {
                        nearestVertex = v;
                        minDistance = d;
                    }
                    ++i;
                }
                return nearestVertex;
            }

            protected ICurve getOutline(IGeometry geometry) {
                if (!(geometry instanceof IShape) && !(geometry instanceof ICurve)) {
                    throw new IllegalArgumentException("The given IGeometry is neither an ICurve nor an IShape.");
                }
                if (geometry instanceof IShape) {
                    return ((IShape)geometry).getOutline();
                }
                if (geometry instanceof ICurve) {
                    return (ICurve)geometry;
                }
                throw new IllegalStateException("The transformed geometry is neither an ICurve nor an IShape.");
            }
        }
    }

    public static interface ReferencePointProvider {
        public ReadOnlyMapWrapper<AnchorKey, Point> referencePointProperty();
    }
}

