/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.ui.gestures;

import com.sun.javafx.tk.TKSceneListener;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.application.Platform;
import javafx.embed.swt.FXCanvas;
import javafx.event.EventType;
import javafx.scene.input.RotateEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.SwipeEvent;
import javafx.scene.input.ZoomEvent;
import org.eclipse.gef4.common.reflect.ReflectionUtils;
import org.eclipse.swt.events.GestureEvent;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SwtToFXGestureConverter
implements GestureListener {
    private FXCanvas canvas;
    private State currentState;
    private Listener emulatedMouseWheelEventFilter;
    private Listener emulatedPanGestureEventFilter;
    private Event lastPanGestureEvent;

    public SwtToFXGestureConverter(final FXCanvas canvas) {
        this.canvas = canvas;
        this.currentState = new State(StateType.IDLE);
        canvas.addGestureListener((GestureListener)this);
        Display display = canvas.getDisplay();
        this.emulatedPanGestureEventFilter = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == canvas && event.detail == 64) {
                    if (event.xDirection == 0 && event.yDirection == 0) {
                        event.type = 0;
                    } else {
                        SwtToFXGestureConverter.this.lastPanGestureEvent = event;
                    }
                }
            }
        };
        display.addFilter(48, this.emulatedPanGestureEventFilter);
        if (display.getTouchEnabled()) {
            this.emulatedMouseWheelEventFilter = new Listener(){

                public void handleEvent(Event event) {
                    if (event.widget == canvas && SwtToFXGestureConverter.this.lastPanGestureEvent != null && ((SwtToFXGestureConverter)SwtToFXGestureConverter.this).lastPanGestureEvent.x == event.x && ((SwtToFXGestureConverter)SwtToFXGestureConverter.this).lastPanGestureEvent.y == event.y) {
                        event.type = 0;
                    }
                }
            };
            display.addFilter(37, this.emulatedMouseWheelEventFilter);
            display.addFilter(38, this.emulatedMouseWheelEventFilter);
        }
    }

    protected boolean changeState(StateType newStateType, GestureEvent event, TKSceneListener sceneListener) {
        if (newStateType != this.currentState.type) {
            switch (this.currentState.type) {
                case SCROLLING: {
                    this.sendScrollEvent((EventType<ScrollEvent>)ScrollEvent.SCROLL_FINISHED, event, sceneListener);
                    break;
                }
                case ROTATING: {
                    this.sendRotateEvent((EventType<RotateEvent>)RotateEvent.ROTATION_FINISHED, event, sceneListener);
                    break;
                }
                case ZOOMING: {
                    this.sendZoomEvent((EventType<ZoomEvent>)ZoomEvent.ZOOM_FINISHED, event, sceneListener);
                }
            }
            switch (newStateType) {
                case SCROLLING: {
                    this.sendScrollEvent((EventType<ScrollEvent>)ScrollEvent.SCROLL_STARTED, event, sceneListener);
                    break;
                }
                case ROTATING: {
                    this.sendRotateEvent((EventType<RotateEvent>)RotateEvent.ROTATION_STARTED, event, sceneListener);
                    break;
                }
                case ZOOMING: {
                    this.sendZoomEvent((EventType<ZoomEvent>)ZoomEvent.ZOOM_STARTED, event, sceneListener);
                    break;
                }
                case IDLE: {
                    if (event.detail != 16) break;
                    this.sendSwipeEvent(event, sceneListener);
                }
            }
            this.currentState = new State(newStateType);
            return true;
        }
        switch (newStateType) {
            case SCROLLING: {
                this.sendScrollEvent((EventType<ScrollEvent>)ScrollEvent.SCROLL, event, sceneListener);
                break;
            }
            case ROTATING: {
                this.sendRotateEvent((EventType<RotateEvent>)RotateEvent.ROTATE, event, sceneListener);
                break;
            }
            case ZOOMING: {
                this.sendZoomEvent((EventType<ZoomEvent>)ZoomEvent.ZOOM, event, sceneListener);
                break;
            }
            case IDLE: {
                if (event.detail != 16) break;
                this.sendSwipeEvent(event, sceneListener);
            }
        }
        return false;
    }

    public void dispose() {
        Display display = this.canvas.getDisplay();
        if (this.emulatedPanGestureEventFilter != null) {
            display.removeFilter(48, this.emulatedPanGestureEventFilter);
        }
        if (this.emulatedMouseWheelEventFilter != null) {
            display.removeFilter(37, this.emulatedMouseWheelEventFilter);
            display.removeFilter(38, this.emulatedMouseWheelEventFilter);
        }
        this.canvas.removeGestureListener((GestureListener)this);
        this.canvas = null;
    }

    public void gesture(GestureEvent event) {
        this.sendGestureEventToFX(event);
    }

    private boolean isAlt(GestureEvent event) {
        return (event.stateMask & 0x10000) != 0;
    }

    private boolean isControl(GestureEvent event) {
        return (event.stateMask & 0x40000) != 0;
    }

    private boolean isMeta(GestureEvent event) {
        return (event.stateMask & 0x400000) != 0;
    }

    private boolean isShift(GestureEvent event) {
        return (event.stateMask & 0x20000) != 0;
    }

    protected void sendGestureEventToFX(final GestureEvent event) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                final Object scenePeer = ReflectionUtils.getPrivateFieldValue((Object)SwtToFXGestureConverter.this.canvas, (String)"scenePeer");
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        TKSceneListener sceneListener = (TKSceneListener)ReflectionUtils.getPrivateFieldValue((Object)scenePeer, (String)"sceneListener");
                        if (sceneListener == null) {
                            return null;
                        }
                        switch (event.detail) {
                            case 2: {
                                break;
                            }
                            case 4: {
                                SwtToFXGestureConverter.this.changeState(StateType.IDLE, event, sceneListener);
                                break;
                            }
                            case 32: {
                                SwtToFXGestureConverter.this.changeState(StateType.ZOOMING, event, sceneListener);
                                break;
                            }
                            case 64: {
                                SwtToFXGestureConverter.this.changeState(StateType.SCROLLING, event, sceneListener);
                                break;
                            }
                            case 8: {
                                SwtToFXGestureConverter.this.changeState(StateType.ROTATING, event, sceneListener);
                                break;
                            }
                            case 16: {
                                SwtToFXGestureConverter.this.changeState(StateType.IDLE, event, sceneListener);
                            }
                        }
                        return null;
                    }
                }, (AccessControlContext)ReflectionUtils.getPrivateFieldValue((Object)scenePeer, (String)"accessCtrlCtx"));
            }
        });
    }

    private void sendRotateEvent(EventType<RotateEvent> fxEventType, GestureEvent event, TKSceneListener sceneListener) {
        Point screenPosition = this.canvas.toDisplay(event.x, event.y);
        double rotation = fxEventType == RotateEvent.ROTATION_FINISHED ? this.currentState.lastRotation : -event.rotation;
        sceneListener.rotateEvent(fxEventType, rotation - this.currentState.lastRotation, rotation, (double)event.x, (double)event.y, (double)screenPosition.x, (double)screenPosition.y, this.isShift(event), this.isControl(event), this.isAlt(event), this.isMeta(event), false, false);
        this.currentState.lastRotation = rotation;
    }

    private void sendScrollEvent(EventType<ScrollEvent> fxEventType, GestureEvent event, TKSceneListener sceneListener) {
        this.currentState.totalScrollX += (double)event.xDirection;
        this.currentState.totalScrollY += (double)event.yDirection;
        Point screenPosition = this.canvas.toDisplay(event.x, event.y);
        sceneListener.scrollEvent(fxEventType, (double)event.xDirection, (double)event.yDirection, 0.0, 0.0, -5.0, -5.0, 0, 0, 0, 0, 0, (double)event.x, (double)event.y, (double)screenPosition.x, (double)screenPosition.y, this.isShift(event), this.isControl(event), this.isAlt(event), this.isMeta(event), false, false);
    }

    private void sendSwipeEvent(GestureEvent event, TKSceneListener sceneListener) {
        Point screenPosition = this.canvas.toDisplay(event.x, event.y);
        EventType fxEventType = null;
        if (event.yDirection > 0) {
            fxEventType = SwipeEvent.SWIPE_DOWN;
        } else if (event.yDirection < 0) {
            fxEventType = SwipeEvent.SWIPE_UP;
        } else if (event.xDirection > 0) {
            fxEventType = SwipeEvent.SWIPE_RIGHT;
        } else if (event.xDirection < 0) {
            fxEventType = SwipeEvent.SWIPE_LEFT;
        }
        sceneListener.swipeEvent(fxEventType, 0, (double)event.x, (double)event.y, (double)screenPosition.x, (double)screenPosition.y, this.isShift(event), this.isControl(event), this.isAlt(event), this.isMeta(event), false);
    }

    private void sendZoomEvent(EventType<ZoomEvent> fxEventType, GestureEvent event, TKSceneListener sceneListener) {
        Point screenPosition = this.canvas.toDisplay(event.x, event.y);
        double magnification = fxEventType == ZoomEvent.ZOOM_FINISHED ? this.currentState.lastZoomFactor : event.magnification;
        sceneListener.zoomEvent(fxEventType, magnification / this.currentState.lastZoomFactor, magnification, (double)event.x, (double)event.y, (double)screenPosition.x, (double)screenPosition.y, this.isShift(event), this.isControl(event), this.isAlt(event), this.isMeta(event), false, false);
        this.currentState.lastZoomFactor = magnification;
    }

    protected class State {
        StateType type;
        double totalScrollX = 0.0;
        double totalScrollY = 0.0;
        double lastZoomFactor = 1.0;
        double lastRotation = 0.0;

        public State(StateType type) {
            this.type = type;
        }
    }

    static enum StateType {
        IDLE,
        SCROLLING,
        ROTATING,
        ZOOMING;

    }
}

