/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.ui.canvas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swt.FXCanvas;
import javafx.embed.swt.SWTFXUtils;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Window;
import org.eclipse.gef4.common.reflect.ReflectionUtils;
import org.eclipse.gef4.fx.ui.gestures.SwtToFXGestureConverter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;

public class FXCanvasEx
extends FXCanvas {
    private static Map<Cursor, Integer> CURSOR_FROM_FX_TO_SWT = new HashMap<Cursor, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Cursor.CLOSED_HAND, 21);
            this.put(Cursor.CROSSHAIR, 2);
            this.put(Cursor.DISAPPEAR, 20);
            this.put(Cursor.E_RESIZE, 12);
            this.put(Cursor.H_RESIZE, 9);
            this.put(Cursor.HAND, 21);
            this.put(Cursor.MOVE, 2);
            this.put(Cursor.N_RESIZE, 10);
            this.put(Cursor.NE_RESIZE, 14);
            this.put(Cursor.NONE, 20);
            this.put(Cursor.NW_RESIZE, 17);
            this.put(Cursor.OPEN_HAND, 21);
            this.put(Cursor.S_RESIZE, 11);
            this.put(Cursor.SE_RESIZE, 15);
            this.put(Cursor.SW_RESIZE, 16);
            this.put(Cursor.TEXT, 19);
            this.put(Cursor.V_RESIZE, 7);
            this.put(Cursor.W_RESIZE, 13);
            this.put(Cursor.WAIT, 1);
        }
    };
    private SwtToFXGestureConverter gestureConverter;
    private List<FocusListener> focusListeners;
    private ChangeListener<Cursor> cursorChangeListener = new ChangeListener<Cursor>(){

        public void changed(ObservableValue<? extends Cursor> observable, Cursor oldCursor, Cursor newCursor) {
            if (newCursor instanceof ImageCursor) {
                ImageData imageData = SWTFXUtils.fromFXImage((Image)((ImageCursor)newCursor).getImage(), null);
                double hotspotX = ((ImageCursor)newCursor).getHotspotX();
                double hotspotY = ((ImageCursor)newCursor).getHotspotY();
                org.eclipse.swt.graphics.Cursor swtCursor = new org.eclipse.swt.graphics.Cursor((Device)FXCanvasEx.this.getDisplay(), imageData, (int)hotspotX, (int)hotspotY);
                FXCanvasEx.this.getShell().setCursor(swtCursor);
            } else if (CURSOR_FROM_FX_TO_SWT.containsKey(newCursor)) {
                FXCanvasEx.this.getShell().setCursor(new org.eclipse.swt.graphics.Cursor((Device)FXCanvasEx.this.getDisplay(), ((Integer)CURSOR_FROM_FX_TO_SWT.get(newCursor)).intValue()));
            } else {
                FXCanvasEx.this.getShell().setCursor(null);
            }
        }
    };

    public FXCanvasEx(Composite parent, int style) {
        super(parent, style);
        this.gestureConverter = new SwtToFXGestureConverter(this);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                for (FocusListener l : FXCanvasEx.this.focusListeners) {
                    l.focusGained(e);
                }
            }

            public void focusLost(FocusEvent e) {
                for (FocusListener l : FXCanvasEx.this.focusListeners) {
                    l.focusLost(e);
                }
            }
        });
        this.focusListeners = new ArrayList<FocusListener>();
    }

    public void addFocusListener(FocusListener listener) {
        if (this.focusListeners == null) {
            super.addFocusListener(listener);
        } else {
            this.focusListeners.add(listener);
        }
    }

    public void dispose() {
        this.gestureConverter.dispose();
        this.focusListeners.clear();
        this.focusListeners = null;
        super.dispose();
    }

    public Window getStage() {
        return (Window)ReflectionUtils.getPrivateFieldValue((Object)((Object)this), (String)"stage");
    }

    public void removeFocusListener(FocusListener listener) {
        if (this.focusListeners == null) {
            super.removeFocusListener(listener);
        } else {
            this.focusListeners.remove(listener);
        }
    }

    public void setCursor(org.eclipse.swt.graphics.Cursor cursor) {
    }

    public void setScene(Scene newScene) {
        Scene oldScene = this.getScene();
        if (oldScene != null) {
            oldScene.cursorProperty().removeListener(this.cursorChangeListener);
        }
        super.setScene(newScene);
        if (newScene != null) {
            newScene.cursorProperty().addListener(this.cursorChangeListener);
        }
    }
}

