/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.adapt;

import com.google.common.reflect.TypeToken;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.gef4.common.activate.IActivatable;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.common.dispose.IDisposable;

public class AdaptableSupport<A extends IAdaptable>
implements IDisposable {
    private A source;
    private PropertyChangeSupport pcs;
    private Map<AdapterKey<?>, Object> adapters;

    public AdaptableSupport(A source, PropertyChangeSupport pcs) {
        if (source == null) {
            throw new IllegalArgumentException("source may not be null.");
        }
        if (pcs == null) {
            throw new IllegalArgumentException("pcs may not be null.");
        }
        this.source = source;
        this.pcs = pcs;
    }

    private void activateAdapters() {
        for (IActivatable adapter : this.getAdapters(IActivatable.class).values()) {
            adapter.activate();
        }
    }

    private void deactivateAdapters() {
        for (IActivatable adapter : this.getAdapters(IActivatable.class).values()) {
            adapter.deactivate();
        }
    }

    public <T> T getAdapter(AdapterKey<? super T> key) {
        if (this.adapters == null) {
            return null;
        }
        Map<AdapterKey<T>, T> adaptersForTypeKey = this.getAdapters(key.getKey(), key.getRole());
        int adapterCount = new HashSet<T>(adaptersForTypeKey.values()).size();
        if (adapterCount == 1) {
            return adaptersForTypeKey.values().iterator().next();
        }
        return null;
    }

    public <T> T getAdapter(Class<? super T> key) {
        return this.getAdapter(TypeToken.of(key));
    }

    public <T> T getAdapter(TypeToken<? super T> key) {
        Map<AdapterKey<T>, T> adaptersForTypeKey = this.getAdapters(key, null);
        int adapterCount = new HashSet<T>(adaptersForTypeKey.values()).size();
        if (adapterCount == 1) {
            return adaptersForTypeKey.values().iterator().next();
        }
        if (adapterCount > 1) {
            return this.getAdapter(AdapterKey.get(key, "default"));
        }
        return null;
    }

    public Map<AdapterKey<?>, Object> getAdapters() {
        if (this.adapters == null) {
            return Collections.emptyMap();
        }
        return new HashMap(this.adapters);
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(Class<? super T> key) {
        return this.getAdapters(TypeToken.of(key));
    }

    public <T> Map<AdapterKey<? extends T>, T> getAdapters(TypeToken<? super T> key) {
        if (this.adapters == null) {
            return Collections.emptyMap();
        }
        HashMap typeSafeAdapters = new HashMap();
        if (this.adapters != null) {
            for (AdapterKey<?> k : this.adapters.keySet()) {
                if (!key.isAssignableFrom(k.getKey())) continue;
                typeSafeAdapters.put(k, this.adapters.get(k));
            }
        }
        return typeSafeAdapters;
    }

    private <T> Map<AdapterKey<? extends T>, T> getAdapters(TypeToken<? super T> typeKey, String role) {
        if (this.adapters == null) {
            return Collections.emptyMap();
        }
        HashMap typeSafeAdapters = new HashMap();
        if (this.adapters != null) {
            for (AdapterKey<?> k : this.adapters.keySet()) {
                if (typeKey != null && !typeKey.isAssignableFrom(k.getKey()) || role != null && !k.getRole().equals(role)) continue;
                typeSafeAdapters.put(k, this.adapters.get(k));
            }
        }
        return typeSafeAdapters;
    }

    public <T> void setAdapter(Class<? super T> key, T adapter) {
        this.setAdapter(AdapterKey.get(TypeToken.of(key), "default"), adapter);
    }

    public <T> void setAdapter(TypeToken<? super T> key, T adapter) {
        this.setAdapter(AdapterKey.get(key, "default"), adapter);
    }

    public <T> void setAdapter(AdapterKey<? super T> key, T adapter) {
        if (this.adapters == null) {
            this.adapters = new HashMap();
        }
        if (this.source instanceof IActivatable && ((IActivatable)this.source).isActive()) {
            this.deactivateAdapters();
        }
        HashMap oldAdapters = new HashMap(this.adapters);
        this.adapters.put(key, adapter);
        if (adapter instanceof IAdaptable.Bound) {
            ((IAdaptable.Bound)adapter).setAdaptable(this.source);
        }
        if (this.source instanceof IActivatable && ((IActivatable)this.source).isActive()) {
            this.activateAdapters();
        }
        this.pcs.firePropertyChange("adapters", oldAdapters, new HashMap(this.adapters));
    }

    public void setAdapters(Map<AdapterKey<?>, Object> adaptersWithKeys, boolean overwrite) {
        for (AdapterKey<?> key : adaptersWithKeys.keySet()) {
            if (!key.getKey().isAssignableFrom(adaptersWithKeys.get(key).getClass())) {
                throw new IllegalArgumentException(key + " is not a valid key for " + adaptersWithKeys.get(key) + ", as its neither a super interface nor a super class of its type.");
            }
            if (!overwrite && this.getAdapters().containsKey(key)) continue;
            this.setAdapter(key, adaptersWithKeys.get(key));
        }
    }

    public <T> T unsetAdapter(AdapterKey<? super T> key) {
        if (this.adapters == null || !this.adapters.containsKey(key)) {
            throw new IllegalArgumentException("Given key is not registered.");
        }
        if (this.source instanceof IActivatable && ((IActivatable)this.source).isActive()) {
            this.deactivateAdapters();
        }
        HashMap oldAdapters = new HashMap(this.adapters);
        Object adapter = this.adapters.remove(key);
        if (adapter != null && adapter instanceof IAdaptable.Bound) {
            ((IAdaptable.Bound)adapter).setAdaptable(null);
        }
        if (this.source instanceof IActivatable && ((IActivatable)this.source).isActive()) {
            this.activateAdapters();
        }
        this.pcs.firePropertyChange("adapters", oldAdapters, new HashMap(this.adapters));
        if (this.adapters.size() == 0) {
            this.adapters = null;
        }
        return (T)adapter;
    }

    @Override
    public void dispose() {
        if (this.source instanceof IActivatable && ((IActivatable)this.source).isActive()) {
            throw new IllegalStateException("source needs to be deactivated before disposing this AdaptableSupport.");
        }
        HashMap oldAdapters = new HashMap(this.adapters);
        for (AdapterKey key : oldAdapters.keySet()) {
            Object adapter = this.adapters.remove(key);
            if (adapter != null && adapter instanceof IAdaptable.Bound) {
                ((IAdaptable.Bound)adapter).setAdaptable(null);
            }
            if (!(adapter instanceof IDisposable)) continue;
            ((IDisposable)adapter).dispose();
        }
        this.adapters.clear();
        this.adapters = null;
    }
}

