/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.text.AppendableCommand;
import org.eclipse.gef.examples.text.GraphicalTextViewer;
import org.eclipse.gef.examples.text.SelectionRange;
import org.eclipse.gef.examples.text.TextCommand;

public class CompoundTextCommand
extends Command
implements TextCommand,
AppendableCommand {
    private final List<Command> pending = new ArrayList<Command>();
    private final List<Command> applied = new ArrayList<Command>();

    public CompoundTextCommand() {
    }

    public CompoundTextCommand(String label) {
        super(label);
    }

    public void add(TextCommand command) {
        if (command instanceof Command) {
            Command cmd = (Command)command;
            this.pending.add(cmd);
        }
    }

    public boolean canExecute() {
        return this.canExecutePending();
    }

    @Override
    public boolean canExecutePending() {
        if (this.pending.isEmpty()) {
            return false;
        }
        for (Command cmd : this.pending) {
            if (cmd == null) {
                return false;
            }
            if (cmd.canExecute()) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        for (Command element : this.applied) {
            element.dispose();
        }
        this.flushPending();
    }

    public void execute() {
        this.executePending();
    }

    @Override
    public void executePending() {
        for (Command cmd : this.pending) {
            cmd.execute();
            this.applied.add(cmd);
        }
        this.flushPending();
    }

    @Override
    public void flushPending() {
        this.pending.clear();
    }

    @Override
    public SelectionRange getExecuteSelectionRange(GraphicalTextViewer viewer) {
        if (this.applied.isEmpty()) {
            return null;
        }
        return this.getAppliedTextCommand(this.applied.size() - 1).getExecuteSelectionRange(viewer);
    }

    private TextCommand getAppliedTextCommand(int i) {
        return (TextCommand)this.applied.get(i);
    }

    @Override
    public SelectionRange getRedoSelectionRange(GraphicalTextViewer viewer) {
        if (this.applied.isEmpty()) {
            return null;
        }
        return this.getAppliedTextCommand(this.applied.size() - 1).getExecuteSelectionRange(viewer);
    }

    @Override
    public SelectionRange getUndoSelectionRange(GraphicalTextViewer viewer) {
        if (this.applied.isEmpty()) {
            return null;
        }
        return this.getAppliedTextCommand(0).getUndoSelectionRange(viewer);
    }

    public void redo() {
        for (Command element : this.applied) {
            element.redo();
        }
    }

    public void undo() {
        int i = this.applied.size() - 1;
        while (i >= 0) {
            this.applied.get(i).undo();
            --i;
        }
    }
}

