/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.SWTEventDispatcher;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.internal.FileImageDataProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.zest.core.viewers.internal.ZoomManager;
import org.eclipse.zest.core.widgets.ConstraintAdapter;
import org.eclipse.zest.core.widgets.FisheyeListener;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphContainer;
import org.eclipse.zest.core.widgets.GraphDragSupport;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.HideNodeHelper;
import org.eclipse.zest.core.widgets.IContainer;
import org.eclipse.zest.core.widgets.IContainer2;
import org.eclipse.zest.core.widgets.InternalLayoutContext;
import org.eclipse.zest.core.widgets.LayoutFilter;
import org.eclipse.zest.core.widgets.SubgraphFactory;
import org.eclipse.zest.core.widgets.ZestStyles;
import org.eclipse.zest.core.widgets.gestures.RotateGestureListener;
import org.eclipse.zest.core.widgets.gestures.ZoomGestureListener;
import org.eclipse.zest.core.widgets.internal.ContainerFigure;
import org.eclipse.zest.core.widgets.internal.ZestRootLayer;
import org.eclipse.zest.layouts.InvalidLayoutConfiguration;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.constraints.LayoutConstraint;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.zest.layouts.interfaces.ExpandCollapseManager;
import org.eclipse.zest.layouts.interfaces.LayoutContext;

public class Graph
extends FigureCanvas
implements IContainer2 {
    public static final int ANIMATION_TIME = 500;
    public static final int FISHEYE_ANIMATION_TIME = 100;
    private static final Image BACK_ARROW = FileImageDataProvider.createImage(Graph.class, (String)"/icons/back_arrow.png");
    public Color LIGHT_BLUE = null;
    public Color LIGHT_BLUE_CYAN = null;
    public Color GREY_BLUE = null;
    public Color DARK_BLUE = null;
    public Color LIGHT_YELLOW = null;
    public Color HIGHLIGHT_COLOR = ColorConstants.yellow;
    public Color HIGHLIGHT_ADJACENT_COLOR = ColorConstants.orange;
    public Color DEFAULT_NODE_COLOR = this.LIGHT_BLUE;
    private final List<GraphNode> nodes;
    protected List<GraphConnection> connections;
    private List<GraphItem> selectedItems = null;
    Set<IFigure> subgraphFigures;
    private HideNodeHelper hoverNode = null;
    IFigure fisheyedFigure = null;
    private final List<FisheyeListener> fisheyeListeners = new ArrayList<FisheyeListener>();
    private List<SelectionListener> selectionListeners = null;
    private HashMap<IFigure, GraphItem> figure2ItemMap = null;
    private int connectionStyle;
    private int nodeStyle;
    private List<ConstraintAdapter> constraintAdapters;
    private ScalableFreeformLayeredPane fishEyeLayer = null;
    private InternalLayoutContext layoutContext = null;
    private volatile boolean shouldSheduleLayout;
    private volatile Runnable scheduledLayoutRunnable = null;
    private volatile boolean scheduledLayoutClean = false;
    private Dimension preferredSize = null;
    int style = 0;
    private ScalableFreeformLayeredPane rootlayer;
    private ZestRootLayer zestRootLayer;
    private boolean enableHideNodes;
    private ConnectionRouter defaultConnectionRouter;
    private ZoomManager zoomManager = null;

    public Graph(Composite parent, int style) {
        this(parent, style, false);
    }

    public Graph(Composite parent, int style, boolean enableHideNodes) {
        super(parent, style | 0x20000000);
        this.style = style;
        this.setBackground(ColorConstants.white);
        this.LIGHT_BLUE = new Color((Device)Display.getDefault(), 216, 228, 248);
        this.LIGHT_BLUE_CYAN = new Color((Device)Display.getDefault(), 213, 243, 255);
        this.GREY_BLUE = new Color((Device)Display.getDefault(), 139, 150, 171);
        this.DARK_BLUE = new Color((Device)Display.getDefault(), 1, 70, 122);
        this.LIGHT_YELLOW = new Color((Device)Display.getDefault(), 255, 255, 206);
        this.setViewport((Viewport)new FreeformViewport());
        this.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Graph.this.redraw();
            }
        });
        this.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Graph.this.redraw();
            }
        });
        this.getLightweightSystem().setEventDispatcher((EventDispatcher)new SWTEventDispatcher(){

            public void dispatchMouseMoved(org.eclipse.swt.events.MouseEvent me) {
                super.dispatchMouseMoved(me);
                if (this.getCurrentEvent() == null) {
                    return;
                }
                if (this.getMouseTarget() == null) {
                    this.setMouseTarget(this.getRoot());
                }
                if ((me.stateMask & SWT.BUTTON_MASK) != 0) {
                    this.getMouseTarget().handleMouseDragged(this.getCurrentEvent());
                } else {
                    this.getMouseTarget().handleMouseMoved(this.getCurrentEvent());
                }
            }
        });
        this.setContents(this.createLayers());
        GraphDragSupport dragSupport = this.createGraphDragSupport();
        this.getLightweightSystem().getRootFigure().addMouseListener((MouseListener)dragSupport);
        this.getLightweightSystem().getRootFigure().addMouseMotionListener((MouseMotionListener)dragSupport);
        this.nodes = new ArrayList<GraphNode>();
        this.preferredSize = new Dimension(-1, -1);
        this.connectionStyle = 0;
        this.nodeStyle = 0;
        this.connections = new ArrayList<GraphConnection>();
        this.constraintAdapters = new ArrayList<ConstraintAdapter>();
        this.selectedItems = new ArrayList<GraphItem>();
        this.selectionListeners = new ArrayList<SelectionListener>();
        this.figure2ItemMap = new HashMap();
        this.enableHideNodes = enableHideNodes;
        this.subgraphFigures = new HashSet<IFigure>();
        this.addPaintListener(event -> {
            if (this.shouldSheduleLayout) {
                this.applyLayoutInternal(true);
                this.shouldSheduleLayout = false;
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (Graph.this.preferredSize.width == -1 || Graph.this.preferredSize.height == -1) {
                    Graph.this.internalGetLayoutContext().fireBoundsChangedEvent();
                }
            }
        });
        if ((style & 0x40) == 0) {
            this.addGestureListener(new ZoomGestureListener());
            this.addGestureListener(new RotateGestureListener());
        }
        this.addDisposeListener(event -> this.release());
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (!this.selectionListeners.contains(selectionListener)) {
            this.selectionListeners.add(selectionListener);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        if (this.selectionListeners.contains(selectionListener)) {
            this.selectionListeners.remove(selectionListener);
        }
    }

    @Override
    public List<? extends GraphNode> getNodes() {
        return this.nodes;
    }

    @Deprecated(since="2.0", forRemoval=true)
    public void addConstraintAdapter(ConstraintAdapter constraintAdapter) {
        this.constraintAdapters.add(constraintAdapter);
    }

    @Deprecated(since="2.0", forRemoval=true)
    public void setConstraintAdapters(List<ConstraintAdapter> constraintAdapters) {
        this.constraintAdapters = constraintAdapters;
    }

    public ScalableFigure getRootLayer() {
        return this.rootlayer;
    }

    public void setConnectionStyle(int connectionStyle) {
        this.connectionStyle = connectionStyle;
    }

    public int getConnectionStyle() {
        return this.connectionStyle;
    }

    public void setNodeStyle(int nodeStyle) {
        this.nodeStyle = nodeStyle;
    }

    public int getNodeStyle() {
        return this.nodeStyle;
    }

    @Override
    public List<? extends GraphConnection> getConnections() {
        return this.connections;
    }

    public void setSelection(GraphItem[] items) {
        this.clearSelection();
        if (items != null) {
            GraphItem[] graphItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                GraphItem item = graphItemArray[n2];
                if (item != null) {
                    this.select(item);
                }
                ++n2;
            }
        }
    }

    public void selectAll() {
        this.setSelection(this.nodes.toArray(new GraphItem[0]));
    }

    public List<? extends GraphItem> getSelection() {
        return this.selectedItems;
    }

    public String toString() {
        return "GraphModel {%d nodes, %d connections}".formatted(this.nodes.size(), this.connections.size());
    }

    @Deprecated(since="1.12", forRemoval=true)
    public Graph getGraphModel() {
        return this;
    }

    public void dispose() {
        this.release();
        super.dispose();
    }

    @Override
    public void applyLayout() {
        this.scheduleLayoutOnReveal(true);
    }

    public void applyLayoutNow() {
        if (this.getLayoutAlgorithm() instanceof LayoutAlgorithm.Zest1) {
            this.applyLayoutInternal(true);
        } else {
            this.internalGetLayoutContext().applyLayout(true);
            this.layoutContext.flushChanges(false);
        }
    }

    public void setDynamicLayout(boolean enabled) {
        if (this.getLayoutContext().isBackgroundLayoutEnabled() != enabled) {
            this.layoutContext.setBackgroundLayoutEnabled(enabled);
            if (enabled) {
                this.scheduleLayoutOnReveal(false);
            }
        }
    }

    public boolean isDynamicLayoutEnabled() {
        return this.getLayoutContext().isBackgroundLayoutEnabled();
    }

    public void setPreferredSize(int width, int height) {
        this.preferredSize = new Dimension(width, height);
        this.internalGetLayoutContext().fireBoundsChangedEvent();
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize.width < 0 || this.preferredSize.height < 0) {
            org.eclipse.swt.graphics.Point size = this.getSize();
            double scale = this.getZoomManager().getZoom();
            return new Dimension((int)((double)size.x / scale + 0.5), (int)((double)size.y / scale + 0.5));
        }
        return this.preferredSize;
    }

    @Override
    public final LayoutContext getLayoutContext() {
        if (this.layoutContext == null) {
            this.layoutContext = new InternalLayoutContext(this);
        }
        return this.layoutContext;
    }

    InternalLayoutContext internalGetLayoutContext() {
        return (InternalLayoutContext)this.getLayoutContext();
    }

    @Override
    public void setLayoutAlgorithm(LayoutAlgorithm algorithm, boolean applyLayout) {
        this.internalGetLayoutContext().setLayoutAlgorithm(algorithm);
        if (applyLayout) {
            this.applyLayout();
        }
    }

    public void setSubgraphFactory(SubgraphFactory factory) {
        this.internalGetLayoutContext().setSubgraphFactory(factory);
    }

    public SubgraphFactory getSubgraphFactory() {
        return this.internalGetLayoutContext().getSubgraphFactory();
    }

    public void setExpandCollapseManager(ExpandCollapseManager expandCollapseManager) {
        this.getLayoutContext().setExpandCollapseManager(expandCollapseManager);
    }

    public ExpandCollapseManager getExpandCollapseManager() {
        return this.getLayoutContext().getExpandCollapseManager();
    }

    public void addLayoutFilter(LayoutFilter filter) {
        this.internalGetLayoutContext().addFilter(filter);
    }

    public LayoutAlgorithm getLayoutAlgorithm() {
        return this.internalGetLayoutContext().getLayoutAlgorithm();
    }

    public void removeLayoutFilter(LayoutFilter filter) {
        this.internalGetLayoutContext().removeFilter(filter);
    }

    public IFigure getFigureAt(int x, int y) {
        return this.getContents().findFigureAt(x, y, new TreeSearch(){

            public boolean accept(IFigure figure) {
                return true;
            }

            public boolean prune(IFigure figure) {
                IFigure parent = figure.getParent();
                if (parent == Graph.this.fishEyeLayer) {
                    return true;
                }
                if (parent instanceof ContainerFigure && figure instanceof PolylineConnection) {
                    return false;
                }
                if (parent == Graph.this.zestRootLayer || parent == Graph.this.zestRootLayer.getParent() || parent == Graph.this.zestRootLayer.getParent().getParent()) {
                    return false;
                }
                GraphItem item = Graph.this.figure2ItemMap.get(figure);
                return (item == null || item.getItemType() != 3) && !(figure instanceof FreeformLayer) && !(parent instanceof FreeformLayer) && !(figure instanceof ScrollPane) && !(parent instanceof ScrollPane) && !(parent instanceof ScalableFreeformLayeredPane) && !(figure instanceof ScalableFreeformLayeredPane) && !(figure instanceof FreeformViewport) && !(parent instanceof FreeformViewport);
            }
        });
    }

    public boolean getHideNodesEnabled() {
        return this.enableHideNodes;
    }

    protected GraphDragSupport createGraphDragSupport() {
        return new DragSupport();
    }

    public void notifyListeners(int eventType, Event event) {
        super.notifyListeners(eventType, event);
        if (eventType == 13 && event != null) {
            this.notifySelectionListeners(new SelectionEvent(event));
        }
    }

    private void release() {
        while (!this.nodes.isEmpty()) {
            GraphNode node = this.nodes.get(0);
            if (node == null) continue;
            node.dispose();
        }
        while (!this.connections.isEmpty()) {
            GraphConnection connection = this.connections.get(0);
            if (connection == null) continue;
            connection.dispose();
        }
        if (this.LIGHT_BLUE != null) {
            this.LIGHT_BLUE.dispose();
        }
        if (this.LIGHT_BLUE_CYAN != null) {
            this.LIGHT_BLUE_CYAN.dispose();
        }
        if (this.GREY_BLUE != null) {
            this.GREY_BLUE.dispose();
        }
        if (this.DARK_BLUE != null) {
            this.DARK_BLUE.dispose();
        }
        if (this.LIGHT_YELLOW != null) {
            this.LIGHT_YELLOW.dispose();
        }
    }

    private void clearSelection() {
        for (GraphItem item : new ArrayList<GraphItem>(this.selectedItems)) {
            this.deselect(item);
        }
    }

    private void fireWidgetSelectedEvent(Item item) {
        Event swtEvent = new Event();
        swtEvent.item = item;
        swtEvent.widget = this;
        this.notifySelectionListeners(new SelectionEvent(swtEvent));
    }

    private void notifySelectionListeners(SelectionEvent event) {
        for (SelectionListener listener : this.selectionListeners) {
            listener.widgetSelected(event);
        }
    }

    private void deselect(GraphItem item) {
        this.selectedItems.remove((Object)item);
        item.unhighlight();
        Graph.setNodeSelected(item, false);
    }

    private void select(GraphItem item) {
        this.selectedItems.add(item);
        item.highlight();
        Graph.setNodeSelected(item, true);
    }

    private static void setNodeSelected(GraphItem item, boolean selected) {
        if (item instanceof GraphNode) {
            GraphNode node = (GraphNode)item;
            node.setSelected(selected);
        }
    }

    GraphConnection[] getConnectionsArray() {
        GraphConnection[] connsArray = new GraphConnection[this.connections.size()];
        return this.connections.toArray(connsArray);
    }

    @Deprecated(since="1.12", forRemoval=true)
    LayoutRelationship[] getConnectionsToLayout(List<GraphNode> nodesToLayout) {
        LayoutRelationship[] entities;
        if (ZestStyles.checkStyle(this.style, 2)) {
            LinkedList<LayoutRelationship> connectionList = new LinkedList<LayoutRelationship>();
            for (GraphConnection graphConnection : this.getConnections()) {
                if (!graphConnection.isVisible() || !nodesToLayout.contains((Object)graphConnection.getSource()) || !nodesToLayout.contains((Object)graphConnection.getDestination())) continue;
                connectionList.add(graphConnection.getLayoutRelationship());
            }
            entities = connectionList.toArray(new LayoutRelationship[0]);
        } else {
            LinkedList<LayoutRelationship> nodeList = new LinkedList<LayoutRelationship>();
            for (GraphConnection graphConnection : this.getConnections()) {
                if (!nodesToLayout.contains((Object)graphConnection.getSource()) || !nodesToLayout.contains((Object)graphConnection.getDestination())) continue;
                nodeList.add(graphConnection.getLayoutRelationship());
            }
            entities = nodeList.toArray(new LayoutRelationship[0]);
        }
        return entities;
    }

    @Deprecated(since="1.12", forRemoval=true)
    LayoutEntity[] getNodesToLayout(List<? extends GraphNode> nodes) {
        LayoutEntity[] entities;
        if (ZestStyles.checkStyle(this.style, 2)) {
            LinkedList<LayoutEntity> nodeList = new LinkedList<LayoutEntity>();
            for (GraphNode graphNode : nodes) {
                if (!graphNode.isVisible()) continue;
                nodeList.add(graphNode.getLayoutEntity());
            }
            entities = nodeList.toArray(new LayoutEntity[0]);
        } else {
            LinkedList<LayoutEntity> nodeList = new LinkedList<LayoutEntity>();
            for (GraphNode graphNode : nodes) {
                nodeList.add(graphNode.getLayoutEntity());
            }
            entities = nodeList.toArray(new LayoutEntity[0]);
        }
        return entities;
    }

    public void clear() {
        for (GraphConnection graphConnection : new ArrayList<GraphConnection>(this.connections)) {
            this.removeConnection(graphConnection);
        }
        for (IFigure iFigure : new HashSet<IFigure>(this.subgraphFigures)) {
            this.removeSubgraphFigure(iFigure);
        }
        for (GraphNode graphNode : new ArrayList<GraphNode>(this.nodes)) {
            this.removeNode(graphNode);
        }
    }

    void removeConnection(GraphConnection connection) {
        Connection figure = connection.getConnectionFigure();
        PolylineConnection sourceContainerConnectionFigure = connection.getSourceContainerConnectionFigure();
        PolylineConnection targetContainerConnectionFigure = connection.getTargetContainerConnectionFigure();
        connection.removeFigure();
        this.getConnections().remove((Object)connection);
        this.selectedItems.remove((Object)connection);
        this.figure2ItemMap.remove(figure);
        if (sourceContainerConnectionFigure != null) {
            this.figure2ItemMap.remove(sourceContainerConnectionFigure);
        }
        if (targetContainerConnectionFigure != null) {
            this.figure2ItemMap.remove(targetContainerConnectionFigure);
        }
        this.internalGetLayoutContext().fireConnectionRemovedEvent(connection.getLayout());
    }

    void removeNode(GraphNode node) {
        IFigure figure = node.getNodeFigure();
        if (figure.getParent() != null) {
            figure.getParent().remove(figure);
        }
        this.getNodes().remove((Object)node);
        if (this.getSelection() != null) {
            this.getSelection().remove((Object)node);
        }
        this.figure2ItemMap.remove(figure);
        node.getLayout().dispose();
    }

    void addConnection(GraphConnection connection, boolean addToEdgeLayer) {
        this.connections.add(connection);
        if (addToEdgeLayer) {
            this.zestRootLayer.addConnection(connection.getFigure());
        }
        this.internalGetLayoutContext().fireConnectionAddedEvent(connection.getLayout());
    }

    @Override
    public void addNode(GraphNode node) {
        this.nodes.add(node);
        this.zestRootLayer.addNode(node.getNodeFigure());
        this.internalGetLayoutContext().fireNodeAddedEvent(node.getLayout());
    }

    @Override
    public void addSubgraphFigure(IFigure figure) {
        this.zestRootLayer.addSubgraph(figure);
        this.subgraphFigures.add(figure);
    }

    void removeSubgraphFigure(IFigure figure) {
        this.subgraphFigures.remove(figure);
        figure.getParent().remove(figure);
    }

    void registerItem(GraphItem item) {
        if (item.getItemType() == 1) {
            IFigure figure = ((GraphNode)item).getNodeFigure();
            this.figure2ItemMap.put(figure, item);
        } else if (item.getItemType() == 2) {
            IFigure figure = item.getFigure();
            this.figure2ItemMap.put(figure, item);
            if (((GraphConnection)item).getSourceContainerConnectionFigure() != null) {
                this.figure2ItemMap.put((IFigure)((GraphConnection)item).getSourceContainerConnectionFigure(), item);
            }
            if (((GraphConnection)item).getTargetContainerConnectionFigure() != null) {
                this.figure2ItemMap.put((IFigure)((GraphConnection)item).getTargetContainerConnectionFigure(), item);
            }
        } else if (item.getItemType() == 3) {
            IFigure figure = ((GraphNode)item).getNodeFigure();
            this.figure2ItemMap.put(figure, item);
            figure = ((GraphNode)item).getModelFigure();
            this.figure2ItemMap.put(figure, item);
        } else {
            throw new RuntimeException("Unknown item type: " + item.getItemType());
        }
    }

    private void registerChildrenOfContainer(GraphContainer container, boolean addToMap) {
        for (GraphNode node : container.getNodes()) {
            if (node instanceof GraphContainer) {
                GraphContainer childContainer = (GraphContainer)node;
                this.registerChildrenOfContainer(childContainer, addToMap);
                continue;
            }
            node.graph = this;
            node.unhighlight();
            if (!addToMap) continue;
            IFigure figure = node.getFigure();
            this.figure2ItemMap.put(figure, node);
        }
    }

    void changeNodeFigure(IFigure oldValue, IFigure newFigure, GraphNode graphItem) {
        if (this.zestRootLayer.getChildren().contains(oldValue)) {
            this.zestRootLayer.remove(oldValue);
            this.figure2ItemMap.remove(oldValue);
        }
        this.figure2ItemMap.put(newFigure, graphItem);
        this.zestRootLayer.add(newFigure);
    }

    @Deprecated(since="2.0", forRemoval=true)
    void invokeConstraintAdapters(Object object, LayoutConstraint constraint) {
        if (this.constraintAdapters == null) {
            return;
        }
        for (ConstraintAdapter constraintAdapter : this.constraintAdapters) {
            constraintAdapter.populateConstraint(object, constraint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyLayoutInternal(boolean clean) {
        if (this.internalGetLayoutContext().getLayoutAlgorithm() == null) {
            return;
        }
        if (this.getNodes().isEmpty()) {
            return;
        }
        this.scheduledLayoutClean = this.scheduledLayoutClean || clean;
        Graph graph = this;
        synchronized (graph) {
            if (this.scheduledLayoutRunnable == null) {
                this.scheduledLayoutRunnable = () -> {
                    LayoutAlgorithm layoutAlgorithm;
                    if (this.isDisposed()) {
                        return;
                    }
                    int layoutStyle = 0;
                    if ((this.nodeStyle & 0x10) > 0) {
                        layoutStyle = 1;
                    }
                    if ((this.nodeStyle & 0x100) == 0) {
                        Animation.markBegin();
                    }
                    if ((layoutAlgorithm = this.getLayoutAlgorithm()) instanceof LayoutAlgorithm.Zest1) {
                        LayoutAlgorithm.Zest1 zest1 = (LayoutAlgorithm.Zest1)layoutAlgorithm;
                        try {
                            zest1.setStyle(zest1.getStyle() | layoutStyle);
                            Dimension d = this.getViewport().getSize();
                            d.width -= 10;
                            d.height -= 10;
                            if (this.preferredSize.width >= 0) {
                                d.width = this.preferredSize.width;
                            }
                            if (this.preferredSize.height >= 0) {
                                d.height = this.preferredSize.height;
                            }
                            if (d.isEmpty()) {
                                return;
                            }
                            LayoutRelationship[] connectionsToLayout = this.getConnectionsToLayout(this.nodes);
                            LayoutEntity[] nodesToLayout = this.getNodesToLayout(this.getNodes());
                            zest1.applyLayout(nodesToLayout, connectionsToLayout, 0.0, 0.0, (double)d.width, (double)d.height, false, false);
                        }
                        catch (InvalidLayoutConfiguration e) {
                            e.printStackTrace();
                        }
                    } else {
                        this.internalGetLayoutContext().applyLayout(this.scheduledLayoutClean);
                        this.layoutContext.flushChanges(false);
                    }
                    Animation.run((int)500);
                    this.getLightweightSystem().getUpdateManager().performUpdate();
                    Graph graph = this;
                    synchronized (graph) {
                        this.scheduledLayoutRunnable = null;
                        this.scheduledLayoutClean = false;
                    }
                };
                Display.getDefault().asyncExec(this.scheduledLayoutRunnable);
            }
        }
    }

    private void scheduleLayoutOnReveal(boolean clean) {
        boolean[] isVisibleSync = new boolean[1];
        Display.getDefault().syncExec(() -> {
            boolean bl = this.isVisible();
        });
        if (isVisibleSync[0]) {
            this.applyLayoutInternal(clean);
        } else {
            this.shouldSheduleLayout = true;
        }
    }

    protected IFigure createLayers() {
        this.rootlayer = new ScalableFreeformLayeredPane();
        this.rootlayer.setLayoutManager((LayoutManager)new FreeformLayout());
        this.zestRootLayer = this.createZestRootLayer();
        this.zestRootLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        this.fishEyeLayer = new ScalableFreeformLayeredPane();
        this.fishEyeLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        this.rootlayer.add((IFigure)this.zestRootLayer);
        this.rootlayer.add((IFigure)this.fishEyeLayer);
        this.zestRootLayer.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        this.fishEyeLayer.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        this.rootlayer.addCoordinateListener(source -> {
            if (this.preferredSize.width == -1 && this.preferredSize.height == -1) {
                this.internalGetLayoutContext().fireBoundsChangedEvent();
            }
        });
        return this.rootlayer;
    }

    protected ZestRootLayer createZestRootLayer() {
        return new ZestRootLayer();
    }

    void removeFishEye(IFigure fishEyeFigure, IFigure regularFigure, boolean animate) {
        if (!this.fishEyeLayer.getChildren().contains(fishEyeFigure)) {
            return;
        }
        if (animate) {
            Animation.markBegin();
        }
        Rectangle bounds = regularFigure.getBounds().getCopy();
        regularFigure.translateToAbsolute((Translatable)bounds);
        double scale = this.rootlayer.getScale();
        this.fishEyeLayer.setScale(1.0 / scale);
        this.fishEyeLayer.translateToRelative((Translatable)bounds);
        this.fishEyeLayer.translateFromParent((Translatable)bounds);
        this.fishEyeLayer.setConstraint(fishEyeFigure, (Object)bounds);
        for (FisheyeListener listener : this.fisheyeListeners) {
            listener.fisheyeRemoved(this, regularFigure, fishEyeFigure);
        }
        if (animate) {
            Animation.run((int)200);
        }
        this.getRootLayer().getUpdateManager().performUpdate();
        this.fishEyeLayer.removeAll();
        this.fisheyedFigure = null;
    }

    boolean replaceFishFigure(IFigure oldFigure, IFigure newFigure) {
        if (this.fishEyeLayer.getChildren().contains(oldFigure)) {
            Rectangle bounds = oldFigure.getBounds();
            newFigure.setBounds(bounds);
            this.fishEyeLayer.remove(oldFigure);
            this.fishEyeLayer.add(newFigure);
            for (FisheyeListener listener : this.fisheyeListeners) {
                listener.fisheyeReplaced(this, oldFigure, newFigure);
            }
            this.fisheyedFigure = newFigure;
            return true;
        }
        return false;
    }

    void fishEye(IFigure startFigure, IFigure endFigure, Rectangle newBounds, boolean animate) {
        this.fishEyeLayer.removeAll();
        this.fisheyedFigure = null;
        if (animate) {
            Animation.markBegin();
        }
        double scale = this.rootlayer.getScale();
        this.fishEyeLayer.setScale(1.0 / scale);
        this.fishEyeLayer.translateToRelative((Translatable)newBounds);
        this.fishEyeLayer.translateFromParent((Translatable)newBounds);
        Rectangle bounds = startFigure.getBounds().getCopy();
        startFigure.translateToAbsolute((Translatable)bounds);
        this.fishEyeLayer.translateToRelative((Translatable)bounds);
        this.fishEyeLayer.translateFromParent((Translatable)bounds);
        endFigure.setLocation(bounds.getLocation());
        endFigure.setSize(bounds.getSize());
        this.fishEyeLayer.add(endFigure);
        this.fishEyeLayer.setConstraint(endFigure, (Object)newBounds);
        for (FisheyeListener listener : this.fisheyeListeners) {
            listener.fisheyeAdded(this, startFigure, endFigure);
        }
        if (animate) {
            Animation.run((int)100);
        }
        this.getRootLayer().getUpdateManager().performUpdate();
    }

    @Override
    public Graph getGraph() {
        return this.getGraphModel();
    }

    public void addFisheyeListener(FisheyeListener listener) {
        this.fisheyeListeners.add(listener);
    }

    public void removeFisheyeListener(FisheyeListener listener) {
        this.fisheyeListeners.remove(listener);
    }

    @Override
    public int getItemType() {
        return 0;
    }

    protected GraphItem getGraphItem(IFigure figure) {
        return this.figure2ItemMap.get(figure);
    }

    public void setExpanded(GraphNode node, boolean expanded) {
        this.layoutContext.setExpanded(node.getLayout(), expanded);
        this.rootlayer.invalidate();
    }

    public boolean canExpand(GraphNode node) {
        return this.layoutContext.canExpand(node.getLayout());
    }

    public boolean canCollapse(GraphNode node) {
        return this.layoutContext.canCollapse(node.getLayout());
    }

    @Override
    public Widget getItem() {
        return this;
    }

    @Override
    public DisplayIndependentRectangle getLayoutBounds() {
        Dimension preferredSize = this.getPreferredSize();
        return new DisplayIndependentRectangle(0.0, 0.0, (double)preferredSize.width, (double)preferredSize.height);
    }

    void setDefaultConnectionRouter(ConnectionRouter defaultConnectionRouter) {
        this.defaultConnectionRouter = defaultConnectionRouter;
    }

    ConnectionRouter getDefaultConnectionRouter() {
        return this.defaultConnectionRouter;
    }

    void applyConnectionRouter() {
        for (GraphConnection graphConnection : this.getConnections()) {
            graphConnection.getConnectionFigure().setConnectionRouter(this.defaultConnectionRouter);
        }
        this.getRootLayer().getUpdateManager().performUpdate();
    }

    public void setRouter(ConnectionRouter connectionRouter) {
        this.setDefaultConnectionRouter(connectionRouter);
        this.applyConnectionRouter();
    }

    public ZoomManager getZoomManager() {
        if (this.zoomManager == null) {
            this.zoomManager = new ZoomManager(this.getRootLayer(), this.getViewport());
        }
        return this.zoomManager;
    }

    private class DragSupport
    implements GraphDragSupport {
        Point lastLocation = null;
        IFigure draggedSubgraphFigure = null;
        List<Point> relativeLocations = new ArrayList<Point>();
        GraphItem fisheyedItem = null;
        boolean isDragging = false;

        private DragSupport() {
        }

        public void mouseDragged(MouseEvent me) {
            IFigure figureUnderMouse;
            if (!this.isDragging) {
                return;
            }
            if (Graph.this.selectedItems.isEmpty() && Graph.this.subgraphFigures.contains(figureUnderMouse = Graph.this.getFigureAt(this.lastLocation.x, this.lastLocation.y))) {
                this.draggedSubgraphFigure = figureUnderMouse;
            }
            Point mousePoint = new Point(me.x, me.y);
            if (!Graph.this.selectedItems.isEmpty() || this.draggedSubgraphFigure != null) {
                if (this.relativeLocations.isEmpty()) {
                    for (GraphItem item : Graph.this.selectedItems) {
                        if (item.getItemType() != 1 && item.getItemType() != 3) continue;
                        this.relativeLocations.add(this.getRelativeLocation(item.getFigure()));
                    }
                    if (this.draggedSubgraphFigure != null) {
                        this.relativeLocations.add(this.getRelativeLocation(this.draggedSubgraphFigure));
                    }
                }
                Iterator<Point> locationsIterator = this.relativeLocations.iterator();
                for (GraphItem item : Graph.this.selectedItems) {
                    if (item.getItemType() != 1 && item.getItemType() != 3) continue;
                    Point pointCopy = mousePoint.getCopy();
                    Point relativeLocation = locationsIterator.next();
                    item.getFigure().getParent().translateToRelative((Translatable)pointCopy);
                    item.getFigure().getParent().translateFromParent((Translatable)pointCopy);
                    ((GraphNode)item).setLocation(relativeLocation.x + pointCopy.x, relativeLocation.y + pointCopy.y);
                }
                if (this.draggedSubgraphFigure != null) {
                    Point pointCopy = mousePoint.getCopy();
                    this.draggedSubgraphFigure.getParent().translateToRelative((Translatable)pointCopy);
                    this.draggedSubgraphFigure.getParent().translateFromParent((Translatable)pointCopy);
                    Point relativeLocation = locationsIterator.next();
                    pointCopy.x += relativeLocation.x;
                    pointCopy.y += relativeLocation.y;
                    this.draggedSubgraphFigure.setLocation(pointCopy);
                }
            }
        }

        private Point getRelativeLocation(IFigure figure) {
            Point location = figure.getBounds().getTopLeft();
            Point mousePointCopy = this.lastLocation.getCopy();
            figure.getParent().translateToRelative((Translatable)mousePointCopy);
            figure.getParent().translateFromParent((Translatable)mousePointCopy);
            location.x -= mousePointCopy.x;
            location.y -= mousePointCopy.y;
            return location;
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
        }

        public void mouseHover(MouseEvent me) {
        }

        public void mouseMoved(MouseEvent me) {
            Point mousePoint = new Point(me.x, me.y);
            Graph.this.getRootLayer().translateToRelative((Translatable)mousePoint);
            IFigure figureUnderMouse = Graph.this.getFigureAt(mousePoint.x, mousePoint.y);
            if (figureUnderMouse != null) {
                GraphItem itemUnderMouse = Graph.this.figure2ItemMap.get(figureUnderMouse);
                if (itemUnderMouse instanceof GraphNode) {
                    GraphNode node = (GraphNode)itemUnderMouse;
                    Graph.this.hoverNode = node.getHideNodeHelper();
                    if (Graph.this.hoverNode != null) {
                        Graph.this.hoverNode.setHideButtonVisible(true);
                        Graph.this.hoverNode.setRevealButtonVisible(true);
                    }
                } else if (Graph.this.hoverNode != null) {
                    Graph.this.hoverNode.setHideButtonVisible(false);
                    Graph.this.hoverNode.setRevealButtonVisible(false);
                    Graph.this.hoverNode = null;
                }
                if (itemUnderMouse == this.fisheyedItem) {
                    return;
                }
                if (this.fisheyedItem != null) {
                    ((GraphNode)this.fisheyedItem).fishEye(false, true);
                    this.fisheyedItem = null;
                }
                if (itemUnderMouse != null && itemUnderMouse.getItemType() == 1) {
                    this.fisheyedItem = itemUnderMouse;
                    IFigure fisheyedFigure = ((GraphNode)itemUnderMouse).fishEye(true, true);
                    if (fisheyedFigure == null) {
                        this.fisheyedItem = null;
                    }
                } else if (this.fisheyedItem != null) {
                    ((GraphNode)this.fisheyedItem).fishEye(false, true);
                    this.fisheyedItem = null;
                    Graph.this.fisheyedFigure = null;
                }
            } else {
                if (Graph.this.hoverNode != null) {
                    Graph.this.hoverNode.setHideButtonVisible(false);
                    Graph.this.hoverNode.setRevealButtonVisible(false);
                    Graph.this.hoverNode = null;
                }
                if (this.fisheyedItem != null) {
                    ((GraphNode)this.fisheyedItem).fishEye(false, true);
                    this.fisheyedItem = null;
                    Graph.this.fisheyedFigure = null;
                }
            }
        }

        public void mouseDoubleClicked(MouseEvent me) {
            Point mousePoint = new Point(me.x, me.y);
            Graph.this.getRootLayer().translateToRelative((Translatable)mousePoint);
            IFigure figureUnderMouse = Graph.this.getFigureAt(mousePoint.x, mousePoint.y);
            if (figureUnderMouse == null) {
                return;
            }
            GraphItem itemUnderMouse = Graph.this.figure2ItemMap.get(figureUnderMouse);
            if (itemUnderMouse instanceof GraphContainer) {
                GraphContainer container = (GraphContainer)itemUnderMouse;
                Display display = Display.getCurrent();
                Shell shell = display.getActiveShell();
                shell.setLayout((Layout)new FillLayout());
                String oldShellLabel = display.getActiveShell().getText();
                StringBuilder labelBuilder = new StringBuilder();
                IContainer currentContainer = container;
                while (currentContainer instanceof GraphContainer) {
                    GraphContainer current = currentContainer;
                    labelBuilder.insert(0, current.getText());
                    labelBuilder.insert(0, '/');
                    currentContainer = current.getParent();
                }
                labelBuilder.insert(0, oldShellLabel);
                shell.setText(labelBuilder.toString());
                Graph g = new Graph((Composite)shell, 0);
                container.getGraph().setParent((Composite)new Shell());
                shell.layout();
                for (GraphNode graphNode : container.getNodes()) {
                    container.graph.removeNode(graphNode);
                    g.addNode(graphNode);
                    g.registerItem(graphNode);
                    graphNode.parent = g;
                    graphNode.graph = g;
                    graphNode.setVisible(true);
                    graphNode.unhighlight();
                    HideNodeHelper hideNodeHelper = graphNode.getHideNodeHelper();
                    if (hideNodeHelper != null) {
                        hideNodeHelper.resetCounter();
                    }
                    if (!(graphNode instanceof GraphContainer)) continue;
                    GraphContainer containerNode = (GraphContainer)graphNode;
                    g.registerChildrenOfContainer(containerNode, true);
                }
                for (GraphNode graphNode : g.getNodes()) {
                    for (GraphConnection graphConnection : graphNode.getTargetConnections()) {
                        container.graph.removeConnection(graphConnection);
                        g.addConnection(graphConnection, true);
                        g.registerItem(graphConnection);
                    }
                    for (GraphConnection graphConnection : graphNode.getSourceConnections()) {
                        container.graph.removeConnection(graphConnection);
                        g.addConnection(graphConnection, true);
                        g.registerItem(graphConnection);
                    }
                }
                g.setLayoutAlgorithm(container.getLayoutAlgorithm(), false);
                Button button = new Button(BACK_ARROW);
                button.setBounds(new Rectangle(new Point(0, 0), button.getPreferredSize()));
                button.addActionListener(event -> {
                    for (GraphNode graphNode : new ArrayList<GraphNode>(g.getNodes())) {
                        g.removeNode(graphNode);
                        container.addNode(graphNode);
                        graphContainer.graph.registerItem(graphNode);
                        graphNode.parent = container;
                        graphNode.graph = container.getGraph();
                        graphNode.unhighlight();
                        if (!(graphNode instanceof GraphContainer)) continue;
                        GraphContainer containerNode = (GraphContainer)graphNode;
                        Graph.this.registerChildrenOfContainer(containerNode, false);
                    }
                    for (GraphConnection graphConnection : new ArrayList<GraphConnection>(g.getConnections())) {
                        g.removeConnection(graphConnection);
                        graphContainer.graph.addConnection(graphConnection, false);
                        graphContainer.graph.registerItem(graphConnection);
                        graphConnection.registerConnection(graphConnection.getSource(), graphConnection.getDestination());
                        graphConnection.setVisible(true);
                    }
                    container.applyLayout();
                    g.setParent((Composite)new Shell());
                    container.getGraph().setParent((Composite)shell);
                    shell.layout();
                    shell.setText(oldShellLabel);
                    g.release();
                });
                g.rootlayer.add((IFigure)button);
                shell.addDisposeListener(e -> {
                    graph.connections.clear();
                    graph.nodes.clear();
                    g.release();
                });
            }
        }

        public void mousePressed(MouseEvent me) {
            this.isDragging = true;
            Point mousePoint = new Point(me.x, me.y);
            this.lastLocation = mousePoint.getCopy();
            Graph.this.getRootLayer().translateToRelative((Translatable)mousePoint);
            if ((me.getState() & SWT.MOD3) != 0) {
                if ((me.getState() & SWT.MOD2) == 0) {
                    double scale = Graph.this.getRootLayer().getScale();
                    Graph.this.getRootLayer().setScale(scale *= 1.05);
                    Point newMousePoint = mousePoint.getCopy().scale(1.05);
                    Point delta = new Point(newMousePoint.x - mousePoint.x, newMousePoint.y - mousePoint.y);
                    Point newViewLocation = Graph.this.getViewport().getViewLocation().getCopy().translate(delta);
                    Graph.this.getViewport().setViewLocation(newViewLocation);
                    Graph.this.clearSelection();
                } else {
                    double scale = Graph.this.getRootLayer().getScale();
                    Graph.this.getRootLayer().setScale(scale /= 1.05);
                    Point newMousePoint = mousePoint.getCopy().scale(0.9523809523809523);
                    Point delta = new Point(newMousePoint.x - mousePoint.x, newMousePoint.y - mousePoint.y);
                    Point newViewLocation = Graph.this.getViewport().getViewLocation().getCopy().translate(delta);
                    Graph.this.getViewport().setViewLocation(newViewLocation);
                    Graph.this.clearSelection();
                }
            } else {
                boolean hasSelection = !Graph.this.selectedItems.isEmpty();
                IFigure figureUnderMouse = Graph.this.getFigureAt(mousePoint.x, mousePoint.y);
                Graph.this.getRootLayer().translateFromParent((Translatable)mousePoint);
                if (figureUnderMouse != null) {
                    figureUnderMouse.getParent().translateFromParent((Translatable)mousePoint);
                }
                if (figureUnderMouse == null || figureUnderMouse == Graph.this) {
                    if ((me.getState() & SWT.MOD1) == 0) {
                        Graph.this.clearSelection();
                        if (hasSelection) {
                            Graph.this.fireWidgetSelectedEvent(null);
                            hasSelection = false;
                        }
                    }
                    return;
                }
                GraphItem itemUnderMouse = Graph.this.figure2ItemMap.get(figureUnderMouse);
                if (itemUnderMouse == null) {
                    if ((me.getState() & SWT.MOD1) != 0) {
                        Graph.this.clearSelection();
                        if (hasSelection) {
                            Graph.this.fireWidgetSelectedEvent(null);
                            hasSelection = false;
                        }
                    }
                    return;
                }
                if (Graph.this.selectedItems.contains((Object)itemUnderMouse)) {
                    if ((me.getState() & SWT.MOD1) != 0) {
                        Graph.this.selectedItems.remove((Object)itemUnderMouse);
                        itemUnderMouse.unhighlight();
                        Graph.this.fireWidgetSelectedEvent(itemUnderMouse);
                    }
                    return;
                }
                if ((me.getState() & SWT.MOD1) == 0) {
                    Graph.this.clearSelection();
                }
                if (itemUnderMouse.getItemType() == 1) {
                    Graph.this.selectedItems.add(itemUnderMouse);
                    ((GraphNode)itemUnderMouse).highlight();
                    Graph.this.fireWidgetSelectedEvent(itemUnderMouse);
                } else if (itemUnderMouse.getItemType() == 2) {
                    Graph.this.selectedItems.add(itemUnderMouse);
                    ((GraphConnection)itemUnderMouse).highlight();
                    Graph.this.fireWidgetSelectedEvent(itemUnderMouse);
                } else if (itemUnderMouse.getItemType() == 3) {
                    Graph.this.selectedItems.add(itemUnderMouse);
                    ((GraphContainer)itemUnderMouse).highlight();
                    Graph.this.fireWidgetSelectedEvent(itemUnderMouse);
                }
            }
        }

        public void mouseReleased(MouseEvent me) {
            this.isDragging = false;
            this.relativeLocations.clear();
            this.draggedSubgraphFigure = null;
        }
    }
}

