/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.math.BigInteger;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;
import org.eclipse.debug.core.model.MemoryByte;

public class MIDataReadMemoryInfo
extends MIInfo {
    BigInteger fAddress = new BigInteger("0");
    int fBytesRead;
    int fBytesRequested;
    MemoryByte[] fMemoryBlock = new MemoryByte[0];

    public MIDataReadMemoryInfo(MIOutput output) {
        super(output);
        if (this.isDone()) {
            this.parseResult(1);
        }
    }

    public MIDataReadMemoryInfo(MIOutput output, int word_size) {
        super(output);
        if (this.isDone()) {
            this.parseResult(word_size);
        }
    }

    private void parseResult(int word_size) {
        MIOutput output = this.getMIOutput();
        MIResultRecord record = output.getMIResultRecord();
        if (record != null) {
            MIResult[] results = record.getMIResults();
            int i = 0;
            while (i < results.length) {
                String size;
                MIValue value;
                String var = results[i].getVariable();
                if (var.equals("addr") && (value = results[i].getMIValue()) instanceof MIConst) {
                    String address = ((MIConst)value).getCString();
                    this.fAddress = new BigInteger(address.substring(2), 16);
                }
                if (var.equals("nr-bytes") && (value = results[i].getMIValue()) instanceof MIConst) {
                    size = ((MIConst)value).getCString();
                    this.fBytesRead = Integer.parseInt(size);
                }
                if (var.equals("total-bytes") && (value = results[i].getMIValue()) instanceof MIConst) {
                    size = ((MIConst)value).getCString();
                    this.fBytesRequested = Integer.parseInt(size);
                    this.fMemoryBlock = new MemoryByte[this.fBytesRequested];
                    int j = 0;
                    while (j < this.fMemoryBlock.length) {
                        this.fMemoryBlock[j] = new MemoryByte(0, 0);
                        ++j;
                    }
                }
                if (var.equals("memory") && (value = results[i].getMIValue()) instanceof MIList) {
                    this.parseMemoryLines((MIList)value, word_size);
                }
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseMemoryLines(MIList lines, int word_size) {
        lineValues = lines.getMIValues();
        i = 0;
        while (i < lineValues.length) {
            if (lineValues[i] instanceof MITuple) {
                tuple = (MITuple)lineValues[i];
                results = tuple.getMIResults();
                offset = 0;
                addrValue = results[0].getMIValue();
                if (addrValue instanceof MIConst) {
                    address = ((MIConst)addrValue).getCString();
                    startAddress = new BigInteger(address.substring(2), 16);
                    offset = startAddress.subtract(this.fAddress).intValue();
                }
                if ((value = results[1].getMIValue()) instanceof MIList) {
                    list = (MIList)value;
                    values = list.getMIValues();
                    byteValues = new MemoryByte[values.length * word_size];
                    j = 0;
                    while (j < values.length) {
                        block10: {
                            if (values[j] instanceof MIConst) {
                                str = ((MIConst)values[j]).getCString();
                                try {
                                    word = Long.decode(str.trim());
                                    k = 0;
                                    while (k < word_size) {
                                        bit_shift = (word_size - k - 1) * 8;
                                        byteValues[j * word_size + k] = new MemoryByte((byte)((word >> bit_shift) % 256L));
                                        ++k;
                                    }
                                    break block10;
                                }
                                catch (NumberFormatException e) {
                                    k = 0;
                                    ** while (k < word_size)
                                }
lbl-1000:
                                // 1 sources

                                {
                                    byteValues[j * word_size + k] = new MemoryByte(-1, 0);
                                    ++k;
                                    continue;
                                }
                            }
                        }
                        ++j;
                    }
                    System.arraycopy(byteValues, 0, this.fMemoryBlock, offset, byteValues.length);
                }
            }
            ++i;
        }
    }

    public MemoryByte[] getMIMemoryBlock() {
        return this.fMemoryBlock;
    }
}

