/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.filebrowser;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.examples.dsf.filebrowser.FileBrowserVMProvider;
import org.eclipse.cdt.examples.dsf.filebrowser.FileVMContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

class FileVMNode
implements IElementLabelProvider,
IVMNode {
    private final FileBrowserVMProvider fProvider;
    private final IVMNode[] fChildNodes = new IVMNode[]{this};
    private static final File[] EMPTY_FILE_LIST = new File[0];

    public FileVMNode(FileBrowserVMProvider provider) {
        this.fProvider = provider;
    }

    public String toString() {
        return "FileVMNode";
    }

    public void dispose() {
    }

    public void setChildNodes(IVMNode[] childNodes) {
        throw new UnsupportedOperationException("This node does not support children.");
    }

    public IVMNode[] getChildNodes() {
        return this.fChildNodes;
    }

    public void update(final IHasChildrenUpdate[] updates) {
        new Job(""){
            {
                super($anonymous0);
                this.setSystem(true);
                this.setPriority(10);
            }

            protected IStatus run(IProgressMonitor monitor) {
                IHasChildrenUpdate[] iHasChildrenUpdateArray = updates;
                int n = updates.length;
                int n2 = 0;
                while (n2 < n) {
                    IHasChildrenUpdate update = iHasChildrenUpdateArray[n2];
                    FileVMContext vmc = (FileVMContext)((Object)update.getElement());
                    update.setHasChilren(vmc.getFile().isDirectory());
                    update.done();
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void update(final IChildrenCountUpdate[] updates) {
        new Job(""){
            {
                super($anonymous0);
                this.setSystem(true);
                this.setPriority(10);
            }

            protected IStatus run(IProgressMonitor monitor) {
                IChildrenCountUpdate[] iChildrenCountUpdateArray = updates;
                int n = updates.length;
                int n2 = 0;
                while (n2 < n) {
                    IChildrenCountUpdate update = iChildrenCountUpdateArray[n2];
                    update.setChildCount(FileVMNode.this.getFiles((IViewerUpdate)update).length);
                    update.done();
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void update(final IChildrenUpdate[] updates) {
        new Job(""){
            {
                super($anonymous0);
                this.setSystem(true);
                this.setPriority(10);
            }

            protected IStatus run(IProgressMonitor monitor) {
                IChildrenUpdate[] iChildrenUpdateArray = updates;
                int n = updates.length;
                int n2 = 0;
                while (n2 < n) {
                    IChildrenUpdate update = iChildrenUpdateArray[n2];
                    File[] files = FileVMNode.this.getFiles((IViewerUpdate)update);
                    int offset = update.getOffset() != -1 ? update.getOffset() : 0;
                    int length = update.getLength() != -1 ? update.getLength() : files.length;
                    int i = offset;
                    while (i < files.length && i < offset + length) {
                        update.setChild((Object)new FileVMContext(FileVMNode.this, files[i]), i);
                        ++i;
                    }
                    update.done();
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void update(final ILabelUpdate[] updates) {
        new Job(""){
            {
                super($anonymous0);
                this.setSystem(true);
                this.setPriority(10);
            }

            protected IStatus run(IProgressMonitor monitor) {
                ILabelUpdate[] iLabelUpdateArray = updates;
                int n = updates.length;
                int n2 = 0;
                while (n2 < n) {
                    ILabelUpdate update = iLabelUpdateArray[n2];
                    update.setLabel(FileVMNode.this.getLabel((FileVMContext)((Object)update.getElement())), 0);
                    update.done();
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private File[] getFiles(IViewerUpdate update) {
        FileVMContext vmc = (FileVMContext)((Object)update.getElement());
        File[] files = vmc.getFile().listFiles();
        return files != null ? files : EMPTY_FILE_LIST;
    }

    private String getLabel(FileVMContext vmc) {
        return vmc.getFile().getName();
    }

    public void getContextsForEvent(VMDelta parentDelta, Object event, DataRequestMonitor<IVMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10003, "", null));
        rm.done();
    }

    public int getDeltaFlags(Object e) {
        int retVal = 0;
        if (e instanceof String) {
            retVal |= 0x300000;
        }
        return retVal;
    }

    public void buildDelta(final Object event, final VMDelta parentDelta, final int nodeOffset, final RequestMonitor requestMonitor) {
        if (event instanceof String) {
            new Job(""){
                {
                    super($anonymous0);
                    this.setSystem(true);
                    this.setPriority(10);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    File eventFile = new File((String)event);
                    File parentFile = null;
                    if (parentDelta.getElement() instanceof FileVMContext) {
                        parentFile = ((FileVMContext)((Object)parentDelta.getElement())).getFile();
                    }
                    if (eventFile.exists() && parentFile != null) {
                        LinkedList<File> filePath = new LinkedList<File>();
                        File file = eventFile;
                        while (file != null && !file.equals(parentFile)) {
                            filePath.add(0, file);
                            file = file.getParentFile();
                        }
                        if (filePath.size() != 0) {
                            VMDelta delta = parentDelta;
                            File[] allFilesInDirectory = parentFile.listFiles();
                            for (File pathSegment : filePath) {
                                if (!$assertionsDisabled && allFilesInDirectory == null) {
                                    throw new AssertionError();
                                }
                                File[] pathSegmentDirectoryFiles = pathSegment.listFiles();
                                delta = delta.addNode((Object)new FileVMContext(FileVMNode.this, pathSegment), nodeOffset + Arrays.asList(allFilesInDirectory).indexOf(pathSegment), 0, pathSegmentDirectoryFiles != null ? pathSegmentDirectoryFiles.length : 0);
                                allFilesInDirectory = pathSegmentDirectoryFiles;
                            }
                            delta.setFlags(delta.getFlags() | 0x200000 | 0x100000);
                        }
                    }
                    requestMonitor.done();
                    return Status.OK_STATUS;
                }
            }.schedule();
        } else {
            requestMonitor.done();
        }
    }

    protected Map<IVMNode, Integer> getChildNodesWithDeltas(Object e) {
        HashMap<IVMNode, Integer> nodes = new HashMap<IVMNode, Integer>();
        IVMNode[] iVMNodeArray = this.getChildNodes();
        int n = iVMNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMNode childNode = iVMNodeArray[n2];
            int delta = childNode.getDeltaFlags(e);
            if (delta != 0) {
                nodes.put(childNode, delta);
            }
            ++n2;
        }
        return nodes;
    }

    public IVMProvider getVMProvider() {
        return this.fProvider;
    }
}

