/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.internal.help;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.util.JavadocHelpContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.ui.IWorkbenchPart;

public class VisualiserHelp {
    public static void setHelp(StructuredViewer viewer, String contextId) {
        XRefUIHelpListener listener = new XRefUIHelpListener(viewer, contextId);
        viewer.getControl().addHelpListener((HelpListener)listener);
    }

    public static IContextProvider getHelpContextProvider(IWorkbenchPart part, String contextId) {
        IStructuredSelection selection;
        try {
            selection = SelectionConverter.getStructuredSelection((IWorkbenchPart)part);
        }
        catch (JavaModelException ex) {
            selection = StructuredSelection.EMPTY;
        }
        Object[] elements = selection.toArray();
        return new XRefUIHelpContextProvider(contextId, elements);
    }

    private static class XRefUIHelpContextProvider
    implements IContextProvider {
        private String fId;
        private Object[] fSelected;

        public XRefUIHelpContextProvider(String id, Object[] selected) {
            this.fId = id;
            this.fSelected = selected;
        }

        public int getContextChangeMask() {
            return 1;
        }

        public IContext getContext(Object target) {
            IContext context = HelpSystem.getContext((String)this.fId);
            if (this.fSelected != null && this.fSelected.length > 0) {
                try {
                    context = new JavadocHelpContext(context, this.fSelected);
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            return context;
        }

        public String getSearchExpression(Object target) {
            return null;
        }
    }

    private static class XRefUIHelpListener
    implements HelpListener {
        private StructuredViewer fViewer;
        private String fContextId;

        public XRefUIHelpListener(StructuredViewer viewer, String contextId) {
            this.fViewer = viewer;
            this.fContextId = contextId;
        }

        public void helpRequested(HelpEvent e) {
            try {
                Object[] selected = null;
                ISelection selection = this.fViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    selected = ((IStructuredSelection)selection).toArray();
                }
                JavadocHelpContext.displayHelp((String)this.fContextId, (Object[])selected);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }
}

