/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.internal.caching;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.eclipse.equinox.service.weaving.CacheEntry;
import org.eclipse.equinox.service.weaving.ICachingService;
import org.eclipse.equinox.weaving.internal.caching.CacheItem;
import org.eclipse.equinox.weaving.internal.caching.Log;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleCachingService
implements ICachingService {
    private static final int READ_BUFFER_SIZE = 8192;
    private final Bundle bundle;
    private File cacheDirectory;
    private final String cacheKey;
    private final BlockingQueue<CacheItem> cacheWriterQueue;

    public BundleCachingService(BundleContext bundleContext, Bundle bundle, String string, BlockingQueue<CacheItem> blockingQueue) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("Argument \"bundleContext\" must not be null!");
        }
        if (bundle == null) {
            throw new IllegalArgumentException("Argument \"bundle\" must not be null!");
        }
        if (string == null) {
            throw new IllegalArgumentException("Argument \"key\" must not be null!");
        }
        this.bundle = bundle;
        this.cacheKey = this.hashNamespace(string);
        this.cacheWriterQueue = blockingQueue;
        File file = bundleContext.getDataFile(this.cacheKey);
        if (file != null) {
            String string2 = String.valueOf(bundle.getBundleId()) + "-" + bundle.getLastModified();
            this.cacheDirectory = new File(file, string2);
        } else {
            Log.error("Cannot initialize cache!", null);
        }
    }

    public boolean canCacheGeneratedClasses() {
        return true;
    }

    public CacheEntry findStoredClass(String string, URL uRL, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Argument \"name\" must not be null!");
        }
        byte[] byArray = null;
        boolean bl = false;
        if (this.cacheDirectory != null) {
            File file = new File(this.cacheDirectory, string2);
            byArray = this.read(string2, file);
            boolean bl2 = bl = byArray != null;
        }
        if (Log.isDebugEnabled()) {
            Log.debug(MessageFormat.format("for [{0}]: {1} {2}", this.bundle.getSymbolicName(), byArray != null ? "Found" : "Found NOT", string2));
        }
        return new CacheEntry(bl, byArray);
    }

    public void stop() {
    }

    public boolean storeClass(String string, URL uRL, Class<?> clazz, byte[] byArray) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument \"clazz\" must not be null!");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Argument \"classbytes\" must not be null!");
        }
        if (this.cacheDirectory == null) {
            return false;
        }
        CacheItem cacheItem = new CacheItem(byArray, this.cacheDirectory.getAbsolutePath(), clazz.getName());
        return this.cacheWriterQueue.offer(cacheItem);
    }

    public boolean storeClassAndGeneratedClasses(String string, URL uRL, Class<?> clazz, byte[] byArray, Map<String, byte[]> map) {
        CacheItem cacheItem = new CacheItem(byArray, this.cacheDirectory.getAbsolutePath(), clazz.getName(), map);
        return this.cacheWriterQueue.offer(cacheItem);
    }

    private String hashNamespace(String string) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        byte[] byArray = messageDigest.digest(string.getBytes());
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray2 = byArray;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray2[n2];
            int n4 = n3 < 0 ? n3 + 256 : n3;
            String string2 = Integer.toHexString(n4);
            while (string2.length() < 2) {
                string2 = "0" + string2;
            }
            stringBuffer.append(string2);
            ++n2;
        }
        return new String(stringBuffer);
    }

    /*
     * Loose catch block
     */
    private byte[] read(String string, File file) {
        byte[] byArray;
        InputStream inputStream;
        block20: {
            byte[] byArray2;
            int n = (int)file.length();
            inputStream = null;
            byte[] byArray3 = new byte[n];
            int n2 = 0;
            inputStream = new FileInputStream(file);
            if (n > 0) {
                byArray3 = new byte[n];
                while (n2 < n) {
                    int n3 = inputStream.read(byArray3, n2, n - n2);
                    if (n3 > 0) {
                        n2 += n3;
                        continue;
                    }
                    break;
                }
            } else {
                n = 8192;
                byArray3 = new byte[n];
                while (true) {
                    if (n2 < n) {
                        int n4 = inputStream.read(byArray3, n2, n - n2);
                        if (n4 > 0) {
                            n2 += n4;
                            continue;
                        }
                        break;
                    }
                    byArray2 = byArray3;
                    byArray3 = new byte[n += 8192];
                    System.arraycopy(byArray2, 0, byArray3, 0, n2);
                }
            }
            if (byArray3.length > n2) {
                byArray2 = byArray3;
                byArray3 = new byte[n2];
                System.arraycopy(byArray2, 0, byArray3, 0, n2);
            }
            byArray = byArray3;
            if (inputStream == null) break block20;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                Log.error(MessageFormat.format("for [{0}]: Cannot close cache file for [1]!", this.bundle.getSymbolicName(), string), iOException);
            }
        }
        return byArray;
        catch (IOException iOException) {
            block21: {
                try {
                    Log.debug(MessageFormat.format("for [{0}]: Cannot read [1] from cache!", this.bundle.getSymbolicName(), string));
                    if (inputStream == null) break block21;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {
                            Log.error(MessageFormat.format("for [{0}]: Cannot close cache file for [1]!", this.bundle.getSymbolicName(), string), iOException2);
                        }
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException3) {
                    Log.error(MessageFormat.format("for [{0}]: Cannot close cache file for [1]!", this.bundle.getSymbolicName(), string), iOException3);
                }
            }
            return null;
        }
    }
}

