/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.search;

import java.util.LinkedList;
import java.util.List;
import org.aspectj.org.eclipse.jdt.core.dom.AnyWithAnnotationTypePattern;
import org.aspectj.org.eclipse.jdt.core.dom.DeclareAnnotationDeclaration;
import org.aspectj.org.eclipse.jdt.core.dom.IdentifierTypePattern;
import org.aspectj.org.eclipse.jdt.core.dom.PatternNode;
import org.aspectj.org.eclipse.jdt.core.dom.SimpleName;
import org.aspectj.org.eclipse.jdt.core.dom.TypeCategoryTypePattern;
import org.aspectj.org.eclipse.jdt.core.dom.TypePattern;
import org.eclipse.ajdt.core.javaelements.DeclareElement;
import org.eclipse.ajdt.core.javaelements.IAspectJElement;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.internal.core.search.AbstractExtraReferenceFinder;
import org.eclipse.ajdt.internal.core.search.IExtraMatchFinder;
import org.eclipse.ajdt.internal.core.search.TargetTypeUtils;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.PackageReferenceMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.internal.core.search.matching.PackageReferencePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtraPackageReferenceFinder
extends AbstractExtraReferenceFinder<PackageReferencePattern>
implements IExtraMatchFinder<PackageReferencePattern> {
    private char[] pkgNames;

    @Override
    protected List<IAspectJElement> getRelevantChildren(IParent parent) throws JavaModelException {
        IJavaElement[] children = parent.getChildren();
        LinkedList<IAspectJElement> allItds = new LinkedList<IAspectJElement>();
        IJavaElement[] iJavaElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement elt = iJavaElementArray[n2];
            if (elt instanceof IntertypeElement || elt instanceof DeclareElement) {
                allItds.add((IAspectJElement)elt);
            } else if (elt.getElementType() == 7) {
                allItds.addAll(this.getRelevantChildren((IParent)elt));
            }
            ++n2;
        }
        return allItds;
    }

    @Override
    protected boolean isMatch(IntertypeElement itd, PackageReferencePattern pattern) {
        this.ensurePkgNames(pattern);
        return this.pkgNames != null && CharOperation.compareWith((char[])itd.getTargetTypeName().toCharArray(), (char[])this.pkgNames) == 0;
    }

    private void ensurePkgNames(PackageReferencePattern pattern) {
        char[] packageTmp;
        if (this.pkgNames == null && (packageTmp = TargetTypeUtils.getPackage(pattern)) != null) {
            this.pkgNames = new char[packageTmp.length + 1];
            System.arraycopy(packageTmp, 0, this.pkgNames, 0, packageTmp.length);
            this.pkgNames[this.pkgNames.length - 1] = 46;
        }
    }

    @Override
    protected SearchMatch createITDMatch(IntertypeElement itd, SearchParticipant participant) throws JavaModelException {
        ISourceRange sourceRange = itd.getTargetTypeSourceRange();
        int offset = sourceRange.getOffset();
        int length = this.pkgNames.length - 1;
        return new PackageReferenceMatch((IJavaElement)itd, 0, offset, length, false, participant, itd.getResource());
    }

    @Override
    protected AbstractExtraReferenceFinder.DeclareVisitor createDeclareVisitor(char[] contents, DeclareElement decl, SearchParticipant participant, PackageReferencePattern pattern) throws JavaModelException {
        this.ensurePkgNames(pattern);
        return new PackageReferenceDeclareVisitor(this.pkgNames, participant, decl, contents);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PackageReferenceDeclareVisitor
    extends AbstractExtraReferenceFinder.DeclareVisitor {
        public PackageReferenceDeclareVisitor(char[] pkgNames, SearchParticipant participant, DeclareElement decl, char[] fileContents) throws JavaModelException {
            super(participant, decl, fileContents);
        }

        public boolean visit(IdentifierTypePattern node) {
            this.findMatchInTypePattern((TypePattern)node);
            return super.visit(node);
        }

        public boolean visit(AnyWithAnnotationTypePattern node) {
            this.findMatchInTypePattern((TypePattern)node);
            return true;
        }

        public boolean visit(TypeCategoryTypePattern node) {
            this.findMatchInTypePattern((TypePattern)node);
            return true;
        }

        protected void findMatchInTypePattern(TypePattern node) {
            String detail = node.getTypePatternExpression();
            if (detail != null) {
                if (this.isMatch(detail, 0, detail.length())) {
                    int actualStart = node.getStartPosition() + this.offset;
                    this.acceptMatch((SearchMatch)new PackageReferenceMatch((IJavaElement)this.decl, 0, actualStart, ExtraPackageReferenceFinder.this.pkgNames.length - 1, false, this.participant, this.decl.getResource()));
                } else if (this.isComplexTypePattern(detail)) {
                    this.findMatchesInComplexPattern((PatternNode)node);
                }
            }
        }

        public boolean visit(SimpleName node) {
            String name;
            if (node.getParent() instanceof DeclareAnnotationDeclaration && (name = node.toString()).charAt(0) == '@' && this.isMatch(name, 1, name.length())) {
                int actualStart = node.getStartPosition() + 1 + this.offset;
                int actualLength = ExtraPackageReferenceFinder.this.pkgNames.length - 1;
                this.acceptMatch((SearchMatch)new PackageReferenceMatch((IJavaElement)this.decl, 0, actualStart, actualLength, false, this.participant, this.decl.getResource()));
            }
            return super.visit(node);
        }

        private boolean isMatch(String name, int start, int end) {
            char[] nameArr = CharOperation.subarray((char[])name.toCharArray(), (int)start, (int)end);
            char[][] actualPackageFragments = CharOperation.splitAndTrimOn((char)'.', (char[])nameArr);
            char[] strippedNameArr = CharOperation.concatWith((char[][])actualPackageFragments, (char)'.');
            return CharOperation.prefixEquals((char[])ExtraPackageReferenceFinder.this.pkgNames, (char[])strippedNameArr);
        }

        @Override
        protected void findMatchesInComplexPattern(PatternNode node) {
        }
    }
}

