/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.ajde;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.ajde.core.IBuildMessageHandler;
import org.aspectj.bridge.IMessage;
import org.eclipse.ajdt.core.AJLog;

public class CoreBuildMessageHandler
implements IBuildMessageHandler {
    private static final boolean USE_LOG = Boolean.parseBoolean(System.getProperty("ajdt.showMessagesInLog", Boolean.FALSE.toString()));
    private List<IMessage.Kind> ignoring = new ArrayList<IMessage.Kind>();

    public CoreBuildMessageHandler() {
        this.ignore(IMessage.INFO);
        this.ignore(IMessage.WEAVEINFO);
    }

    public boolean handleMessage(IMessage message) {
        if (!USE_LOG) {
            return true;
        }
        IMessage.Kind kind = message.getKind();
        if (kind.equals(IMessage.ABORT)) {
            AJLog.log(1, "AJC: Compiler error: " + message.getMessage());
            message.getThrown().printStackTrace();
        }
        if (this.isIgnoring(kind)) {
            return true;
        }
        AJLog.log(1, "AJC: " + message);
        return true;
    }

    public void dontIgnore(IMessage.Kind kind) {
        if (kind != null) {
            this.ignoring.remove(kind);
        }
    }

    public boolean isIgnoring(IMessage.Kind kind) {
        return kind != null && this.ignoring.contains(kind);
    }

    public void ignore(IMessage.Kind kind) {
        if (kind != null && !this.ignoring.contains(kind)) {
            this.ignoring.add(kind);
        }
    }
}

