/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.jdt;

import java.net.URL;
import org.eclipse.contribution.jdt.IsWovenTester;
import org.eclipse.contribution.jdt.preferences.AskToReindexJob;
import org.eclipse.contribution.jdt.preferences.EnableWeavingServiceJob;
import org.eclipse.contribution.jdt.preferences.JDTWeavingPreferences;
import org.eclipse.contribution.jdt.preferences.WeavableProjectListener;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JDTWeavingPlugin
extends AbstractUIPlugin {
    private static JDTWeavingPlugin INSTANCE;
    public static String ID;
    public static final String IMG_ASPECTJ_32 = "icons/aspectj32.png";
    public static ImageDescriptor DESC_ASPECTJ_32;

    static {
        ID = "org.eclipse.contribution.weaving.jdt";
    }

    public JDTWeavingPlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initImages();
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        workspace.addLifecycleListener((ILifecycleListener)WeavableProjectListener.getInstance());
        if (!IsWovenTester.isWeavingActive() && JDTWeavingPreferences.shouldAskToEnableWeaving()) {
            boolean found = false;
            IProject[] projects = workspace.getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                if (WeavableProjectListener.getInstance().isWeavableProject(projects[i])) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) {
                new EnableWeavingServiceJob().schedule();
            }
        }
        if (JDTWeavingPreferences.shouldAskToReindex()) {
            new AskToReindexJob().schedule();
        }
    }

    protected void initImages() {
        DESC_ASPECTJ_32 = JDTWeavingPlugin.createDescriptor(IMG_ASPECTJ_32);
    }

    public static void logException(Throwable t) {
        INSTANCE.getLog().log((IStatus)new Status(4, ID, t.getMessage(), t));
    }

    public static void logException(String message, Throwable t) {
        INSTANCE.getLog().log((IStatus)new Status(4, ID, message, t));
    }

    public static JDTWeavingPlugin getInstance() {
        return INSTANCE;
    }

    public static ImageDescriptor createDescriptor(String path) {
        URL url = JDTWeavingPlugin.getInstance().getBundle().getEntry(path);
        ImageDescriptor descriptor = url == null ? ImageDescriptor.getMissingImageDescriptor() : ImageDescriptor.createFromURL((URL)url);
        return descriptor;
    }
}

