/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.contentassist;

import java.util.ArrayList;
import org.aspectj.asm.IProgramElement;
import org.eclipse.ajdt.core.codeconversion.AspectsConvertingParser;
import org.eclipse.ajdt.core.codeconversion.ConversionOptions;
import org.eclipse.ajdt.core.codeconversion.ITDAwareNameEnvironment;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.core.text.ITDAwareSelectionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.codeassist.ISelectionRequestor;
import org.eclipse.jdt.internal.codeassist.SelectionEngine;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jface.text.IRegion;

public class ITDCodeSelection {
    private final ICompilationUnit unit;

    public ITDCodeSelection(ICompilationUnit unit) {
        this.unit = unit;
    }

    public IJavaElement[] findJavaElement(IRegion wordRegion) throws JavaModelException {
        JavaProject javaProject = (JavaProject)this.unit.getJavaProject();
        ITDAwareNameEnvironment environment = new ITDAwareNameEnvironment(javaProject, this.unit.getOwner(), null);
        ITDAwareSelectionRequestor requestor = new ITDAwareSelectionRequestor(AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)javaProject), this.unit);
        SelectionEngine engine = new SelectionEngine((SearchableEnvironment)environment, (ISelectionRequestor)requestor, javaProject.getOptions(true), this.unit.getOwner());
        final AspectsConvertingParser converter = new AspectsConvertingParser(((CompilationUnit)this.unit).getContents());
        converter.setUnit(this.unit);
        ArrayList<AspectsConvertingParser.Replacement> replacements = converter.convert(ConversionOptions.CODE_COMPLETION);
        CompilationUnit wrappedUnit = new CompilationUnit((PackageFragment)this.unit.getParent(), this.unit.getElementName(), this.unit.getOwner()){

            public char[] getContents() {
                return converter.content;
            }
        };
        int transformedStart = AspectsConvertingParser.translatePositionToAfterChanges(wordRegion.getOffset(), replacements);
        int transformedEnd = AspectsConvertingParser.translatePositionToAfterChanges(wordRegion.getOffset() + wordRegion.getLength(), replacements) - 1;
        requestor.setReplacements(replacements);
        engine.select((org.eclipse.jdt.internal.compiler.env.ICompilationUnit)wrappedUnit, transformedStart, transformedEnd);
        IntertypeElement itd = this.itdOrNull(this.unit, wordRegion.getOffset());
        if (itd != null && (itd.getAJKind() == IProgramElement.Kind.INTER_TYPE_METHOD || itd.getAJKind() == IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR)) {
            char[] targetType = itd.getTargetType();
            final AspectsConvertingParser converter2 = new AspectsConvertingParser(((CompilationUnit)this.unit).getContents());
            converter2.setUnit(this.unit);
            ArrayList<AspectsConvertingParser.Replacement> replacements2 = converter2.convert(ConversionOptions.getCodeCompletionOptionWithContextSwitch(wordRegion.getOffset(), targetType));
            wrappedUnit = new CompilationUnit((PackageFragment)this.unit.getParent(), this.unit.getElementName(), this.unit.getOwner()){

                public char[] getContents() {
                    return converter2.content;
                }
            };
            transformedStart = AspectsConvertingParser.translatePositionToAfterChanges(wordRegion.getOffset(), replacements2);
            transformedEnd = AspectsConvertingParser.translatePositionToAfterChanges(wordRegion.getOffset() + wordRegion.getLength(), replacements2) - 1;
            requestor.setReplacements(replacements2);
            SelectionEngine engine2 = new SelectionEngine((SearchableEnvironment)environment, (ISelectionRequestor)requestor, javaProject.getOptions(true), this.unit.getOwner());
            engine2.select((org.eclipse.jdt.internal.compiler.env.ICompilationUnit)wrappedUnit, transformedStart, transformedEnd);
        }
        IJavaElement[] elements = requestor.getElements();
        if (itd != null && elements.length == 0 && itd.getNameRange().getOffset() <= wordRegion.getOffset() && itd.getNameRange().getLength() >= wordRegion.getLength()) {
            elements = new IJavaElement[]{itd};
        }
        return elements;
    }

    private IntertypeElement itdOrNull(ICompilationUnit unit, int pos) throws JavaModelException {
        IJavaElement elt;
        if (unit instanceof AJCompilationUnit && (elt = unit.getElementAt(pos)) instanceof IntertypeElement) {
            IntertypeElement itd = (IntertypeElement)elt;
            return itd;
        }
        return null;
    }
}

