/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.refactoring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJProperties;
import org.eclipse.ajdt.internal.ui.ajde.AJDTErrorHandler;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.refactoring.ReaderInputStream;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;

public class RenamingUtils {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    public static void renameFile(boolean newExtensionIsAJ, IResource file, IProgressMonitor monitor, Map oldToNewNames) {
        if (!file.exists()) {
            return;
        }
        String oldName = file.getName();
        String nameWithoutExtension = oldName.substring(0, oldName.indexOf(46));
        String newExtension = newExtensionIsAJ ? ".aj" : ".java";
        RenameResourceChange change = new RenameResourceChange(file.getFullPath(), String.valueOf(nameWithoutExtension) + newExtension);
        try {
            change.perform(monitor);
            oldToNewNames.put(oldName, String.valueOf(nameWithoutExtension) + newExtension);
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(coreException, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            CoreException e = coreException;
            AJDTErrorHandler.handleAJDTError(UIMessages.Refactoring_ErrorRenamingResource, e);
        }
    }

    public static void updateBuildConfigurations(Map oldNamesToNewNames, IProject project, IProgressMonitor monitor) {
        List buildConfigs = AJProperties.getAJPropertiesFiles((IProject)project);
        for (IFile buildConfig : buildConfigs) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(buildConfig.getContents()));
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(coreException, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
                continue;
            }
            StringBuffer sb = new StringBuffer();
            try {
                String line = br.readLine();
                while (line != null) {
                    for (String oldName : oldNamesToNewNames.keySet()) {
                        String newName = (String)oldNamesToNewNames.get(oldName);
                        line = line.replaceAll(oldName, newName);
                    }
                    sb.append(line);
                    sb.append(System.getProperty("line.separator"));
                    line = br.readLine();
                }
                StringReader reader = new StringReader(sb.toString());
                buildConfig.setContents((InputStream)new ReaderInputStream(reader), true, true, monitor);
            }
            catch (IOException iOException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(iOException, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_3);
                try {
                    br.close();
                }
                catch (IOException iOException2) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(iOException2, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_3);
                }
                continue;
            }
            catch (CoreException coreException) {
                try {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(coreException, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_3);
                }
                catch (Throwable throwable) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(iOException, ajc$tjp_8, (JoinPoint.StaticPart)ajc$tjp_3);
                    }
                    throw throwable;
                }
                try {
                    br.close();
                }
                catch (IOException iOException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(iOException, ajc$tjp_7, (JoinPoint.StaticPart)ajc$tjp_3);
                }
                continue;
            }
            try {
                br.close();
            }
            catch (IOException iOException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$1$31280822(iOException, ajc$tjp_9, (JoinPoint.StaticPart)ajc$tjp_3);
            }
        }
    }

    static {
        Factory factory = new Factory("RenamingUtils.java", Class.forName("org.eclipse.ajdt.internal.ui.refactoring.RenamingUtils"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.RenamingUtils", "org.eclipse.core.runtime.CoreException:", "e:"), 56);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "renameFile", "org.eclipse.ajdt.internal.ui.refactoring.RenamingUtils", "boolean:org.eclipse.core.resources.IResource:org.eclipse.core.runtime.IProgressMonitor:java.util.Map:", "newExtensionIsAJ:file:monitor:oldToNewNames:", "", "void"), 42);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.RenamingUtils", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 70);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "updateBuildConfigurations", "org.eclipse.ajdt.internal.ui.refactoring.RenamingUtils", "java.util.Map:org.eclipse.core.resources.IProject:org.eclipse.core.runtime.IProgressMonitor:", "oldNamesToNewNames:project:monitor:", "", "void"), 61);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.RenamingUtils", "java.io.IOException:", "<missing>:"), 91);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.RenamingUtils", "java.io.IOException:", "<missing>:"), 96);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.RenamingUtils", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 92);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.RenamingUtils", "java.io.IOException:", "<missing>:"), 96);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.RenamingUtils", "java.io.IOException:", "<missing>:"), 96);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.refactoring.RenamingUtils", "java.io.IOException:", "<missing>:"), 96);
    }
}

