/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcherExtension;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CharacterPair;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeHelper;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeInfo;

public class LanguageConfigurationCharacterPairMatcher
implements ICharacterPairMatcher,
ICharacterPairMatcherExtension {
    private @Nullable DefaultCharacterPairMatcher matcher;
    private @Nullable IDocument document;

    public @Nullable IRegion match(@Nullable IDocument document, int offset) {
        if (document == null) {
            return null;
        }
        DefaultCharacterPairMatcher matcher = this.getMatcher(document);
        return matcher != null ? matcher.match(document, offset) : null;
    }

    public @Nullable IRegion match(@Nullable IDocument document, int offset, int length) {
        if (document == null) {
            return null;
        }
        DefaultCharacterPairMatcher matcher = this.getMatcher(document);
        return matcher != null ? matcher.match(document, offset, length) : null;
    }

    public int getAnchor() {
        return this.matcher != null ? this.matcher.getAnchor() : -1;
    }

    public @Nullable IRegion findEnclosingPeerCharacters(@Nullable IDocument document, int offset, int length) {
        if (document == null) {
            return null;
        }
        DefaultCharacterPairMatcher matcher = this.getMatcher(document);
        return matcher != null ? matcher.findEnclosingPeerCharacters(document, offset, length) : null;
    }

    public boolean isMatchedChar(char ch) {
        IDocument document = this.document;
        if (document == null) {
            return false;
        }
        DefaultCharacterPairMatcher matcher = this.getMatcher(document);
        return matcher != null ? matcher.isMatchedChar(ch) : false;
    }

    public boolean isMatchedChar(char ch, @Nullable IDocument document, int offset) {
        if (document == null) {
            return false;
        }
        DefaultCharacterPairMatcher matcher = this.getMatcher(document);
        return matcher != null ? matcher.isMatchedChar(ch, document, offset) : false;
    }

    public boolean isRecomputationOfEnclosingPairRequired(@Nullable IDocument document, @Nullable IRegion currentSelection, @Nullable IRegion previousSelection) {
        if (document == null) {
            return false;
        }
        DefaultCharacterPairMatcher matcher = this.getMatcher(document);
        return matcher != null ? matcher.isRecomputationOfEnclosingPairRequired(document, currentSelection, previousSelection) : false;
    }

    public void dispose() {
        if (this.matcher != null) {
            this.matcher.dispose();
        }
        this.matcher = null;
    }

    public void clear() {
        if (this.matcher != null) {
            this.matcher.clear();
        }
    }

    private @Nullable DefaultCharacterPairMatcher getMatcher(IDocument document) {
        if (!document.equals(this.document)) {
            this.matcher = null;
        }
        if (this.matcher == null) {
            StringBuilder sb = new StringBuilder();
            this.document = document;
            IContentType[] contentTypes = this.findContentTypes(document);
            if (contentTypes != null) {
                LanguageConfigurationRegistryManager registry = LanguageConfigurationRegistryManager.getInstance();
                IContentType[] iContentTypeArray = contentTypes;
                int n = contentTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IContentType contentType = iContentTypeArray[n2];
                    if (registry.shouldSurroundingPairs(document, -1, contentType)) {
                        List<CharacterPair> surroundingPairs = registry.getSurroundingPairs(contentType);
                        for (CharacterPair surroundingPair : surroundingPairs) {
                            sb.append((String)surroundingPair.getKey());
                            sb.append((String)surroundingPair.getValue());
                        }
                    }
                    ++n2;
                }
            }
            char[] chars = new char[sb.length()];
            sb.getChars(0, sb.length(), chars, 0);
            this.matcher = new DefaultCharacterPairMatcher(chars);
        }
        return this.matcher;
    }

    private IContentType @Nullable [] findContentTypes(IDocument document) {
        try {
            ContentTypeInfo info = ContentTypeHelper.findContentTypes((IDocument)document);
            if (info != null) {
                return info.getContentTypes();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }
}

