/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.framework;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.tests.framework.AbstractTestSuiteHolder;
import org.osgi.framework.Bundle;

public abstract class DelegatingTestSuiteHolder
extends AbstractTestSuiteHolder {
    private static final String SUITE_EXTENSION_POINT_NAME = "org.eclipse.rse.tests.framework.suites";
    private static final String TYPE_ELEMENT = "type";
    private static final String SUITE_ELEMENT = "suite";
    private static final String ARGUMENT_ELEMENT = "arg";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String VALUE_ATTRIBUTE = "value";
    private String name;
    private IConfigurationElement config;

    private static DelegatingTestSuiteHolder getSuiteHolder(String wantedTypeName) {
        DelegatingTestSuiteHolder holder = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] configs = registry.getConfigurationElementsFor(SUITE_EXTENSION_POINT_NAME);
        int i = 0;
        while (i < configs.length) {
            String candidateTypeName;
            IConfigurationElement config = configs[i];
            String elementName = config.getName();
            if (elementName.equals("type") && (candidateTypeName = config.getAttribute(NAME_ATTRIBUTE)).equals(wantedTypeName)) {
                try {
                    holder = (DelegatingTestSuiteHolder)config.createExecutableExtension(CLASS_ATTRIBUTE);
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return holder;
    }

    public static DelegatingTestSuiteHolder[] getHolders() {
        Vector<DelegatingTestSuiteHolder> holders = new Vector<DelegatingTestSuiteHolder>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] configs = registry.getConfigurationElementsFor(SUITE_EXTENSION_POINT_NAME);
        int i = 0;
        while (i < configs.length) {
            IConfigurationElement config = configs[i];
            String elementName = config.getName();
            if (elementName.equals(SUITE_ELEMENT)) {
                String suiteType = config.getAttribute("type");
                String suiteName = config.getAttribute(NAME_ATTRIBUTE);
                DelegatingTestSuiteHolder holder = DelegatingTestSuiteHolder.getSuiteHolder(suiteType);
                if (holder != null) {
                    holder.setConfiguration(config);
                    holder.setName(suiteName);
                    holders.add(holder);
                }
            }
            ++i;
        }
        DelegatingTestSuiteHolder[] result = new DelegatingTestSuiteHolder[holders.size()];
        holders.toArray(result);
        return result;
    }

    protected IConfigurationElement getArgumentElement(String name) {
        IConfigurationElement result = null;
        IConfigurationElement[] argumentElements = this.config.getChildren(ARGUMENT_ELEMENT);
        int i = 0;
        while (i < argumentElements.length && result == null) {
            IConfigurationElement argumentElement = argumentElements[i];
            String argumentName = argumentElement.getAttribute(NAME_ATTRIBUTE);
            if (argumentName.equals(name)) {
                result = argumentElement;
            }
            ++i;
        }
        return result;
    }

    protected String getStringValue(String name) {
        String result = null;
        IConfigurationElement element = this.getArgumentElement(name);
        if (element != null) {
            result = element.getAttribute(VALUE_ATTRIBUTE);
        }
        return result;
    }

    protected Object getObjectValue(String name) {
        Object result = null;
        IConfigurationElement element = this.getArgumentElement(name);
        if (element != null) {
            try {
                result = element.createExecutableExtension(VALUE_ATTRIBUTE);
            }
            catch (CoreException coreException) {}
        }
        return result;
    }

    protected Bundle getBundle() {
        IContributor contributor = this.config.getContributor();
        String bundleName = contributor.getName();
        Bundle bundle = Platform.getBundle((String)bundleName);
        return bundle;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setConfiguration(IConfigurationElement config) {
        this.config = config;
    }
}

