/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.model;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.eclipse.tm.terminal.model.ITerminalTextData;
import org.eclipse.tm.terminal.model.ITerminalTextDataSnapshot;
import org.eclipse.tm.terminal.model.LineSegment;
import org.eclipse.tm.terminal.model.Style;

public class TerminalTextDataStore
implements ITerminalTextData {
    private char[][] fChars = new char[0][];
    private Style[][] fStyle = new Style[0][];
    private int fWidth = 0;
    private int fHeight;
    private int fMaxHeight;
    private int fCursorColumn;
    private int fCursorLine;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.tm.internal.terminal.model.TerminalTextDataStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private boolean throwRuntimeException() {
        throw new RuntimeException();
    }

    public int getWidth() {
        return this.fWidth;
    }

    public int getHeight() {
        return this.fHeight;
    }

    public void setDimensions(int height, int width) {
        if (!$assertionsDisabled && height < 0 && !this.throwRuntimeException()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && width < 0 && !this.throwRuntimeException()) {
            throw new AssertionError();
        }
        if (height > this.fChars.length) {
            int h = 4 * height / 3;
            if (this.fMaxHeight > 0 && h > this.fMaxHeight) {
                h = this.fMaxHeight;
            }
            this.fStyle = (Style[][])this.resizeArray(this.fStyle, height);
            this.fChars = (char[][])this.resizeArray(this.fChars, height);
        }
        if (height > this.fHeight) {
            int i = this.fHeight;
            while (i < height) {
                this.fStyle[i] = null;
                this.fChars[i] = null;
                ++i;
            }
        }
        this.fWidth = width;
        this.fHeight = height;
    }

    private Object resizeArray(Object origArray, int newSize) {
        int oldSize = Array.getLength(origArray);
        if (oldSize == newSize) {
            return origArray;
        }
        Class<?> elementType = origArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(origArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    public LineSegment[] getLineSegments(int line, int column, int len) {
        Style[] styles = this.fStyle[line];
        char[] chars = this.fChars[line];
        int col = column;
        int n = column + len;
        if (styles == null) {
            styles = new Style[n];
        } else if (styles.length < n) {
            styles = (Style[])this.resizeArray(styles, n);
        }
        if (chars == null) {
            chars = new char[n];
        } else if (chars.length < n) {
            chars = (char[])this.resizeArray(chars, n);
        }
        Style style = styles[column];
        ArrayList<LineSegment> segments = new ArrayList<LineSegment>();
        int i = column;
        while (i < n) {
            if (styles[i] != style) {
                segments.add(new LineSegment(col, new String(chars, col, i - col), style));
                style = styles[i];
                col = i;
            }
            ++i;
        }
        if (col < n) {
            segments.add(new LineSegment(col, new String(chars, col, n - col), style));
        }
        return segments.toArray(new LineSegment[segments.size()]);
    }

    public char getChar(int line, int column) {
        if (!$assertionsDisabled && column >= this.fWidth && !this.throwRuntimeException()) {
            throw new AssertionError();
        }
        if (this.fChars[line] == null || column >= this.fChars[line].length) {
            return '\u0000';
        }
        return this.fChars[line][column];
    }

    public Style getStyle(int line, int column) {
        if (!$assertionsDisabled && column >= this.fWidth && !this.throwRuntimeException()) {
            throw new AssertionError();
        }
        if (this.fStyle[line] == null || column >= this.fStyle[line].length) {
            return null;
        }
        return this.fStyle[line][column];
    }

    void ensureLineLength(int iLine, int length) {
        if (length > this.fWidth) {
            throw new RuntimeException();
        }
        if (this.fChars[iLine] == null) {
            this.fChars[iLine] = new char[length];
        } else if (this.fChars[iLine].length < length) {
            this.fChars[iLine] = (char[])this.resizeArray(this.fChars[iLine], length);
        }
        if (this.fStyle[iLine] == null) {
            this.fStyle[iLine] = new Style[length];
        } else if (this.fStyle[iLine].length < length) {
            this.fStyle[iLine] = (Style[])this.resizeArray(this.fStyle[iLine], length);
        }
    }

    public void setChar(int line, int column, char c, Style style) {
        this.ensureLineLength(line, column + 1);
        this.fChars[line][column] = c;
        this.fStyle[line][column] = style;
    }

    public void setChars(int line, int column, char[] chars, Style style) {
        this.setChars(line, column, chars, 0, chars.length, style);
    }

    public void setChars(int line, int column, char[] chars, int start, int len, Style style) {
        this.ensureLineLength(line, column + len);
        int i = 0;
        while (i < len) {
            this.fChars[line][column + i] = chars[i + start];
            this.fStyle[line][column + i] = style;
            ++i;
        }
    }

    public void scroll(int startLine, int size, int shift) {
        if (!$assertionsDisabled && startLine + size > this.getHeight() && !this.throwRuntimeException()) {
            throw new AssertionError();
        }
        if (shift < 0) {
            int i = startLine;
            while (i < startLine + size + shift) {
                this.fChars[i] = this.fChars[i - shift];
                this.fStyle[i] = this.fStyle[i - shift];
                ++i;
            }
            this.cleanLines(Math.max(startLine, startLine + size + shift), Math.min(-shift, this.getHeight() - startLine));
        } else {
            int i = startLine + size - 1;
            while (i >= startLine && i - shift >= 0) {
                this.fChars[i] = this.fChars[i - shift];
                this.fStyle[i] = this.fStyle[i - shift];
                --i;
            }
            this.cleanLines(startLine, Math.min(shift, this.getHeight() - startLine));
        }
    }

    private void cleanLines(int line, int len) {
        int i = line;
        while (i < line + len) {
            this.fChars[i] = null;
            this.fStyle[i] = null;
            ++i;
        }
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        int line = 0;
        while (line < this.getHeight()) {
            if (line > 0) {
                buff.append("\n");
            }
            int column = 0;
            while (column < this.fWidth) {
                buff.append(this.getChar(line, column));
                ++column;
            }
            ++line;
        }
        return buff.toString();
    }

    public ITerminalTextDataSnapshot makeSnapshot() {
        throw new UnsupportedOperationException();
    }

    public void addLine() {
        if (this.fMaxHeight > 0 && this.getHeight() < this.fMaxHeight) {
            this.setDimensions(this.getHeight() + 1, this.getWidth());
        } else {
            this.scroll(0, this.getHeight(), -1);
        }
    }

    public void copy(ITerminalTextData source) {
        this.fWidth = source.getWidth();
        int n = source.getHeight();
        if (this.getHeight() != n) {
            this.fChars = new char[n][];
            this.fStyle = new Style[n][];
        }
        int i = 0;
        while (i < n) {
            this.fChars[i] = source.getChars(i);
            this.fStyle[i] = source.getStyles(i);
            ++i;
        }
        this.fHeight = n;
        this.fCursorLine = source.getCursorLine();
        this.fCursorColumn = source.getCursorColumn();
    }

    public void copyRange(ITerminalTextData source, int sourceStartLine, int destStartLine, int length) {
        int i = 0;
        while (i < length) {
            this.fChars[i + destStartLine] = source.getChars(i + sourceStartLine);
            this.fStyle[i + destStartLine] = source.getStyles(i + sourceStartLine);
            ++i;
        }
    }

    public void copyLine(ITerminalTextData source, int sourceLine, int destLine) {
        this.fChars[destLine] = source.getChars(sourceLine);
        this.fStyle[destLine] = source.getStyles(sourceLine);
    }

    public char[] getChars(int line) {
        if (this.fChars[line] == null) {
            return null;
        }
        return (char[])this.fChars[line].clone();
    }

    public Style[] getStyles(int line) {
        if (this.fStyle[line] == null) {
            return null;
        }
        return (Style[])this.fStyle[line].clone();
    }

    public void setLine(int line, char[] chars, Style[] styles) {
        this.fChars[line] = (char[])chars.clone();
        this.fStyle[line] = (Style[])styles.clone();
    }

    public void setMaxHeight(int height) {
        this.fMaxHeight = height;
    }

    public int getMaxHeight() {
        return this.fMaxHeight;
    }

    public void cleanLine(int line) {
        this.fChars[line] = null;
        this.fStyle[line] = null;
    }

    public int getCursorColumn() {
        return this.fCursorColumn;
    }

    public int getCursorLine() {
        return this.fCursorLine;
    }

    public void setCursorColumn(int column) {
        this.fCursorColumn = column;
    }

    public void setCursorLine(int line) {
        this.fCursorLine = line;
    }
}

