/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.view;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.tm.internal.terminal.view.TerminalViewPlugin;
import org.eclipse.tm.internal.terminal.view.ViewMessages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TerminalPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREF_LIMITOUTPUT = "TerminalPrefLimitOutput";
    public static final String PREF_BUFFERLINES = "TerminalPrefBufferLines";
    public static final String PREF_TIMEOUT_SERIAL = "TerminalPrefTimeoutSerial";
    public static final String PREF_TIMEOUT_NETWORK = "TerminalPrefTimeoutNetwork";
    public static final String PREF_INVERT_COLORS = "TerminalPrefInvertColors";
    public static final boolean DEFAULT_LIMITOUTPUT = true;
    public static final int DEFAULT_BUFFERLINES = 1000;
    public static final int DEFAULT_TIMEOUT_SERIAL = 5;
    public static final int DEFAULT_TIMEOUT_NETWORK = 5;
    public static final boolean DEFAULT_INVERT_COLORS = false;
    protected BooleanFieldEditor fInvertColors;
    protected IntegerFieldEditor fEditorBufferSize;
    protected IntegerFieldEditor fEditorSerialTimeout;
    protected IntegerFieldEditor fEditorNetworkTimeout;

    public TerminalPreferencePage() {
        super(1);
    }

    protected void createFieldEditors() {
        this.setupPage();
    }

    public void init(IWorkbench workbench) {
    }

    protected void setupPage() {
        this.setupData();
        this.setupEditors();
    }

    protected void setupData() {
        TerminalViewPlugin plugin = TerminalViewPlugin.getDefault();
        IPreferenceStore preferenceStore = plugin.getPreferenceStore();
        this.setPreferenceStore(preferenceStore);
    }

    protected void setupEditors() {
        this.fInvertColors = new BooleanFieldEditor(PREF_INVERT_COLORS, ViewMessages.INVERT_COLORS, this.getFieldEditorParent());
        this.fEditorBufferSize = new IntegerFieldEditor(PREF_BUFFERLINES, ViewMessages.BUFFERLINES, this.getFieldEditorParent());
        this.fEditorSerialTimeout = new IntegerFieldEditor(PREF_TIMEOUT_SERIAL, ViewMessages.SERIALTIMEOUT, this.getFieldEditorParent());
        this.fEditorNetworkTimeout = new IntegerFieldEditor(PREF_TIMEOUT_NETWORK, ViewMessages.NETWORKTIMEOUT, this.getFieldEditorParent());
        this.fEditorBufferSize.setValidRange(0, Integer.MAX_VALUE);
        this.fEditorSerialTimeout.setValidRange(0, Integer.MAX_VALUE);
        this.fEditorNetworkTimeout.setValidRange(0, Integer.MAX_VALUE);
        this.addField((FieldEditor)this.fInvertColors);
        this.addField((FieldEditor)this.fEditorBufferSize);
        this.addField((FieldEditor)this.fEditorSerialTimeout);
        this.addField((FieldEditor)this.fEditorNetworkTimeout);
    }
}

