/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.discovery.engine;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.tm.discovery.model.ModelPackage;
import org.eclipse.tm.discovery.protocol.IProtocol;
import org.eclipse.tm.discovery.transport.ITransport;
import org.eclipse.tm.internal.discovery.engine.Messages;
import org.eclipse.tm.internal.discovery.model.util.ModelResourceFactoryImpl;

public class ServiceDiscoveryEngine {
    private static ServiceDiscoveryEngine SERVICE_DISCOVERY_ENGINE = null;
    private final URI SERVICE_DISCOVERY_URI = URI.createFileURI((String)Messages.getString("ServiceDiscoveryEngine.DiscoveryModelFileURI"));
    private Resource resource;

    public static ServiceDiscoveryEngine getInstance() {
        if (SERVICE_DISCOVERY_ENGINE == null) {
            SERVICE_DISCOVERY_ENGINE = new ServiceDiscoveryEngine();
        }
        return SERVICE_DISCOVERY_ENGINE;
    }

    private ServiceDiscoveryEngine() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new ModelResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/tm/discovery/model", (Object)ModelPackage.eINSTANCE);
        try {
            this.resource = resourceSet.getResource(this.SERVICE_DISCOVERY_URI, true);
        }
        catch (WrappedException wrappedException) {
            this.resource = resourceSet.createResource(this.SERVICE_DISCOVERY_URI);
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    public void doServiceDiscovery(String query, IProtocol protocol, ITransport transport) {
        protocol.getDiscoveryJob(query, this.resource, transport).schedule();
    }
}

