/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse;

import java.util.Arrays;

public enum TraceCategory {
    DEFAULT("_"),
    COMPILER("Compiler"),
    CLASSPATH("Classpath"),
    DSL("DSL"),
    CODE_SELECT("Code select"),
    REFACTORING("Refactoring"),
    AST_TRANSFORM("AST Transforms"),
    CONTENT_ASSIST("Content assist"),
    ORGANIZE_IMPORTS("Clean imports");

    public final String label;
    private String paddedLabel;
    private static String[] stringValues;
    private static int longestLabel;

    static {
        longestLabel = -1;
    }

    private TraceCategory(String label) {
        this.label = label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getPaddedLabel() {
        if (this.paddedLabel != null) return this.paddedLabel;
        Class<TraceCategory> clazz = TraceCategory.class;
        synchronized (TraceCategory.class) {
            if (longestLabel == -1) {
                TraceCategory.calculateLongest();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            int extraSpace = longestLabel - this.label.length();
            this.paddedLabel = String.valueOf(this.spaces(extraSpace)) + this.label;
            return this.paddedLabel;
        }
    }

    private String spaces(int extraSpace) {
        char[] a = new char[extraSpace];
        Arrays.fill(a, ' ');
        return new String(a);
    }

    private static void calculateLongest() {
        int maybeLongest = longestLabel;
        TraceCategory[] traceCategoryArray = TraceCategory.values();
        int n = traceCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            TraceCategory category = traceCategoryArray[n2];
            maybeLongest = Math.max(category.label.length(), maybeLongest);
            ++n2;
        }
        longestLabel = maybeLongest;
    }

    public static String[] stringValues() {
        if (stringValues == null) {
            TraceCategory[] values = TraceCategory.values();
            stringValues = new String[values.length];
            int i = 0;
            int n = values.length;
            while (i < n) {
                TraceCategory.stringValues[i] = values[i].label;
                ++i;
            }
        }
        return stringValues;
    }
}

