/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.core.internal.services;

import ch.epfl.scala.bsp4j.BuildServerCapabilities;
import ch.epfl.scala.bsp4j.CompileProvider;
import ch.epfl.scala.bsp4j.InitializeBuildParams;
import ch.epfl.scala.bsp4j.InitializeBuildResult;
import com.microsoft.java.bs.core.Launcher;
import com.microsoft.java.bs.core.internal.gradle.GradleApiConnector;
import com.microsoft.java.bs.core.internal.gradle.GradleBuildKind;
import com.microsoft.java.bs.core.internal.gradle.Utils;
import com.microsoft.java.bs.core.internal.managers.PreferenceManager;
import com.microsoft.java.bs.core.internal.model.Preferences;
import com.microsoft.java.bs.core.internal.utils.JsonUtils;
import com.microsoft.java.bs.core.internal.utils.TelemetryUtils;
import com.microsoft.java.bs.core.internal.utils.UriUtils;
import com.microsoft.java.bs.gradle.model.SupportedLanguages;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;

public class LifecycleService {
    private Status status = Status.UNINITIALIZED;
    private GradleApiConnector connector;
    private PreferenceManager preferenceManager;

    public LifecycleService(GradleApiConnector connector, PreferenceManager preferenceManager) {
        this.connector = connector;
        this.preferenceManager = preferenceManager;
    }

    public InitializeBuildResult initializeServer(InitializeBuildParams params) {
        this.initializePreferenceManager(params);
        BuildServerCapabilities capabilities = this.initializeServerCapabilities();
        return new InitializeBuildResult("gradle-build-server", "0.3.0", "2.1.0-M4", capabilities);
    }

    void initializePreferenceManager(InitializeBuildParams params) {
        URI rootUri = UriUtils.getUriFromString(params.getRootUri());
        this.preferenceManager.setRootUri(rootUri);
        this.preferenceManager.setClientSupportedLanguages(params.getCapabilities().getLanguageIds());
        Preferences preferences = JsonUtils.toModel(params.getData(), Preferences.class);
        if (preferences == null) {
            preferences = new Preferences();
        }
        this.preferenceManager.setPreferences(preferences);
        this.updateGradleJavaHomeIfNecessary(rootUri);
    }

    private BuildServerCapabilities initializeServerCapabilities() {
        BuildServerCapabilities capabilities = new BuildServerCapabilities();
        capabilities.setResourcesProvider(Boolean.valueOf(true));
        capabilities.setOutputPathsProvider(Boolean.valueOf(true));
        capabilities.setDependencyModulesProvider(Boolean.valueOf(true));
        capabilities.setDependencySourcesProvider(Boolean.valueOf(true));
        capabilities.setCanReload(Boolean.valueOf(true));
        capabilities.setBuildTargetChangedProvider(Boolean.valueOf(true));
        capabilities.setCompileProvider(new CompileProvider(SupportedLanguages.allBspNames));
        return capabilities;
    }

    public void onBuildInitialized() {
        this.status = Status.INITIALIZED;
    }

    public Object shutdown() {
        this.connector.shutdown();
        this.status = Status.SHUTDOWN;
        return null;
    }

    public void exit() {
        if (this.status == Status.SHUTDOWN) {
            System.exit(0);
        }
        System.exit(1);
    }

    private void updateGradleJavaHomeIfNecessary(URI rootUri) {
        Preferences preferences = this.preferenceManager.getPreferences();
        if (preferences.getJdks() == null || preferences.getJdks().isEmpty()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)preferences.getGradleJavaHome())) {
            String gradleVersion = "";
            GradleBuildKind buildKind = Utils.getEffectiveBuildKind(new File(rootUri), preferences);
            Map<String, String> map = TelemetryUtils.getMetadataMap("buildKind", buildKind.name());
            Launcher.LOGGER.log(Level.INFO, "Use build kind: " + buildKind.name(), map);
            gradleVersion = buildKind == GradleBuildKind.SPECIFIED_VERSION ? preferences.getGradleVersion() : this.connector.getGradleVersion(rootUri);
            if (StringUtils.isNotBlank((CharSequence)gradleVersion)) {
                map = TelemetryUtils.getMetadataMap("gradleVersion", gradleVersion);
                Launcher.LOGGER.log(Level.INFO, "Gradle version: " + gradleVersion, map);
                String highestJavaVersion = Utils.getHighestCompatibleJavaVersion(gradleVersion);
                File jdkInstallation = LifecycleService.getJdkToLaunchDaemon(preferences.getJdks(), highestJavaVersion);
                if (jdkInstallation != null) {
                    preferences.setGradleJavaHome(jdkInstallation.getAbsolutePath());
                }
            }
        }
    }

    static File getJdkToLaunchDaemon(Map<String, String> jdks, String highestJavaVersion) {
        if (StringUtils.isBlank((CharSequence)highestJavaVersion)) {
            return null;
        }
        Map.Entry<String, String> selected = null;
        for (Map.Entry<String, String> jdk : jdks.entrySet()) {
            String javaVersion = jdk.getKey();
            if (Runtime.Version.parse(javaVersion).compareTo(Runtime.Version.parse(highestJavaVersion)) > 0 || selected != null && Runtime.Version.parse((String)selected.getKey()).compareTo(Runtime.Version.parse(javaVersion)) >= 0) continue;
            selected = jdk;
        }
        if (selected == null) {
            return null;
        }
        try {
            return new File(new URI((String)selected.getValue()));
        }
        catch (URISyntaxException e) {
            Launcher.LOGGER.severe("Invalid JDK URI: " + (String)selected.getValue());
            return null;
        }
    }

    static enum Status {
        UNINITIALIZED,
        INITIALIZED,
        SHUTDOWN;

    }
}

