/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposalCore;

public class OptionalCorrectionProposalCore
extends ASTRewriteCorrectionProposalCore {
    public static final String ADD_OPTIONAL_ID = "org.eclipse.jdt.ui.correction.addOptional";
    public static final int OPTIONAL_EMPTY = 0;
    public static final int OPTIONAL_OF = 1;
    public static final int OPTIONAL_OF_NULLABLE = 2;
    private final Expression fNodeToWrap;
    private int fCorrectionType;

    public OptionalCorrectionProposalCore(String label, ICompilationUnit targetCU, Expression nodeToWrap, int relevance, int correctionType) {
        super(label, targetCU, (ASTRewrite)null, relevance);
        this.fNodeToWrap = nodeToWrap;
        this.fCorrectionType = correctionType;
        this.setCommandId(ADD_OPTIONAL_ID);
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        AST ast = this.fNodeToWrap.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        MethodInvocation newMethodInvocation = ast.newMethodInvocation();
        newMethodInvocation.setExpression((Expression)ASTNodeFactory.newName(ast, "Optional"));
        switch (this.fCorrectionType) {
            case 0: {
                newMethodInvocation.setName(ast.newSimpleName("empty"));
                break;
            }
            case 1: {
                newMethodInvocation.setName(ast.newSimpleName("of"));
                newMethodInvocation.arguments().add(rewrite.createCopyTarget((ASTNode)this.fNodeToWrap));
                break;
            }
            case 2: {
                newMethodInvocation.setName(ast.newSimpleName("ofNullable"));
                newMethodInvocation.arguments().add(rewrite.createCopyTarget((ASTNode)this.fNodeToWrap));
                break;
            }
        }
        rewrite.replace((ASTNode)this.fNodeToWrap, (ASTNode)newMethodInvocation, null);
        return rewrite;
    }
}

