/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdtls.ext.core.parser;

import com.microsoft.jdtls.ext.core.JdtlsExtActivator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ls.core.internal.JDTUtils;

public class ContextResolver {
    private static final Pattern MARKDOWN_CODE_PATTERN = Pattern.compile("(?s)```(?:java)?\\n?(.*?)```");
    private static final Pattern HTML_PRE_PATTERN = Pattern.compile("(?is)<pre[^>]*>(.*?)</pre>");
    private static final Pattern HTML_CODE_PATTERN = Pattern.compile("(?is)<code[^>]*>(.*?)</code>");
    private static final int MAX_METHODS_TO_DISPLAY = 10;
    private static final int MAX_FIELDS_TO_DISPLAY = 10;
    private static final int MAX_STATIC_METHODS_TO_DISPLAY = 10;
    private static final int MAX_STATIC_FIELDS_TO_DISPLAY = 10;
    private static final Set<String> SKIP_COMMON_JDK_PACKAGES = new HashSet<String>();

    static {
        SKIP_COMMON_JDK_PACKAGES.add("java.lang");
        SKIP_COMMON_JDK_PACKAGES.add("java.util");
        SKIP_COMMON_JDK_PACKAGES.add("java.io");
        SKIP_COMMON_JDK_PACKAGES.add("java.nio");
        SKIP_COMMON_JDK_PACKAGES.add("java.nio.file");
        SKIP_COMMON_JDK_PACKAGES.add("java.time");
        SKIP_COMMON_JDK_PACKAGES.add("java.util.concurrent");
        SKIP_COMMON_JDK_PACKAGES.add("java.util.stream");
        SKIP_COMMON_JDK_PACKAGES.add("java.util.function");
        SKIP_COMMON_JDK_PACKAGES.add("java.net");
        SKIP_COMMON_JDK_PACKAGES.add("java.util.regex");
        SKIP_COMMON_JDK_PACKAGES.add("java.math");
        SKIP_COMMON_JDK_PACKAGES.add("java.text");
        SKIP_COMMON_JDK_PACKAGES.add("java.sql");
        SKIP_COMMON_JDK_PACKAGES.add("javax.sql");
        SKIP_COMMON_JDK_PACKAGES.add("javax.servlet");
        SKIP_COMMON_JDK_PACKAGES.add("javax.annotation");
        SKIP_COMMON_JDK_PACKAGES.add("javax.persistence");
        SKIP_COMMON_JDK_PACKAGES.add("javax.inject");
        SKIP_COMMON_JDK_PACKAGES.add("javax.validation");
        SKIP_COMMON_JDK_PACKAGES.add("jakarta.servlet");
        SKIP_COMMON_JDK_PACKAGES.add("jakarta.persistence");
        SKIP_COMMON_JDK_PACKAGES.add("org.springframework.stereotype");
        SKIP_COMMON_JDK_PACKAGES.add("org.springframework.beans");
        SKIP_COMMON_JDK_PACKAGES.add("org.springframework.context");
        SKIP_COMMON_JDK_PACKAGES.add("org.springframework.web.bind");
        SKIP_COMMON_JDK_PACKAGES.add("org.springframework.boot");
        SKIP_COMMON_JDK_PACKAGES.add("org.springframework.data.jpa");
        SKIP_COMMON_JDK_PACKAGES.add("org.springframework.data.repository");
        SKIP_COMMON_JDK_PACKAGES.add("org.springframework.transaction");
        SKIP_COMMON_JDK_PACKAGES.add("org.springframework.security");
        SKIP_COMMON_JDK_PACKAGES.add("org.junit");
        SKIP_COMMON_JDK_PACKAGES.add("org.junit.jupiter");
        SKIP_COMMON_JDK_PACKAGES.add("org.testng");
        SKIP_COMMON_JDK_PACKAGES.add("org.mockito");
        SKIP_COMMON_JDK_PACKAGES.add("org.assertj");
        SKIP_COMMON_JDK_PACKAGES.add("org.hamcrest");
        SKIP_COMMON_JDK_PACKAGES.add("lombok");
        SKIP_COMMON_JDK_PACKAGES.add("org.slf4j");
        SKIP_COMMON_JDK_PACKAGES.add("org.apache.logging.log4j");
        SKIP_COMMON_JDK_PACKAGES.add("org.apache.log4j");
        SKIP_COMMON_JDK_PACKAGES.add("java.util.logging");
        SKIP_COMMON_JDK_PACKAGES.add("com.fasterxml.jackson.annotation");
        SKIP_COMMON_JDK_PACKAGES.add("com.fasterxml.jackson.core");
        SKIP_COMMON_JDK_PACKAGES.add("com.fasterxml.jackson.databind");
        SKIP_COMMON_JDK_PACKAGES.add("com.google.common.collect");
        SKIP_COMMON_JDK_PACKAGES.add("com.google.common.base");
        SKIP_COMMON_JDK_PACKAGES.add("org.apache.commons.lang3");
        SKIP_COMMON_JDK_PACKAGES.add("org.apache.commons.collections4");
        SKIP_COMMON_JDK_PACKAGES.add("org.apache.commons.io");
    }

    public static void resolveSingleType(IJavaProject javaProject, String typeName, List<ImportClassInfo> classInfoList, Set<String> processedTypes, IProgressMonitor monitor) {
        try {
            IPackageFragmentRoot[] packageRoots;
            if (processedTypes.contains(typeName)) {
                return;
            }
            int lastDotIndex = typeName.lastIndexOf(46);
            if (lastDotIndex == -1) {
                processedTypes.add(typeName);
                return;
            }
            String packageName = typeName.substring(0, lastDotIndex);
            String simpleName = typeName.substring(lastDotIndex + 1);
            try {
                IType type = javaProject.findType(typeName);
                if (type != null && type.exists()) {
                    if (!type.isBinary()) {
                        processedTypes.add(typeName);
                        ContextResolver.extractTypeInfo(type, classInfoList, monitor);
                        return;
                    }
                    return;
                }
            }
            catch (JavaModelException e) {
                JdtlsExtActivator.logException("Error in primary type search: " + typeName, e);
            }
            IPackageFragmentRoot[] iPackageFragmentRootArray = packageRoots = javaProject.getPackageFragmentRoots();
            int n = packageRoots.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationUnit cu;
                IPackageFragment packageFragment;
                IPackageFragmentRoot packageRoot = iPackageFragmentRootArray[n2];
                if (packageRoot.getKind() == 1 && (packageFragment = packageRoot.getPackageFragment(packageName)) != null && packageFragment.exists() && (cu = packageFragment.getCompilationUnit(simpleName + ".java")) != null && cu.exists()) {
                    IType[] allTypes;
                    IType primaryType;
                    String cuUri = JDTUtils.toUri((ITypeRoot)cu);
                    if (cuUri != null && (primaryType = cu.findPrimaryType()) != null && primaryType.exists() && typeName.equals(primaryType.getFullyQualifiedName())) {
                        processedTypes.add(typeName);
                        ContextResolver.extractTypeInfo(primaryType, classInfoList, monitor);
                        return;
                    }
                    IType[] iTypeArray = allTypes = cu.getAllTypes();
                    int n3 = allTypes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IType type = iTypeArray[n4];
                        if (typeName.equals(type.getFullyQualifiedName())) {
                            processedTypes.add(typeName);
                            ContextResolver.extractTypeInfo(type, classInfoList, monitor);
                            return;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            processedTypes.add(typeName);
        }
        catch (JavaModelException e) {
            JdtlsExtActivator.logException("Error resolving type: " + typeName, e);
            processedTypes.add(typeName);
        }
    }

    private static boolean isCommonJdkType(String typeName) {
        if (typeName == null || typeName.isEmpty()) {
            return false;
        }
        int lastDotIndex = typeName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return false;
        }
        String packageName = typeName.substring(0, lastDotIndex);
        return SKIP_COMMON_JDK_PACKAGES.contains(packageName) || SKIP_COMMON_JDK_PACKAGES.stream().anyMatch(pkg -> packageName.startsWith(pkg + "."));
    }

    public static void resolveStaticImport(IJavaProject javaProject, String staticImportName, List<ImportClassInfo> classInfoList, Set<String> processedTypes, IProgressMonitor monitor) {
        try {
            if (staticImportName.endsWith(".*")) {
                String className = staticImportName.substring(0, staticImportName.length() - 2);
                ContextResolver.resolveStaticMembersFromClass(javaProject, className, classInfoList, processedTypes, monitor);
            } else {
                int lastDotIndex = staticImportName.lastIndexOf(46);
                if (lastDotIndex > 0) {
                    String className = staticImportName.substring(0, lastDotIndex);
                    String memberName = staticImportName.substring(lastDotIndex + 1);
                    ContextResolver.resolveStaticMemberFromClass(javaProject, className, memberName, classInfoList, processedTypes, monitor);
                }
            }
        }
        catch (Exception e) {
            JdtlsExtActivator.logException("Error resolving static import: " + staticImportName, e);
        }
    }

    public static void resolveStaticMembersFromClass(IJavaProject javaProject, String className, List<ImportClassInfo> classInfoList, Set<String> processedTypes, IProgressMonitor monitor) {
        try {
            ContextResolver.resolveSingleType(javaProject, className, classInfoList, processedTypes, monitor);
            IType type = javaProject.findType(className);
            if (type != null && type.exists() && !type.isBinary()) {
                String uri;
                StringBuilder description = new StringBuilder();
                description.append("Static Import: ").append(className).append(".*\n");
                description.append("All static members from ").append(className).append("\n\n");
                IMethod[] methods = type.getMethods();
                ArrayList<String> staticMethodSigs = new ArrayList<String>();
                IMethod[] iMethodArray = methods;
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method = iMethodArray[n2];
                    int flags = method.getFlags();
                    if (Flags.isStatic((int)flags) && Flags.isPublic((int)flags) && staticMethodSigs.size() < 10) {
                        staticMethodSigs.add(ContextResolver.generateMethodSignature(method));
                    }
                    ++n2;
                }
                IField[] fields = type.getFields();
                ArrayList<String> staticFieldSigs = new ArrayList<String>();
                IField[] iFieldArray = fields;
                int n3 = fields.length;
                int n4 = 0;
                while (n4 < n3) {
                    IField field = iFieldArray[n4];
                    int flags = field.getFlags();
                    if (Flags.isStatic((int)flags) && Flags.isPublic((int)flags) && staticFieldSigs.size() < 10) {
                        staticFieldSigs.add(ContextResolver.generateFieldSignature(field));
                    }
                    ++n4;
                }
                if (!staticMethodSigs.isEmpty()) {
                    description.append("Static Methods:\n");
                    for (String sig : staticMethodSigs) {
                        description.append("  - ").append(sig).append("\n");
                    }
                    description.append("\n");
                }
                if (!staticFieldSigs.isEmpty()) {
                    description.append("Static Fields:\n");
                    for (String sig : staticFieldSigs) {
                        description.append("  - ").append(sig).append("\n");
                    }
                }
                if ((uri = ContextResolver.getTypeUri(type)) != null) {
                    classInfoList.add(new ImportClassInfo(uri, description.toString()));
                }
            }
        }
        catch (JavaModelException e) {
            JdtlsExtActivator.logException("Error resolving static members from: " + className, e);
        }
    }

    public static void resolveStaticMemberFromClass(IJavaProject javaProject, String className, String memberName, List<ImportClassInfo> classInfoList, Set<String> processedTypes, IProgressMonitor monitor) {
        try {
            ContextResolver.resolveSingleType(javaProject, className, classInfoList, processedTypes, monitor);
            IType type = javaProject.findType(className);
            if (type != null && type.exists() && !type.isBinary()) {
                String uri;
                IMethod[] methods;
                StringBuilder description = new StringBuilder();
                description.append("Static Import: ").append(className).append(".").append(memberName).append("\n\n");
                boolean found = false;
                IMethod[] iMethodArray = methods = type.getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    int flags;
                    IMethod method = iMethodArray[n2];
                    if (method.getElementName().equals(memberName) && Flags.isStatic((int)(flags = method.getFlags()))) {
                        description.append("Static Method:\n");
                        description.append("  - ").append(ContextResolver.generateMethodSignature(method)).append("\n");
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (!found) {
                    IField[] fields;
                    IField[] iFieldArray = fields = type.getFields();
                    int n3 = fields.length;
                    n = 0;
                    while (n < n3) {
                        int flags;
                        IField field = iFieldArray[n];
                        if (field.getElementName().equals(memberName) && Flags.isStatic((int)(flags = field.getFlags()))) {
                            description.append("Static Field:\n");
                            description.append("  - ").append(ContextResolver.generateFieldSignature(field)).append("\n");
                            found = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (found && (uri = ContextResolver.getTypeUri(type)) != null) {
                    classInfoList.add(new ImportClassInfo(uri, description.toString()));
                }
            }
        }
        catch (JavaModelException e) {
            JdtlsExtActivator.logException("Error resolving static member: " + className + "." + memberName, e);
        }
    }

    public static void resolveBinaryType(IJavaProject javaProject, String typeName, List<ImportClassInfo> classInfoList, Set<String> processedTypes, int maxMethods, IProgressMonitor monitor) {
        try {
            if (processedTypes.contains(typeName)) {
                return;
            }
            if (ContextResolver.isCommonJdkType(typeName)) {
                processedTypes.add(typeName);
                return;
            }
            IType type = javaProject.findType(typeName);
            if (type == null || !type.exists()) {
                return;
            }
            if (!type.isBinary()) {
                return;
            }
            processedTypes.add(typeName);
            ContextResolver.extractBinaryTypeInfo(type, classInfoList, maxMethods, monitor);
        }
        catch (JavaModelException e) {
            JdtlsExtActivator.logException("Error resolving binary type: " + typeName, e);
        }
    }

    public static void resolvePackageTypes(IJavaProject javaProject, String packageName, List<ImportClassInfo> classInfoList, Set<String> processedTypes, IProgressMonitor monitor) {
        try {
            IPackageFragmentRoot[] packageRoots;
            IPackageFragmentRoot[] iPackageFragmentRootArray = packageRoots = javaProject.getPackageFragmentRoots();
            int n = packageRoots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment packageFragment;
                IPackageFragmentRoot packageRoot = iPackageFragmentRootArray[n2];
                if (packageRoot.getKind() == 1 && (packageFragment = packageRoot.getPackageFragment(packageName)) != null && packageFragment.exists()) {
                    ICompilationUnit[] compilationUnits;
                    ICompilationUnit[] iCompilationUnitArray = compilationUnits = packageFragment.getCompilationUnits();
                    int n3 = compilationUnits.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IType[] types;
                        ICompilationUnit cu = iCompilationUnitArray[n4];
                        IType[] iTypeArray = types = cu.getAllTypes();
                        int n5 = types.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IType type = iTypeArray[n6];
                            String fullTypeName = type.getFullyQualifiedName();
                            if (!processedTypes.contains(fullTypeName)) {
                                processedTypes.add(fullTypeName);
                                ContextResolver.extractTypeInfo(type, classInfoList, monitor);
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JdtlsExtActivator.logException("Error resolving package: " + packageName, e);
        }
    }

    public static void extractTypeInfo(IType type, List<ImportClassInfo> classInfoList, IProgressMonitor monitor) {
        try {
            IType[] nestedTypes;
            String uri = ContextResolver.getTypeUri(type);
            if (uri == null) {
                return;
            }
            String relevantJavadoc = ContextResolver.extractRelevantJavaDocContent(type, monitor);
            String description = ContextResolver.generateClassDescription(type, relevantJavadoc);
            ImportClassInfo info = new ImportClassInfo(uri, description);
            classInfoList.add(info);
            IType[] iTypeArray = nestedTypes = type.getTypes();
            int n = nestedTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IType nestedType = iTypeArray[n2];
                ContextResolver.extractTypeInfo(nestedType, classInfoList, monitor);
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JdtlsExtActivator.logException("Error extracting type info for: " + type.getElementName(), e);
        }
    }

    public static void extractBinaryTypeInfo(IType type, List<ImportClassInfo> classInfoList, int maxMethods, IProgressMonitor monitor) {
        try {
            String uri = "jar://" + type.getFullyQualifiedName().replace('.', '/') + ".class";
            StringBuilder sb = new StringBuilder();
            String javadoc = ContextResolver.extractBriefJavaDoc(type);
            if (javadoc != null && !javadoc.isEmpty()) {
                sb.append("/**\n * ").append(javadoc).append("\n */\n");
            }
            sb.append(ContextResolver.generateClassSignature(type));
            sb.append(" {\n\n");
            IField[] fields = type.getFields();
            int fieldCount = 0;
            IField[] iFieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                if (fieldCount >= 5) break;
                if (Flags.isPublic((int)field.getFlags())) {
                    sb.append("    ").append(ContextResolver.generateBinaryFieldSignature(field)).append("\n");
                    ++fieldCount;
                }
                ++n2;
            }
            if (fieldCount > 0) {
                sb.append("\n");
            }
            IMethod[] methods = type.getMethods();
            int methodCount = 0;
            IMethod[] iMethodArray = methods;
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                IMethod method = iMethodArray[n4];
                if (methodCount >= maxMethods) break;
                if (Flags.isPublic((int)method.getFlags())) {
                    sb.append("    ").append(ContextResolver.generateBinaryMethodSignature(method)).append("\n");
                    ++methodCount;
                }
                ++n4;
            }
            sb.append("}\n");
            sb.append("// Note: External dependency - showing simplified signature only\n");
            ImportClassInfo info = new ImportClassInfo(uri, sb.toString());
            classInfoList.add(info);
        }
        catch (JavaModelException e) {
            JdtlsExtActivator.logException("Error extracting binary type info for: " + type.getElementName(), e);
        }
    }

    private static String generateClassSignature(IType type) throws JavaModelException {
        String[] interfaces;
        String superclass;
        StringBuilder sb = new StringBuilder();
        int flags = type.getFlags();
        if (Flags.isPublic((int)flags)) {
            sb.append("public ");
        }
        if (Flags.isAbstract((int)flags) && !type.isInterface()) {
            sb.append("abstract ");
        }
        if (Flags.isFinal((int)flags)) {
            sb.append("final ");
        }
        if (type.isInterface()) {
            sb.append("interface ");
        } else if (type.isEnum()) {
            sb.append("enum ");
        } else if (type.isAnnotation()) {
            sb.append("@interface ");
        } else {
            sb.append("class ");
        }
        sb.append(type.getElementName());
        ITypeParameter[] typeParams = type.getTypeParameters();
        if (typeParams != null && typeParams.length > 0) {
            sb.append("<");
            int i = 0;
            while (i < typeParams.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(typeParams[i].getElementName());
                ++i;
            }
            sb.append(">");
        }
        if ((superclass = type.getSuperclassName()) != null && !superclass.equals("Object") && !type.isInterface()) {
            sb.append(" extends ").append(ContextResolver.simplifyTypeName(superclass));
        }
        if ((interfaces = type.getSuperInterfaceNames()) != null && interfaces.length > 0) {
            if (type.isInterface()) {
                sb.append(" extends ");
            } else {
                sb.append(" implements ");
            }
            int i = 0;
            while (i < interfaces.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(ContextResolver.simplifyTypeName(interfaces[i]));
                ++i;
            }
        }
        return sb.toString();
    }

    private static String extractBriefJavaDoc(IType type) {
        String javadoc;
        block4: {
            if (type.isBinary()) {
                return null;
            }
            try {
                javadoc = type.getAttachedJavadoc(null);
                if (javadoc != null && !javadoc.isEmpty()) break block4;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return ContextResolver.getFirstSentenceOrLimit(javadoc, 120);
    }

    private static String generateBinaryFieldSignature(IField field) {
        return ContextResolver.generateFieldSignatureInternal(field, true);
    }

    private static String generateBinaryMethodSignature(IMethod method) {
        return ContextResolver.generateMethodSignatureInternal(method, true, false);
    }

    public static String getTypeUri(IType type) {
        try {
            String uri;
            String uri2;
            ICompilationUnit compilationUnit = type.getCompilationUnit();
            if (compilationUnit != null && (uri2 = JDTUtils.toUri((ITypeRoot)compilationUnit)) != null) {
                return uri2;
            }
            IOrdinaryClassFile classFile = type.getClassFile();
            if (classFile != null && (uri = JDTUtils.toUri((IClassFile)classFile)) != null) {
                return uri;
            }
            return type.getFullyQualifiedName();
        }
        catch (Exception e) {
            JdtlsExtActivator.logException("Error getting file URI for type: " + type.getElementName(), e);
            try {
                return type.getFullyQualifiedName();
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static String generateClassDescription(IType type, String javadoc) {
        StringBuilder description = new StringBuilder();
        try {
            String[] interfaces;
            String superclass;
            String qualifiedName = type.getFullyQualifiedName();
            String simpleName = type.getElementName();
            description.append("Class: ").append(qualifiedName).append("\n");
            StringBuilder signature = new StringBuilder();
            int flags = type.getFlags();
            if (Flags.isPublic((int)flags)) {
                signature.append("public ");
            }
            if (Flags.isAbstract((int)flags)) {
                signature.append("abstract ");
            }
            if (Flags.isFinal((int)flags)) {
                signature.append("final ");
            }
            if (type.isInterface()) {
                signature.append("interface ");
            } else if (type.isEnum()) {
                signature.append("enum ");
            } else if (type.isAnnotation()) {
                signature.append("@interface ");
            } else {
                signature.append("class ");
            }
            signature.append(simpleName);
            String[] typeParams = type.getTypeParameterSignatures();
            if (typeParams != null && typeParams.length > 0) {
                signature.append("<");
                int i = 0;
                while (i < typeParams.length) {
                    if (i > 0) {
                        signature.append(", ");
                    }
                    signature.append(ContextResolver.convertTypeSignature(typeParams[i]));
                    ++i;
                }
                signature.append(">");
            }
            if ((superclass = type.getSuperclassName()) != null && !superclass.equals("Object") && !type.isInterface()) {
                signature.append(" extends ").append(superclass);
            }
            if ((interfaces = type.getSuperInterfaceNames()) != null && interfaces.length > 0) {
                if (type.isInterface()) {
                    signature.append(" extends ");
                } else {
                    signature.append(" implements ");
                }
                int i = 0;
                while (i < interfaces.length) {
                    if (i > 0) {
                        signature.append(", ");
                    }
                    signature.append(interfaces[i]);
                    ++i;
                }
            }
            description.append("Signature: ").append((CharSequence)signature).append("\n\n");
            if (ContextResolver.isNotEmpty(javadoc)) {
                description.append("JavaDoc:\n").append(javadoc).append("\n\n");
            }
            IMethod[] methods = type.getMethods();
            ArrayList<String> constructorSigs = new ArrayList<String>();
            IMethod[] iMethodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (method.isConstructor()) {
                    constructorSigs.add(ContextResolver.generateMethodSignature(method));
                }
                ++n2;
            }
            if (!constructorSigs.isEmpty()) {
                description.append("Constructors:\n");
                for (String sig : constructorSigs) {
                    description.append("  - ").append(sig).append("\n");
                }
                description.append("\n");
            }
            ArrayList<String> methodSigs = new ArrayList<String>();
            int methodCount = 0;
            IMethod[] iMethodArray2 = methods;
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                IMethod method = iMethodArray2[n4];
                if (!method.isConstructor() && Flags.isPublic((int)method.getFlags())) {
                    if (methodCount >= 10) break;
                    methodSigs.add(ContextResolver.generateMethodSignature(method));
                    ++methodCount;
                }
                ++n4;
            }
            if (!methodSigs.isEmpty()) {
                description.append("Methods:\n");
                for (String sig : methodSigs) {
                    description.append("  - ").append(sig).append("\n");
                }
                if (methodCount == 10 && methods.length > methodCount) {
                    description.append("  - ... (more methods available)\n");
                }
                description.append("\n");
            }
            IField[] fields = type.getFields();
            ArrayList<String> fieldSigs = new ArrayList<String>();
            int fieldCount = 0;
            IField[] iFieldArray = fields;
            int n5 = fields.length;
            int n6 = 0;
            while (n6 < n5) {
                IField field = iFieldArray[n6];
                if (Flags.isPublic((int)field.getFlags()) && fieldCount < 10) {
                    fieldSigs.add(ContextResolver.generateFieldSignature(field));
                    ++fieldCount;
                }
                ++n6;
            }
            if (!fieldSigs.isEmpty()) {
                description.append("Fields:\n");
                for (String sig : fieldSigs) {
                    description.append("  - ").append(sig).append("\n");
                }
            }
        }
        catch (JavaModelException e) {
            return "Error generating description for type: " + e.getMessage();
        }
        return description.toString();
    }

    private static String extractRelevantJavaDocContent(IType type, IProgressMonitor monitor) {
        String rawJavadoc;
        block11: {
            ISourceRange javadocRange;
            block10: {
                block9: {
                    if (!type.isBinary()) break block9;
                    return "";
                }
                javadocRange = type.getJavadocRange();
                if (javadocRange != null) break block10;
                return "";
            }
            rawJavadoc = type.getCompilationUnit().getSource().substring(javadocRange.getOffset(), javadocRange.getOffset() + javadocRange.getLength());
            if (ContextResolver.isNotEmpty(rawJavadoc)) break block11;
            return "";
        }
        try {
            StringBuilder result = new StringBuilder();
            HashSet<String> seenCodeSnippets = new HashSet<String>();
            String cleanedJavadoc = ContextResolver.cleanJavadocComment(rawJavadoc);
            cleanedJavadoc = ContextResolver.removeHtmlTags(cleanedJavadoc);
            cleanedJavadoc = ContextResolver.convertHtmlEntities(cleanedJavadoc);
            String description = ContextResolver.extractClassDescription(cleanedJavadoc);
            if (ContextResolver.isNotEmpty(description)) {
                result.append("Description:\n").append(description).append("\n\n");
            }
            Matcher markdownMatcher = MARKDOWN_CODE_PATTERN.matcher(rawJavadoc);
            while (markdownMatcher.find()) {
                String code = markdownMatcher.group(1).trim();
                if (!ContextResolver.isNotEmpty(code) || !seenCodeSnippets.add(code)) continue;
                result.append("```java\n").append(code).append("\n```\n\n");
            }
            Matcher preMatcher = HTML_PRE_PATTERN.matcher(cleanedJavadoc);
            while (preMatcher.find()) {
                String code = preMatcher.group(1).replaceAll("(?i)<code[^>]*>", "").replaceAll("(?i)</code>", "").trim();
                if (!ContextResolver.isNotEmpty(code) || !seenCodeSnippets.add(code)) continue;
                result.append("```java\n").append(code).append("\n```\n\n");
            }
            Matcher codeMatcher = HTML_CODE_PATTERN.matcher(cleanedJavadoc);
            while (codeMatcher.find()) {
                String code = codeMatcher.group(1).trim();
                if (!ContextResolver.isNotEmpty(code) || !seenCodeSnippets.add(code)) continue;
                result.append("```java\n").append(code).append("\n```\n\n");
            }
            return result.toString().trim();
        }
        catch (Exception e) {
            JdtlsExtActivator.logException("Error extracting relevant JavaDoc content for: " + type.getElementName(), e);
            return "";
        }
    }

    private static String extractClassDescription(String cleanedJavadoc) {
        if (cleanedJavadoc == null || cleanedJavadoc.isEmpty()) {
            return "";
        }
        String textOnly = cleanedJavadoc;
        textOnly = MARKDOWN_CODE_PATTERN.matcher(textOnly).replaceAll("");
        textOnly = HTML_PRE_PATTERN.matcher(textOnly).replaceAll("");
        Object description = ContextResolver.extractJavadocDescription(textOnly = HTML_CODE_PATTERN.matcher(textOnly).replaceAll(""));
        if (((String)description).length() > 2000) {
            int lastSpace;
            int breakPoint = ContextResolver.findBestBreakpoint((String)description, 1500, 2100);
            description = breakPoint != -1 ? ((String)description).substring(0, breakPoint + 1).trim() : ((String)description).substring(0, (lastSpace = ((String)description).lastIndexOf(32, 2000)) > 1500 ? lastSpace : 2000).trim() + "...";
        }
        return ((String)description).trim();
    }

    private static String cleanJavadocComment(String rawJavadoc) {
        if (rawJavadoc == null || rawJavadoc.isEmpty()) {
            return "";
        }
        String cleaned = rawJavadoc;
        cleaned = cleaned.replaceFirst("^/\\*\\*", "");
        cleaned = cleaned.replaceFirst("\\*/$", "");
        String[] lines = cleaned.split("\\r?\\n");
        StringBuilder result = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String trimmed = line.trim();
            if (trimmed.startsWith("*")) {
                trimmed = trimmed.substring(1).trim();
            }
            if (result.length() != 0 || !trimmed.isEmpty()) {
                if (result.length() > 0 && !trimmed.isEmpty()) {
                    result.append("\n");
                }
                result.append(trimmed);
            }
            ++n2;
        }
        return result.toString();
    }

    private static String convertHtmlEntities(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return text.replace("&nbsp;", " ").replace("&lt;", "<").replace("&gt;", ">").replace("&amp;", "&").replace("&quot;", "\"").replace("&#39;", "'").replace("&apos;", "'").replace("&mdash;", "-").replace("&ndash;", "-");
    }

    private static String removeHtmlTags(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        text = text.replaceAll("(?i)</(p|div|li)>|<br\\s*/?>|<p[^>]*>", "\n");
        text = text.replaceAll("<[^>]+>", "");
        text = text.replaceAll("[ \\t]+", " ").replaceAll(" *\\n *", "\n").replaceAll("\\n{3,}", "\n\n");
        return text.trim();
    }

    private static String extractMethodJavaDocSummary(IMethod method) {
        String rawJavadoc;
        block5: {
            ISourceRange javadocRange;
            block4: {
                try {
                    javadocRange = method.getJavadocRange();
                    if (javadocRange != null) break block4;
                    return "";
                }
                catch (Exception e) {
                    return "";
                }
            }
            rawJavadoc = method.getCompilationUnit().getSource().substring(javadocRange.getOffset(), javadocRange.getOffset() + javadocRange.getLength());
            if (ContextResolver.isNotEmpty(rawJavadoc)) break block5;
            return "";
        }
        String cleaned = ContextResolver.cleanJavadocComment(rawJavadoc);
        cleaned = ContextResolver.removeHtmlTags(cleaned);
        return ContextResolver.convertHtmlEntities(cleaned);
    }

    private static String extractJavadocDescription(String cleanedJavadoc) {
        if (cleanedJavadoc == null || cleanedJavadoc.isEmpty()) {
            return "";
        }
        String[] lines = cleanedJavadoc.split("\\n");
        StringBuilder description = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String trimmedLine = line.trim();
            if (trimmedLine.startsWith("@")) break;
            if (description.length() != 0 || !trimmedLine.isEmpty()) {
                if (description.length() > 0) {
                    description.append(" ");
                }
                description.append(trimmedLine);
            }
            ++n2;
        }
        return description.toString().trim();
    }

    private static String getFirstSentenceOrLimit(String text, int maxLength) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        int firstSentenceEnd = ContextResolver.findFirstSentenceBoundary(text);
        if (firstSentenceEnd != -1 && firstSentenceEnd < maxLength) {
            return text.substring(0, firstSentenceEnd + 1).trim();
        }
        if (text.length() > maxLength) {
            int lastSpace = text.lastIndexOf(32, maxLength);
            int cutPoint = lastSpace > maxLength / 2 ? lastSpace : maxLength;
            return text.substring(0, cutPoint).trim() + "...";
        }
        return text.trim();
    }

    private static int findFirstSentenceBoundary(String text) {
        int[] boundaries = new int[]{text.indexOf(". "), text.indexOf(".\n"), text.indexOf("! "), text.indexOf("? ")};
        int result = -1;
        int[] nArray = boundaries;
        int n = boundaries.length;
        int n2 = 0;
        while (n2 < n) {
            int boundary = nArray[n2];
            if (boundary != -1 && (result == -1 || boundary < result)) {
                result = boundary;
            }
            ++n2;
        }
        return result;
    }

    private static int findBestBreakpoint(String text, int minPos, int maxPos) {
        int[] boundaries = new int[]{text.indexOf(". ", minPos), text.indexOf(".\n", minPos), text.indexOf("! ", minPos), text.indexOf("? ", minPos)};
        int result = -1;
        int[] nArray = boundaries;
        int n = boundaries.length;
        int n2 = 0;
        while (n2 < n) {
            int boundary = nArray[n2];
            if (boundary != -1 && boundary < maxPos && (result == -1 || boundary < result)) {
                result = boundary;
            }
            ++n2;
        }
        return result;
    }

    private static String extractFieldJavaDocSummary(IField field) {
        String rawJavadoc;
        block5: {
            ISourceRange javadocRange;
            block4: {
                try {
                    javadocRange = field.getJavadocRange();
                    if (javadocRange != null) break block4;
                    return "";
                }
                catch (Exception e) {
                    return "";
                }
            }
            rawJavadoc = field.getCompilationUnit().getSource().substring(javadocRange.getOffset(), javadocRange.getOffset() + javadocRange.getLength());
            if (ContextResolver.isNotEmpty(rawJavadoc)) break block5;
            return "";
        }
        String cleaned = ContextResolver.cleanJavadocComment(rawJavadoc);
        cleaned = ContextResolver.removeHtmlTags(cleaned);
        return ContextResolver.convertHtmlEntities(cleaned);
    }

    public static String generateMethodSignature(IMethod method) {
        return ContextResolver.generateMethodSignatureInternal(method, false, true);
    }

    public static String generateFieldSignature(IField field) {
        return ContextResolver.generateFieldSignatureInternal(field, false);
    }

    public static String convertTypeSignature(String jdtSignature) {
        Object baseType;
        if (jdtSignature == null || jdtSignature.isEmpty()) {
            return "void";
        }
        int arrayDimensions = 0;
        while (jdtSignature.startsWith("[")) {
            ++arrayDimensions;
            jdtSignature = jdtSignature.substring(1);
        }
        if (jdtSignature.startsWith("Q") && jdtSignature.endsWith(";")) {
            baseType = jdtSignature.substring(1, jdtSignature.length() - 1);
            baseType = ((String)baseType).replace('/', '.');
            baseType = ContextResolver.processGenericTypes((String)baseType);
            baseType = ContextResolver.simplifyTypeName((String)baseType);
        } else if (jdtSignature.startsWith("L") && jdtSignature.endsWith(";")) {
            baseType = jdtSignature.substring(1, jdtSignature.length() - 1);
            baseType = ((String)baseType).replace('/', '.');
            baseType = ContextResolver.processGenericTypes((String)baseType);
            baseType = ContextResolver.simplifyTypeName((String)baseType);
        } else {
            switch (jdtSignature.charAt(0)) {
                case 'I': {
                    baseType = "int";
                    break;
                }
                case 'Z': {
                    baseType = "boolean";
                    break;
                }
                case 'V': {
                    baseType = "void";
                    break;
                }
                case 'J': {
                    baseType = "long";
                    break;
                }
                case 'F': {
                    baseType = "float";
                    break;
                }
                case 'D': {
                    baseType = "double";
                    break;
                }
                case 'B': {
                    baseType = "byte";
                    break;
                }
                case 'C': {
                    baseType = "char";
                    break;
                }
                case 'S': {
                    baseType = "short";
                    break;
                }
                default: {
                    baseType = jdtSignature;
                }
            }
        }
        int i = 0;
        while (i < arrayDimensions) {
            baseType = (String)baseType + "[]";
            ++i;
        }
        return baseType;
    }

    private static String processGenericTypes(String typeName) {
        if (typeName == null || !typeName.contains("<")) {
            return typeName;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < typeName.length()) {
            char c = typeName.charAt(i);
            if (c == '<' || c == ',' || c == ' ') {
                result.append(c);
                ++i;
                while (i < typeName.length() && typeName.charAt(i) == ' ') {
                    result.append(' ');
                    ++i;
                }
                if (i >= typeName.length()) continue;
                char next = typeName.charAt(i);
                if (next == 'Q' || next == 'L') {
                    int endIndex = typeName.indexOf(59, i);
                    if (endIndex != -1) {
                        String typeParam = typeName.substring(i + 1, endIndex);
                        typeParam = ContextResolver.processGenericTypes(typeParam);
                        typeParam = ContextResolver.simplifyTypeName(typeParam);
                        result.append(typeParam);
                        i = endIndex + 1;
                        continue;
                    }
                    result.append(next);
                    ++i;
                    continue;
                }
                result.append(next);
                ++i;
                continue;
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    private static String simplifyTypeName(String qualifiedName) {
        if (qualifiedName == null) {
            return qualifiedName;
        }
        int lastDot = qualifiedName.lastIndexOf(46);
        return lastDot == -1 ? qualifiedName : qualifiedName.substring(lastDot + 1);
    }

    private static String generateMethodSignatureInternal(IMethod method, boolean simplified, boolean includeJavadoc) {
        try {
            String javadocSummary;
            String[] typeParameters;
            StringBuilder sb = new StringBuilder();
            int flags = method.getFlags();
            if (Flags.isPublic((int)flags)) {
                sb.append("public ");
            }
            if (!simplified) {
                if (Flags.isProtected((int)flags)) {
                    sb.append("protected ");
                }
                if (Flags.isPrivate((int)flags)) {
                    sb.append("private ");
                }
            }
            if (Flags.isStatic((int)flags)) {
                sb.append("static ");
            }
            if (Flags.isFinal((int)flags)) {
                sb.append("final ");
            }
            if (Flags.isAbstract((int)flags)) {
                sb.append("abstract ");
            }
            if (!simplified && (typeParameters = method.getTypeParameterSignatures()) != null && typeParameters.length > 0) {
                sb.append("<");
                int i = 0;
                while (i < typeParameters.length) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(ContextResolver.convertTypeSignature(typeParameters[i]));
                    ++i;
                }
                sb.append("> ");
            }
            if (!method.isConstructor()) {
                String returnType = simplified ? ContextResolver.simplifyTypeName(Signature.toString((String)method.getReturnType())) : ContextResolver.convertTypeSignature(method.getReturnType());
                sb.append(returnType).append(" ");
            }
            sb.append(method.getElementName()).append("(");
            String[] paramTypes = method.getParameterTypes();
            String[] paramNames = simplified ? null : method.getParameterNames();
            int i = 0;
            while (i < paramTypes.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                String paramType = simplified ? ContextResolver.simplifyTypeName(Signature.toString((String)paramTypes[i])) : ContextResolver.convertTypeSignature(paramTypes[i]);
                sb.append(paramType);
                if (paramNames != null && i < paramNames.length) {
                    sb.append(" ").append(paramNames[i]);
                }
                ++i;
            }
            sb.append(")");
            if (!simplified) {
                String[] exceptionTypes = method.getExceptionTypes();
                if (exceptionTypes != null && exceptionTypes.length > 0) {
                    sb.append(" throws ");
                    int i2 = 0;
                    while (i2 < exceptionTypes.length) {
                        if (i2 > 0) {
                            sb.append(", ");
                        }
                        sb.append(ContextResolver.convertTypeSignature(exceptionTypes[i2]));
                        ++i2;
                    }
                }
            } else {
                sb.append(";");
            }
            if (includeJavadoc && (javadocSummary = ContextResolver.extractMethodJavaDocSummary(method)) != null && !javadocSummary.isEmpty()) {
                return "// " + javadocSummary + "\n      " + sb.toString();
            }
            return sb.toString();
        }
        catch (JavaModelException e) {
            return simplified ? "// Error generating method signature" : method.getElementName() + "(...)";
        }
    }

    private static String generateFieldSignatureInternal(IField field, boolean simplified) {
        try {
            String javadocSummary;
            Object constant;
            StringBuilder sb = new StringBuilder();
            int flags = field.getFlags();
            if (Flags.isPublic((int)flags)) {
                sb.append("public ");
            }
            if (!simplified) {
                if (Flags.isProtected((int)flags)) {
                    sb.append("protected ");
                }
                if (Flags.isPrivate((int)flags)) {
                    sb.append("private ");
                }
            }
            if (Flags.isStatic((int)flags)) {
                sb.append("static ");
            }
            if (Flags.isFinal((int)flags)) {
                sb.append("final ");
            }
            String fieldType = simplified ? ContextResolver.simplifyTypeName(Signature.toString((String)field.getTypeSignature())) : ContextResolver.convertTypeSignature(field.getTypeSignature());
            sb.append(fieldType).append(" ").append(field.getElementName());
            if (!simplified && Flags.isStatic((int)flags) && Flags.isFinal((int)flags) && (constant = field.getConstant()) != null) {
                sb.append(" = ");
                if (constant instanceof String) {
                    sb.append("\"").append(constant).append("\"");
                } else {
                    sb.append(constant);
                }
            }
            if (simplified) {
                sb.append(";");
            }
            if (!simplified && (javadocSummary = ContextResolver.extractFieldJavaDocSummary(field)) != null && !javadocSummary.isEmpty()) {
                return "// " + javadocSummary + "\n      " + sb.toString();
            }
            return sb.toString();
        }
        catch (JavaModelException e) {
            return simplified ? "// Error generating field signature" : field.getElementName();
        }
    }

    private static boolean isNotEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    public static class ImportClassInfo {
        public String uri;
        public String value;

        public ImportClassInfo(String uri, String value) {
            this.uri = uri;
            this.value = value;
        }
    }
}

