/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.core.internal.services;

import ch.epfl.scala.bsp4j.BuildClient;
import ch.epfl.scala.bsp4j.BuildServerCapabilities;
import ch.epfl.scala.bsp4j.CompileProvider;
import ch.epfl.scala.bsp4j.InitializeBuildParams;
import ch.epfl.scala.bsp4j.InitializeBuildResult;
import ch.epfl.scala.bsp4j.MessageType;
import ch.epfl.scala.bsp4j.ShowMessageParams;
import com.microsoft.java.bs.core.Constants;
import com.microsoft.java.bs.core.Launcher;
import com.microsoft.java.bs.core.internal.gradle.GradleApiConnector;
import com.microsoft.java.bs.core.internal.gradle.GradleBuildKind;
import com.microsoft.java.bs.core.internal.gradle.Utils;
import com.microsoft.java.bs.core.internal.managers.PreferenceManager;
import com.microsoft.java.bs.core.internal.model.Preferences;
import com.microsoft.java.bs.core.internal.utils.JavaUtils;
import com.microsoft.java.bs.core.internal.utils.JsonUtils;
import com.microsoft.java.bs.core.internal.utils.TelemetryUtils;
import com.microsoft.java.bs.core.internal.utils.UriUtils;
import com.microsoft.java.bs.gradle.model.SupportedLanguages;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.logging.Level;
import org.gradle.tooling.model.build.BuildEnvironment;

public class LifecycleService {
    private Status status = Status.UNINITIALIZED;
    private final GradleApiConnector connector;
    private final PreferenceManager preferenceManager;
    private BuildClient client;

    public LifecycleService(GradleApiConnector connector, PreferenceManager preferenceManager) {
        this.connector = connector;
        this.preferenceManager = preferenceManager;
    }

    public InitializeBuildResult initializeServer(InitializeBuildParams params) {
        this.initializePreferenceManager(params);
        BuildServerCapabilities capabilities = this.initializeServerCapabilities();
        return new InitializeBuildResult("gradle-build-server", Constants.SERVER_VERSION, "2.1.0-M4", capabilities);
    }

    public void setClient(BuildClient client) {
        this.client = client;
    }

    void initializePreferenceManager(InitializeBuildParams params) {
        URI rootUri = UriUtils.getUriFromString(params.getRootUri());
        this.preferenceManager.setRootUri(rootUri);
        this.preferenceManager.setClientSupportedLanguages(params.getCapabilities().getLanguageIds());
        Preferences preferences = JsonUtils.toModel(params.getData(), Preferences.class);
        if (preferences == null) {
            preferences = new Preferences();
        }
        this.preferenceManager.setPreferences(preferences);
        this.setGradleJavaHome(rootUri);
    }

    private BuildServerCapabilities initializeServerCapabilities() {
        BuildServerCapabilities capabilities = new BuildServerCapabilities();
        capabilities.setResourcesProvider(Boolean.valueOf(true));
        capabilities.setOutputPathsProvider(Boolean.valueOf(true));
        capabilities.setDependencyModulesProvider(Boolean.valueOf(true));
        capabilities.setDependencySourcesProvider(Boolean.valueOf(true));
        capabilities.setCanReload(Boolean.valueOf(true));
        capabilities.setBuildTargetChangedProvider(Boolean.valueOf(true));
        capabilities.setCompileProvider(new CompileProvider(SupportedLanguages.allBspNames));
        return capabilities;
    }

    public void onBuildInitialized() {
        this.status = Status.INITIALIZED;
    }

    public Object shutdown() {
        this.connector.shutdown();
        this.status = Status.SHUTDOWN;
        return null;
    }

    public void exit() {
        if (this.status == Status.SHUTDOWN) {
            System.exit(0);
        }
        System.exit(1);
    }

    private void setGradleJavaHome(URI rootUri) {
        String oldestCompatibleVersion;
        boolean isCompatible = this.connector.checkCompatibilityWithProbeBuild(rootUri);
        if (isCompatible) {
            return;
        }
        BuildEnvironment buildEnv = this.connector.getBuildEnvironment(rootUri);
        String gradleVersion = this.getGradleVersion(rootUri, buildEnv);
        if (gradleVersion == null) {
            Launcher.LOGGER.severe("Failed to find current gradle version.");
            return;
        }
        String latestCompatibleVersion = Utils.getLatestCompatibleJavaVersion(gradleVersion);
        File jdk = this.getGradleCompatibleJdk(buildEnv, latestCompatibleVersion, oldestCompatibleVersion = Utils.getOldestCompatibleJavaVersion());
        if (jdk != null) {
            this.preferenceManager.getPreferences().setGradleJavaHome(jdk.getAbsolutePath());
            if (this.client != null) {
                ShowMessageParams messageParams = new ShowMessageParams(MessageType.INFORMATION, String.format("Default JDK wasn't compatible with current gradle version (" + gradleVersion + ").Using \"%s\" instead.", jdk.getAbsolutePath()));
                this.client.onBuildShowMessage(messageParams);
            }
        } else if (this.client != null) {
            ShowMessageParams messageParams = new ShowMessageParams(MessageType.ERROR, "Failed to find a JDK compatible with current gradle version (" + gradleVersion + ").");
            this.client.onBuildShowMessage(messageParams);
        }
    }

    private String getGradleVersion(URI rootUri, BuildEnvironment buildEnv) {
        String gradleVersion;
        Preferences preferences = this.preferenceManager.getPreferences();
        GradleBuildKind buildKind = Utils.getEffectiveBuildKind(new File(rootUri), preferences);
        Map<String, String> map = TelemetryUtils.getMetadataMap("buildKind", buildKind.name());
        Launcher.LOGGER.log(Level.INFO, "Use build kind: " + buildKind.name(), map);
        String string = buildKind.equals((Object)GradleBuildKind.SPECIFIED_VERSION) ? preferences.getGradleVersion() : (gradleVersion = buildEnv != null ? buildEnv.getGradle().getGradleVersion() : null);
        if (gradleVersion != null) {
            map = TelemetryUtils.getMetadataMap("gradleVersion", gradleVersion);
            Launcher.LOGGER.log(Level.INFO, "Gradle version: " + gradleVersion, map);
        }
        return gradleVersion;
    }

    private File getGradleCompatibleJdk(BuildEnvironment buildEnv, String latestCompatibleVersion, String oldestCompatibleVersion) {
        Map<String, String> userJdks;
        File gradleJavaHome;
        Preferences preferences = this.preferenceManager.getPreferences();
        String preferencesGradleJavaHome = preferences.getGradleJavaHome();
        File file = preferencesGradleJavaHome != null ? new File(preferencesGradleJavaHome) : (gradleJavaHome = buildEnv != null ? buildEnv.getJava().getJavaHome() : null);
        if (latestCompatibleVersion.isEmpty()) {
            return null;
        }
        if (gradleJavaHome != null) {
            try {
                String gradleJavaHomeVersion = JavaUtils.getJavaVersionFromFile(gradleJavaHome);
                if (JavaUtils.isCompatible(gradleJavaHomeVersion, oldestCompatibleVersion, latestCompatibleVersion)) {
                    return gradleJavaHome;
                }
            }
            catch (IOException | IllegalArgumentException e) {
                Launcher.LOGGER.severe("Invalid GradleJavaHome: " + e.getMessage());
            }
        }
        if ((userJdks = preferences.getJdks()) != null && !userJdks.isEmpty()) {
            return LifecycleService.getLatestCompatibleJdk(preferences.getJdks(), oldestCompatibleVersion, latestCompatibleVersion);
        }
        return null;
    }

    static File getLatestCompatibleJdk(Map<String, String> jdks, String oldestCompatibleJavaVersion, String latestCompatibleJavaVersion) {
        Map.Entry<String, String> selected = null;
        for (Map.Entry<String, String> jdk : jdks.entrySet()) {
            String javaVersion = jdk.getKey();
            boolean isHigherThanSelected = selected == null || Runtime.Version.parse((String)selected.getKey()).feature() < Runtime.Version.parse(javaVersion).feature();
            try {
                if (!JavaUtils.isCompatible(javaVersion, oldestCompatibleJavaVersion, latestCompatibleJavaVersion) || !isHigherThanSelected) continue;
                selected = jdk;
            }
            catch (IllegalArgumentException e) {
                Launcher.LOGGER.severe("Invalid JDK version: " + e.getMessage());
            }
        }
        if (selected != null) {
            try {
                return new File(new URI((String)selected.getValue()));
            }
            catch (URISyntaxException e) {
                Launcher.LOGGER.severe("Invalid JDK URI: " + (String)selected.getValue());
            }
        }
        return null;
    }

    static enum Status {
        UNINITIALIZED,
        INITIALIZED,
        SHUTDOWN;

    }
}

