/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import com.sun.tools.javac.tree.JCTree;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.compiler.ClassFile;

public class JavacClassFile
extends ClassFile {
    final String fullName;
    private byte[] bytes = null;
    private final File proxyFile;
    private final IFile outputFile;

    public JavacClassFile(String qualifiedName, ClassFile enclosingClass, IContainer outputDir, java.nio.file.Path tempDir) {
        this.fullName = qualifiedName;
        this.isNestedType = enclosingClass != null;
        this.enclosingClassFile = enclosingClass;
        IPath relativePath = new Path(this.fullName.replace('.', File.separatorChar)).addFileExtension("class");
        this.outputFile = outputDir.getFile(relativePath);
        this.proxyFile = tempDir.resolve(relativePath.toPath()).toFile();
    }

    public JavacClassFile(JCTree.JCModuleDecl moduleDecl, IContainer outputDir, java.nio.file.Path tempDir) {
        this.fullName = "module-info";
        this.isNestedType = false;
        this.enclosingClassFile = null;
        IPath relativePath = new Path(this.fullName.replace('.', File.separatorChar)).addFileExtension("class");
        this.outputFile = outputDir.getFile(relativePath);
        this.proxyFile = tempDir.resolve(relativePath.toPath()).toFile();
    }

    public char[][] getCompoundName() {
        String[] names = this.fullName.split("\\.");
        char[][] compoundNames = new char[names.length][];
        for (int i = 0; i < names.length; ++i) {
            compoundNames[i] = names[i].toCharArray();
        }
        return compoundNames;
    }

    public char[] fileName() {
        String compoundName = this.fullName.replace('.', '/');
        return compoundName.toCharArray();
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            if (!this.proxyFile.exists()) {
                this.bytes = new byte[0];
            } else {
                try {
                    this.bytes = Files.readAllBytes(this.proxyFile.toPath());
                }
                catch (IOException e) {
                    this.bytes = new byte[0];
                }
                this.proxyFile.delete();
            }
        }
        return this.bytes;
    }

    void deleteExpectedClassFile() {
        try {
            this.outputFile.delete(true, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void flushTempToOutput() {
        try {
            JavacClassFile.createFolder(this.outputFile.getParent());
            this.outputFile.write(this.getBytes(), true, true, false, null);
            this.proxyFile.delete();
        }
        catch (CoreException e) {
            ILog.get().error(e.getMessage(), (Throwable)e);
        }
    }

    private static IContainer createFolder(IContainer container) throws CoreException {
        IFolder folder;
        if (container instanceof IFolder && !(folder = (IFolder)container).exists()) {
            JavacClassFile.createFolder(folder.getParent());
            folder.create(1025, true, null);
        }
        return container;
    }
}

