/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;

public class UpdateClasspathJob
extends WorkspaceJob {
    private static final long SCHEDULE_DELAY = 1000L;
    private final Set<UpdateClasspathRequest> queue = new LinkedHashSet<UpdateClasspathRequest>();
    private static final UpdateClasspathJob instance = new UpdateClasspathJob();

    UpdateClasspathJob() {
        super("Update classpath Job");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        ArrayList<UpdateClasspathRequest> requests;
        Set<UpdateClasspathRequest> set = this.queue;
        synchronized (set) {
            requests = new ArrayList<UpdateClasspathRequest>(this.queue);
            this.queue.clear();
        }
        Map<IJavaProject, UpdateClasspathRequest> mergedRequestPerProject = requests.stream().collect(Collectors.groupingBy(UpdateClasspathRequest::getProject, Collectors.reducing(new UpdateClasspathRequest(), (mergedRequest, request) -> {
            mergedRequest.setProject(request.getProject());
            mergedRequest.getInclude().addAll(request.getInclude());
            mergedRequest.getExclude().addAll(request.getExclude());
            mergedRequest.getSources().putAll(request.getSources());
            return mergedRequest;
        })));
        for (Map.Entry<IJavaProject, UpdateClasspathRequest> entry : mergedRequestPerProject.entrySet()) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (entry.getValue() == null) continue;
            IJavaProject project = entry.getKey();
            UpdateClasspathRequest request2 = entry.getValue();
            this.doUpdateClasspath(project, request2.include, request2.exclude, request2.sources, monitor);
        }
        Set<UpdateClasspathRequest> set2 = this.queue;
        synchronized (set2) {
            if (!this.queue.isEmpty()) {
                this.schedule(1000L);
            }
        }
        return Status.OK_STATUS;
    }

    private void doUpdateClasspath(IJavaProject javaProject, Set<String> include, Set<String> exclude, Map<String, String> sources, IProgressMonitor monitor) throws CoreException {
        JavaLanguageServerPlugin.logInfo(">> Updating classpath for project " + javaProject.getElementName());
        IPath realFolder = ProjectUtils.getProjectRealFolder(javaProject.getProject());
        Set<java.nio.file.Path> binaries = ProjectUtils.collectBinaries(realFolder, include, exclude, monitor);
        HashMap<java.nio.file.Path, Path> expandedSources = new HashMap<java.nio.file.Path, Path>();
        for (Map.Entry<String, String> entry : sources.entrySet()) {
            java.nio.file.Path realFolderPath = realFolder.toFile().toPath();
            java.nio.file.Path binary = realFolderPath.resolve(entry.getKey());
            java.nio.file.Path source = realFolderPath.resolve(entry.getValue());
            expandedSources.put(binary, new Path(source.toString()));
        }
        HashMap<java.nio.file.Path, IPath> libraries = new HashMap<java.nio.file.Path, IPath>();
        for (java.nio.file.Path binary : binaries) {
            if (expandedSources.containsKey(binary)) {
                libraries.put(binary, (IPath)expandedSources.get(binary));
                continue;
            }
            libraries.put(binary, ProjectUtils.detectSources(binary));
        }
        ProjectUtils.updateBinaries(javaProject, libraries, monitor);
    }

    public void updateClasspath(IJavaProject project, Set<String> include, Set<String> exclude, Map<String, String> sources) {
        if (project == null || include == null) {
            return;
        }
        if (exclude == null) {
            exclude = new HashSet<String>();
        }
        if (sources == null) {
            sources = new HashMap<String, String>();
        }
        this.update(new UpdateClasspathRequest(project, include, exclude, sources));
    }

    public void updateClasspath(IJavaProject project, Preferences.ReferencedLibraries libraries) {
        this.updateClasspath(project, libraries.getInclude(), libraries.getExclude(), libraries.getSources());
    }

    public void updateClasspath(IJavaProject project) {
        this.updateClasspath(project, JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getReferencedLibraries());
    }

    public void updateClasspath() {
        Preferences preferences = JavaLanguageServerPlugin.getPreferencesManager().getPreferences();
        Collection<IPath> rootPaths = preferences.getRootPaths();
        if (rootPaths == null) {
            return;
        }
        for (IPath rootPath : rootPaths) {
            String invisibleProjectName = ProjectUtils.getWorkspaceInvisibleProjectName(rootPath);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(invisibleProjectName);
            if (!project.exists() || !project.isAccessible()) continue;
            this.updateClasspath(JavaCore.create((IProject)project), preferences.getReferencedLibraries());
        }
    }

    void update(UpdateClasspathRequest updateRequest) {
        this.queue(updateRequest);
        this.schedule(1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queue(UpdateClasspathRequest updateRequest) {
        Set<UpdateClasspathRequest> set = this.queue;
        synchronized (set) {
            this.queue.add(updateRequest);
        }
    }

    public static UpdateClasspathJob getInstance() {
        return instance;
    }

    static class UpdateClasspathRequest {
        private IJavaProject project;
        private Set<String> include;
        private Set<String> exclude;
        private Map<String, String> sources;

        UpdateClasspathRequest(IJavaProject project, Set<String> include, Set<String> exclude, Map<String, String> sources) {
            this.project = project;
            this.include = include;
            this.exclude = exclude;
            this.sources = sources;
        }

        UpdateClasspathRequest() {
            this(null, new HashSet<String>(), new HashSet<String>(), new HashMap<String, String>());
        }

        void setProject(IJavaProject project) {
            this.project = project;
        }

        IJavaProject getProject() {
            return this.project;
        }

        Set<String> getInclude() {
            return this.include;
        }

        Set<String> getExclude() {
            return this.exclude;
        }

        Map<String, String> getSources() {
            return this.sources;
        }

        public int hashCode() {
            return Objects.hash(this.include, this.exclude, this.sources, this.project);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UpdateClasspathRequest other = (UpdateClasspathRequest)obj;
            return Objects.equals(this.project, other.project) && Objects.equals(this.include, other.include) && Objects.equals(this.exclude, other.exclude) && Objects.equals(this.sources, other.sources);
        }
    }
}

