/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TextBlock;
import org.eclipse.jdt.internal.ui.text.FastJavaPartitioner;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.handlers.SmartDetectionParams;
import org.eclipse.jdt.ls.core.internal.partition.FastJavaPartitionScanner;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.lsp4j.Location;

public class SmartDetectionHandler {
    private SmartDetectionParams params;
    private String partitioning;

    public SmartDetectionHandler(SmartDetectionParams params) {
        this.params = params;
        this.partitioning = "___java_partitioning";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getLocation(IProgressMonitor monitor) {
        SmartDetectionParams smartDetectionParams;
        IDocument document;
        block21: {
            block20: {
                block19: {
                    block18: {
                        block17: {
                            if (this.params == null) return null;
                            if (this.params.getUri() == null) return null;
                            if (this.params.getPosition() == null) {
                                return null;
                            }
                            document = null;
                            try {
                                int endOffset;
                                int offset;
                                String uri = this.params.getUri();
                                ICompilationUnit unit = JDTUtils.resolveCompilationUnit(uri);
                                if (unit == null) {
                                    return null;
                                }
                                document = JsonRpcHelpers.toDocument(unit.getBuffer());
                                int pos = offset = JsonRpcHelpers.toOffset(document, this.params.getPosition().getLine(), this.params.getPosition().getCharacter());
                                char fCharacter = ';';
                                IRegion line = document.getLineInformationOfOffset(pos);
                                this.installJavaStuff(document, unit.getJavaProject());
                                int positionInLine = this.computeCharacterPosition(document, line, pos - line.getOffset(), fCharacter);
                                int position = positionInLine + line.getOffset();
                                if (position <= pos) {
                                    if (document == null) return null;
                                    break block17;
                                }
                                if (this.alreadyPresent(document, fCharacter, position)) {
                                    if (document == null) return null;
                                    break block18;
                                }
                                ASTNode node = JDTUtils.getHoveredASTNode((ITypeRoot)unit, (IRegion)new Region(position, 1));
                                if (node instanceof Comment || node instanceof StringLiteral || node instanceof TextBlock) {
                                    if (document == null) return null;
                                    break block19;
                                }
                                if (node instanceof MethodInvocation && (endOffset = node.getStartPosition() + node.getLength()) > position) {
                                    if (document == null) return null;
                                    break block20;
                                }
                                Location location = JDTUtils.toLocation(unit, position, 1);
                                smartDetectionParams = new SmartDetectionParams(this.params.getUri(), location.getRange().getStart());
                                if (document == null) return smartDetectionParams;
                                break block21;
                            }
                            catch (Exception e) {
                                JavaLanguageServerPlugin.logException(e);
                                return null;
                            }
                        }
                        TextUtilities.removeDocumentPartitioners((IDocument)document);
                        return null;
                    }
                    TextUtilities.removeDocumentPartitioners((IDocument)document);
                    return null;
                }
                TextUtilities.removeDocumentPartitioners((IDocument)document);
                return null;
            }
            TextUtilities.removeDocumentPartitioners((IDocument)document);
            return null;
        }
        TextUtilities.removeDocumentPartitioners((IDocument)document);
        return smartDetectionParams;
        finally {
            if (document != null) {
                TextUtilities.removeDocumentPartitioners(document);
            }
        }
    }

    private int computeCharacterPosition(IDocument document, IRegion line, int offset, char character) throws BadLocationException {
        int insertPos;
        String text = document.get(line.getOffset(), line.getLength());
        if (text == null) {
            return 0;
        }
        if (!SmartDetectionHandler.isDefaultPartition(document, offset + line.getOffset(), this.partitioning)) {
            return -1;
        }
        if (this.isForStatement(text, offset)) {
            insertPos = -1;
        } else {
            int nextPartitionPos = SmartDetectionHandler.nextPartitionOrLineEnd(document, line, offset, this.partitioning);
            insertPos = this.startOfWhitespaceBeforeOffset(text, nextPartitionPos);
            if (insertPos > 0 && text.charAt(insertPos - 1) == character) {
                --insertPos;
            } else if (insertPos > 0 && text.charAt(insertPos - 1) == '}') {
                int opening = SmartDetectionHandler.scanBackward(document, insertPos - 1 + line.getOffset(), this.partitioning, -1, new char[]{'{'});
                if (opening > -1 && opening < offset + line.getOffset() && this.computeArrayInitializationPos(document, line, opening - line.getOffset(), this.partitioning) == -1) {
                    insertPos = offset;
                }
            } else if (insertPos > 0 && (text.charAt(insertPos - 1) == '=' || text.charAt(insertPos - 1) == '.' || text.charAt(insertPos - 1) == '{')) {
                return -1;
            }
        }
        return insertPos;
    }

    private int computeArrayInitializationPos(IDocument document, IRegion line, int offset, String partitioning) {
        char ch;
        int p;
        block9: {
            block8: {
                int pos = offset + line.getOffset();
                if (pos == 0) {
                    return -1;
                }
                p = SmartDetectionHandler.firstNonWhitespaceBackward(document, pos - 1, partitioning, -1);
                if (p == -1) {
                    return -1;
                }
                ch = document.getChar(p);
                if (ch == '=' || ch == ']') break block8;
                return -1;
            }
            if (p == 0) {
                return offset;
            }
            if ((p = SmartDetectionHandler.firstNonWhitespaceBackward(document, p - 1, partitioning, -1)) != -1) break block9;
            return -1;
        }
        try {
            ch = document.getChar(p);
            if (Character.isJavaIdentifierPart(ch) || ch == ']' || ch == '[') {
                return offset;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    private static int firstNonWhitespaceBackward(IDocument document, int position, String partitioning, int bound) {
        Assert.isTrue((position < document.getLength() ? 1 : 0) != 0);
        Assert.isTrue((bound >= -1 ? 1 : 0) != 0);
        try {
            while (position > bound) {
                char ch = document.getChar(position);
                if (!Character.isWhitespace(ch) && SmartDetectionHandler.isDefaultPartition(document, position, partitioning)) {
                    return position;
                }
                --position;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    private static int scanBackward(IDocument document, int position, String partitioning, int bound, char[] chars) {
        Assert.isTrue((bound >= -1 ? 1 : 0) != 0);
        Assert.isTrue((position < document.getLength() ? 1 : 0) != 0);
        Arrays.sort(chars);
        try {
            while (position > bound) {
                if (Arrays.binarySearch(chars, document.getChar(position)) >= 0 && SmartDetectionHandler.isDefaultPartition(document, position, partitioning)) {
                    return position;
                }
                --position;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    private static boolean isDefaultPartition(IDocument document, int position, String partitioning) {
        Assert.isTrue((position >= 0 ? 1 : 0) != 0);
        Assert.isTrue((position <= document.getLength() ? 1 : 0) != 0);
        try {
            ITypedRegion region = TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)position, (boolean)false);
            return "__dftl_partition_content_type".equals(region.getType());
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isForStatement(String line, int offset) {
        int forPos = line.indexOf("for");
        return !(forPos == -1 || forPos != 0 && Character.isJavaIdentifierPart(line.charAt(forPos - 1)) || line.length() != forPos + 3 && Character.isJavaIdentifierPart(line.charAt(forPos + 3)));
    }

    private int startOfWhitespaceBeforeOffset(String text, int offset) {
        int i = Math.min(offset, text.length());
        while (i >= 1) {
            if (!Character.isWhitespace(text.charAt(i - 1))) break;
            --i;
        }
        return i;
    }

    private boolean alreadyPresent(IDocument document, char ch, int position) {
        int pos = this.firstNonWhitespaceForward(document, position, this.partitioning, document.getLength());
        try {
            if (pos != -1 && document.getChar(pos) == ch) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    private int firstNonWhitespaceForward(IDocument document, int position, String partitioning, int bound) {
        Assert.isTrue((position >= 0 ? 1 : 0) != 0);
        Assert.isTrue((bound <= document.getLength() ? 1 : 0) != 0);
        try {
            while (position < bound) {
                char ch = document.getChar(position);
                if (!Character.isWhitespace(ch) && SmartDetectionHandler.isDefaultPartition(document, position, partitioning)) {
                    return position;
                }
                ++position;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    private static int nextPartitionOrLineEnd(IDocument document, IRegion line, int offset, String partitioning) {
        int eol;
        int docOffset = offset + line.getOffset();
        int nextPartitionPos = eol = line.getOffset() + line.getLength();
        int validPosition = docOffset;
        try {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)nextPartitionPos, (boolean)true);
            validPosition = SmartDetectionHandler.getValidPositionForPartition(document, partition, eol);
            while (validPosition == -1) {
                nextPartitionPos = partition.getOffset() - 1;
                if (nextPartitionPos < docOffset) {
                    validPosition = docOffset;
                    break;
                }
                partition = TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)nextPartitionPos, (boolean)false);
                validPosition = SmartDetectionHandler.getValidPositionForPartition(document, partition, eol);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        validPosition = Math.max(validPosition, docOffset);
        return validPosition -= line.getOffset();
    }

    private static int getValidPositionForPartition(IDocument doc, ITypedRegion partition, int maxOffset) {
        int INVALID = -1;
        if ("__java_javadoc".equals(partition.getType())) {
            return -1;
        }
        if ("__java_multiline_comment".equals(partition.getType())) {
            return -1;
        }
        if ("__java_singleline_comment".equals(partition.getType())) {
            return -1;
        }
        int endOffset = Math.min(maxOffset, partition.getOffset() + partition.getLength());
        if ("__java_character".equals(partition.getType())) {
            return endOffset;
        }
        if ("__java_string".equals(partition.getType())) {
            return endOffset;
        }
        if ("__dftl_partition_content_type".equals(partition.getType())) {
            block9: {
                try {
                    if (doc.get(partition.getOffset(), endOffset - partition.getOffset()).trim().length() != 0) break block9;
                    return -1;
                }
                catch (BadLocationException e) {
                    return -1;
                }
            }
            return endOffset;
        }
        return endOffset;
    }

    private void installJavaStuff(IDocument document, IJavaProject project) {
        String[] types = new String[]{"__java_javadoc", "__java_multiline_comment", "__java_singleline_comment", "__java_string", "__java_character", "__java_multiline_string", "__dftl_partition_content_type"};
        FastJavaPartitioner partitioner = new FastJavaPartitioner((IPartitionTokenScanner)new FastJavaPartitionScanner(project), types);
        partitioner.connect(document);
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).setDocumentPartitioner(this.partitioning, (IDocumentPartitioner)partitioner);
        } else {
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
    }
}

