/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deprecation;

import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.featurelifecycle.FeatureUsage;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.javax.annotation.Nullable;

public class DeprecatedFeatureUsage
extends FeatureUsage {
    private final String removalDetails;
    private final String advice;
    private final String contextualAdvice;
    private final Documentation documentation;
    private final Type type;

    public DeprecatedFeatureUsage(String summary, String removalDetails, @Nullable String advice, @Nullable String contextualAdvice, Documentation documentation, Type type, Class<?> calledFrom) {
        super(summary, calledFrom);
        this.removalDetails = Preconditions.checkNotNull(removalDetails);
        this.advice = advice;
        this.contextualAdvice = contextualAdvice;
        this.type = Preconditions.checkNotNull(type);
        this.documentation = Preconditions.checkNotNull(documentation);
    }

    @VisibleForTesting
    DeprecatedFeatureUsage(DeprecatedFeatureUsage usage, Exception traceException) {
        super(usage.getSummary(), usage.getCalledFrom(), traceException);
        this.removalDetails = usage.removalDetails;
        this.advice = usage.advice;
        this.contextualAdvice = usage.contextualAdvice;
        this.documentation = usage.documentation;
        this.type = usage.type;
    }

    public String getRemovalDetails() {
        return this.removalDetails;
    }

    @Nullable
    public String getAdvice() {
        return this.advice;
    }

    @Nullable
    public String getContextualAdvice() {
        return this.contextualAdvice;
    }

    @Nullable
    public String getDocumentationUrl() {
        return this.documentation.documentationUrl();
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String formattedMessage() {
        StringBuilder outputBuilder = new StringBuilder(this.getSummary());
        this.append(outputBuilder, this.removalDetails);
        this.append(outputBuilder, this.contextualAdvice);
        this.append(outputBuilder, this.advice);
        this.append(outputBuilder, this.documentation.consultDocumentationMessage());
        return outputBuilder.toString();
    }

    private void append(StringBuilder outputBuilder, String message) {
        if (message != null && message.length() > 0) {
            outputBuilder.append(" ").append(message);
        }
    }

    public static enum Type {
        USER_CODE_DIRECT,
        USER_CODE_INDIRECT,
        BUILD_INVOCATION;

    }
}

