/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.coverage;

import com.microsoft.java.test.plugin.coverage.model.BranchCoverage;
import com.microsoft.java.test.plugin.coverage.model.LineCoverage;
import com.microsoft.java.test.plugin.coverage.model.MethodCoverage;
import com.microsoft.java.test.plugin.coverage.model.SourceFileCoverage;
import com.microsoft.java.test.plugin.util.JUnitPlugin;
import com.microsoft.java.test.plugin.util.ProjectTestUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.core.tools.ExecFileLoader;

public class CoverageHandler {
    private IJavaProject javaProject;
    private java.nio.file.Path reportBasePath;
    private static final String JACOCO_EXEC = "jacoco.exec";

    public CoverageHandler(IJavaProject javaProject, String basePath) {
        this.javaProject = javaProject;
        this.reportBasePath = Paths.get(basePath, new String[0]);
    }

    public List<SourceFileCoverage> getCoverageDetail(IProgressMonitor monitor) throws JavaModelException, IOException {
        if ("jdt.ls-java-project".equals(this.javaProject.getProject().getName())) {
            return Collections.emptyList();
        }
        LinkedList<SourceFileCoverage> coverage = new LinkedList<SourceFileCoverage>();
        LinkedList<IJavaProject> javaProjects = new LinkedList<IJavaProject>();
        javaProjects.addAll(CoverageHandler.getAllJavaProjects(this.javaProject));
        Map<IPath, List<IPath>> outputToSourcePaths = this.getOutputToSourcePathsMapping(javaProjects);
        File executionDataFile = this.reportBasePath.resolve(JACOCO_EXEC).toFile();
        ExecFileLoader execFileLoader = new ExecFileLoader();
        execFileLoader.load(executionDataFile);
        for (Map.Entry<IPath, List<IPath>> entry : outputToSourcePaths.entrySet()) {
            CoverageBuilder coverageBuilder = new CoverageBuilder();
            Analyzer analyzer = new Analyzer(execFileLoader.getExecutionDataStore(), (ICoverageVisitor)coverageBuilder);
            File outputDirectory = entry.getKey().toFile();
            if (!outputDirectory.exists()) continue;
            analyzer.analyzeAll(outputDirectory);
            Map<String, Collection<IClassCoverage>> classCoverageBySourceFilePath = this.groupClassCoverageBySourceFilePath(coverageBuilder.getClasses());
            for (ISourceFileCoverage sourceFileCoverage : coverageBuilder.getSourceFiles()) {
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                if (sourceFileCoverage.getFirstLine() == -1) {
                    JUnitPlugin.logError("Missing debug information for file: " + sourceFileCoverage.getName());
                    continue;
                }
                File sourceFile = this.getSourceFile(entry.getValue(), sourceFileCoverage);
                if (sourceFile == null) {
                    JUnitPlugin.logError("Cannot find file: " + sourceFileCoverage.getName());
                    continue;
                }
                URI uri = sourceFile.toURI();
                List<LineCoverage> lineCoverages = this.getLineCoverages(sourceFileCoverage);
                String sourcePath = sourceFileCoverage.getPackageName() + "/" + sourceFileCoverage.getName();
                List<MethodCoverage> methodCoverages = this.getMethodCoverages(classCoverageBySourceFilePath.get(sourcePath), sourceFileCoverage);
                coverage.add(new SourceFileCoverage(uri.toString(), lineCoverages, methodCoverages));
            }
        }
        return coverage;
    }

    private Map<IPath, List<IPath>> getOutputToSourcePathsMapping(List<IJavaProject> javaProjects) throws JavaModelException {
        HashMap<IPath, List<IPath>> outputToSourcePaths = new HashMap<IPath, List<IPath>>();
        for (IJavaProject javaProject : javaProjects) {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3 && !ProjectTestUtils.isTestEntry(entry)) {
                    IProject project = javaProject.getProject();
                    IPath sourceRelativePath = entry.getPath().makeRelativeTo(project.getFullPath());
                    IPath realSourcePath = project.getFolder(sourceRelativePath).getLocation();
                    IPath outputLocation = entry.getOutputLocation();
                    if (outputLocation == null) {
                        outputLocation = javaProject.getOutputLocation();
                    }
                    IPath outputRelativePath = outputLocation.makeRelativeTo(javaProject.getProject().getFullPath());
                    IPath realOutputPath = project.getFolder(outputRelativePath).getLocation();
                    outputToSourcePaths.computeIfAbsent(realOutputPath, k -> new LinkedList()).add(realSourcePath);
                }
                ++n2;
            }
        }
        return outputToSourcePaths;
    }

    private Map<String, Collection<IClassCoverage>> groupClassCoverageBySourceFilePath(Collection<IClassCoverage> classCoverages) {
        HashMap<String, Collection<IClassCoverage>> result = new HashMap<String, Collection<IClassCoverage>>();
        for (IClassCoverage classCoverage : classCoverages) {
            String key = classCoverage.getPackageName() + "/" + classCoverage.getSourceFileName();
            result.computeIfAbsent(key, k -> new LinkedList()).add(classCoverage);
        }
        return result;
    }

    private File getSourceFile(List<IPath> sourceRoots, ISourceFileCoverage sourceFileCoverage) {
        String packagePath = sourceFileCoverage.getPackageName().replace(".", "/");
        IPath sourceRelativePath = new Path(packagePath).append(sourceFileCoverage.getName());
        for (IPath sourceRoot : sourceRoots) {
            File sourceFile = sourceRoot.append(sourceRelativePath).toFile();
            if (!sourceFile.exists()) continue;
            return sourceFile;
        }
        return null;
    }

    private List<LineCoverage> getLineCoverages(ISourceFileCoverage sourceFileCoverage) {
        LinkedList<LineCoverage> lineCoverages = new LinkedList<LineCoverage>();
        int last = sourceFileCoverage.getLastLine();
        int first = sourceFileCoverage.getFirstLine();
        if (first == -1 || last == -1) {
            return lineCoverages;
        }
        int nr = first;
        while (nr <= last) {
            ILine line = sourceFileCoverage.getLine(nr);
            if (line.getStatus() != 0) {
                LinkedList<BranchCoverage> branchCoverages = new LinkedList<BranchCoverage>();
                int i = 0;
                while (i < line.getBranchCounter().getTotalCount()) {
                    branchCoverages.add(new BranchCoverage(i < line.getBranchCounter().getCoveredCount() ? 1 : 0));
                    ++i;
                }
                lineCoverages.add(new LineCoverage(nr, line.getInstructionCounter().getCoveredCount(), branchCoverages));
            }
            ++nr;
        }
        return lineCoverages;
    }

    private List<MethodCoverage> getMethodCoverages(Collection<IClassCoverage> classCoverages, ISourceFileCoverage sourceFileCoverage) {
        if (classCoverages == null || classCoverages.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<MethodCoverage> methodCoverages = new LinkedList<MethodCoverage>();
        for (IClassCoverage classCoverage : classCoverages) {
            for (IMethodCoverage methodCoverage : classCoverage.getMethods()) {
                if (methodCoverage.getFirstLine() == -1) continue;
                methodCoverages.add(new MethodCoverage(methodCoverage.getFirstLine(), methodCoverage.getMethodCounter().getCoveredCount() > 0 ? 1 : 0, this.getMethodName(methodCoverage)));
            }
        }
        return methodCoverages;
    }

    private String getMethodName(IMethodCoverage methodCoverage) {
        String methodName = methodCoverage.getName();
        if ("<clinit>".equals(methodName) || "<init>".equals(methodName)) {
            return methodName;
        }
        String signature = methodCoverage.getDesc();
        if (StringUtils.isBlank((CharSequence)signature)) {
            return methodName;
        }
        try {
            String[] parameterTypes = Signature.getParameterTypes((String)signature);
            LinkedList<String> parameterNames = new LinkedList<String>();
            if (parameterTypes.length > 0) {
                String[] stringArray = parameterTypes;
                int n = parameterTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String parameterType = stringArray[n2];
                    String simpleName = Signature.getSignatureSimpleName((String)parameterType.replace("/", "."));
                    parameterNames.add(simpleName);
                    ++n2;
                }
            }
            return String.format("%s(%s)", methodName, String.join((CharSequence)", ", parameterNames));
        }
        catch (IllegalArgumentException e) {
            return methodName;
        }
    }

    private static Collection<IJavaProject> getAllJavaProjects(IJavaProject javaProject) throws JavaModelException {
        LinkedHashSet<IJavaProject> result = new LinkedHashSet<IJavaProject>();
        LinkedList<IJavaProject> toScan = new LinkedList<IJavaProject>();
        toScan.add(javaProject);
        while (!toScan.isEmpty()) {
            IJavaProject currentProject = (IJavaProject)toScan.remove(0);
            if (result.contains(currentProject)) continue;
            result.add(currentProject);
            String[] stringArray = currentProject.getRequiredProjectNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String projectName = stringArray[n2];
                IJavaProject requiredProject = ProjectUtils.getJavaProject((String)projectName);
                if (requiredProject != null) {
                    toScan.add(requiredProject);
                }
                ++n2;
            }
        }
        return result;
    }
}

