/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreeScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.javac.UnusedProblemFactory;

public class UnusedTreeScanner<R, P>
extends TreeScanner<R, P> {
    final Set<Tree> privateDecls = new LinkedHashSet<Tree>();
    final Set<Symbol> usedElements = new HashSet<Symbol>();
    final Map<String, JCTree.JCImport> unusedImports = new LinkedHashMap<String, JCTree.JCImport>();
    private CompilationUnitTree unit = null;
    private boolean classSuppressUnused = false;
    private boolean methodSuppressUnused = false;
    private final UnusedDocTreeScanner unusedDocTreeScanner = new UnusedDocTreeScanner();

    @Override
    public R scan(Tree tree, P p) {
        JCTree jcTree;
        Tokens.Comment c;
        if (tree == null) {
            return super.scan(tree, p);
        }
        JCTree.JCCompilationUnit jcUnit = null;
        CompilationUnitTree compilationUnitTree = this.unit;
        if (compilationUnitTree instanceof JCTree.JCCompilationUnit) {
            JCTree.JCCompilationUnit currentUnit;
            jcUnit = currentUnit = (JCTree.JCCompilationUnit)compilationUnitTree;
        } else if (tree instanceof JCTree.JCCompilationUnit) {
            JCTree.JCCompilationUnit currentUnit;
            jcUnit = currentUnit = (JCTree.JCCompilationUnit)tree;
        }
        if (jcUnit != null && tree instanceof JCTree && (c = jcUnit.docComments.getComment(jcTree = (JCTree)tree)) != null && (c.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_BLOCK || c.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_LINE)) {
            DocCommentTree docCommentTree = jcUnit.docComments.getCommentTree(jcTree);
            this.unusedDocTreeScanner.scan(docCommentTree, p);
        }
        return super.scan(tree, p);
    }

    @Override
    public R visitCompilationUnit(CompilationUnitTree node, P p) {
        this.unit = node;
        return super.visitCompilationUnit(node, p);
    }

    @Override
    public R visitImport(ImportTree node, P p) {
        if (node instanceof JCTree.JCImport) {
            JCTree.JCImport jcImport = (JCTree.JCImport)node;
            String importClass = jcImport.qualid.toString();
            this.unusedImports.put(importClass, jcImport);
        }
        return super.visitImport(node, p);
    }

    @Override
    public R visitClass(ClassTree node, P p) {
        if (node instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)node;
            Iterator<JCTree.JCAnnotation> iterator = classDecl.mods.annotations.iterator();
            if (iterator.hasNext()) {
                JCTree.JCAnnotation annot = iterator.next();
                this.classSuppressUnused = this.isUnusedSuppressed(annot);
            }
            if (this.isPotentialUnusedDeclaration(classDecl) && !this.classSuppressUnused) {
                this.privateDecls.add(classDecl);
            }
        }
        return super.visitClass(node, p);
    }

    @Override
    public R visitIdentifier(IdentifierTree node, P p) {
        JCTree.JCIdent id;
        if (node instanceof JCTree.JCIdent) {
            id = (JCTree.JCIdent)node;
            if (this.isPrivateSymbol(id.sym)) {
                this.usedElements.add(id.sym);
            }
        }
        if (node instanceof JCTree.JCIdent) {
            id = (JCTree.JCIdent)node;
            if (this.isMemberSymbol(id.sym)) {
                String name = id.toString();
                String ownerName = id.sym.owner.toString();
                if (!ownerName.isBlank()) {
                    String starImport = ownerName + ".*";
                    String usualImport = ownerName + "." + name;
                    if (this.unusedImports.containsKey(starImport)) {
                        this.unusedImports.remove(starImport);
                    } else if (this.unusedImports.containsKey(usualImport)) {
                        this.unusedImports.remove(usualImport);
                    }
                }
            }
        }
        return super.visitIdentifier(node, p);
    }

    @Override
    public R visitMemberSelect(MemberSelectTree node, P p) {
        if (node instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess field = (JCTree.JCFieldAccess)node;
            if (this.isPrivateSymbol(field.sym)) {
                this.usedElements.add(field.sym);
            }
        }
        return super.visitMemberSelect(node, p);
    }

    @Override
    public R visitMethod(MethodTree node, P p) {
        boolean isPrivateMethod = this.isPotentialUnusedDeclaration(node);
        if (isPrivateMethod) {
            this.privateDecls.add(node);
        }
        return super.visitMethod(node, p);
    }

    @Override
    public R visitVariable(VariableTree node, P p) {
        boolean isPrivateVariable = this.isPotentialUnusedDeclaration(node);
        if (isPrivateVariable) {
            this.privateDecls.add(node);
        }
        return super.visitVariable(node, p);
    }

    @Override
    public R visitMemberReference(MemberReferenceTree node, P p) {
        if (node instanceof JCTree.JCMemberReference) {
            JCTree.JCMemberReference member = (JCTree.JCMemberReference)node;
            if (this.isPrivateSymbol(member.sym)) {
                this.usedElements.add(member.sym);
            }
        }
        return super.visitMemberReference(node, p);
    }

    @Override
    public R visitNewClass(NewClassTree node, P p) {
        if (node instanceof JCTree.JCNewClass) {
            Symbol.TypeSymbol targetClass;
            JCTree.JCNewClass newClass = (JCTree.JCNewClass)node;
            Symbol.TypeSymbol typeSymbol = targetClass = newClass.def != null ? newClass.def.sym : newClass.type.tsym;
            if (this.isPrivateSymbol(targetClass)) {
                this.usedElements.add(targetClass);
            }
            if (newClass.constructor != null) {
                this.usedElements.add(newClass.constructor);
            }
        }
        return super.visitNewClass(node, p);
    }

    private boolean isPotentialUnusedDeclaration(Tree tree) {
        if (tree instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl classTree = (JCTree.JCClassDecl)tree;
            return (classTree.getModifiers().flags & 2L) != 0L;
        }
        if (tree instanceof JCTree.JCMethodDecl) {
            JCTree.JCMethodDecl methodTree = (JCTree.JCMethodDecl)tree;
            Iterator<JCTree.JCAnnotation> iterator = methodTree.mods.annotations.iterator();
            if (iterator.hasNext()) {
                JCTree.JCAnnotation annot = iterator.next();
                this.methodSuppressUnused = this.isUnusedSuppressed(annot);
            }
            if (this.isConstructor(methodTree)) {
                return (methodTree.getModifiers().flags & 2L) != 0L && this.hasPackageVisibleConstructor(methodTree.sym.owner);
            }
            return (methodTree.getModifiers().flags & 2L) != 0L;
        }
        if (tree instanceof JCTree.JCVariableDecl) {
            Symbol.MethodSymbol method;
            Symbol owner;
            JCTree.JCVariableDecl variable = (JCTree.JCVariableDecl)tree;
            Symbol symbol = owner = variable.sym == null ? null : variable.sym.owner;
            if (owner instanceof Symbol.ClassSymbol) {
                return !this.isSerialVersionConstant(variable) && (variable.getModifiers().flags & 2L) != 0L;
            }
            if (owner instanceof Symbol.MethodSymbol && !(method = (Symbol.MethodSymbol)owner).enclClass().isInterface() && !method.isAbstract() && method.getAnnotation(Override.class) == null) {
                return true;
            }
        }
        return false;
    }

    private boolean isConstructor(JCTree.JCMethodDecl methodDecl) {
        return methodDecl.sym != null && methodDecl.sym.isConstructor();
    }

    private boolean hasPackageVisibleConstructor(Symbol symbol) {
        if (symbol instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)symbol;
            for (Symbol member : clazz.members().getSymbols()) {
                Symbol.MethodSymbol method;
                if (!(member instanceof Symbol.MethodSymbol) || !(method = (Symbol.MethodSymbol)member).isConstructor() || (method.flags() & 2L) != 0L) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPrivateSymbol(Symbol symbol) {
        if (symbol instanceof Symbol.ClassSymbol || symbol instanceof Symbol.MethodSymbol) {
            return (symbol.flags() & 2L) != 0L;
        }
        if (symbol instanceof Symbol.VarSymbol) {
            if (symbol.owner instanceof Symbol.ClassSymbol) {
                return (symbol.flags() & 2L) != 0L;
            }
            if (symbol.owner instanceof Symbol.MethodSymbol) {
                return true;
            }
        }
        return false;
    }

    private boolean isMemberSymbol(Symbol symbol) {
        if (symbol instanceof Symbol.ClassSymbol || symbol instanceof Symbol.MethodSymbol) {
            return true;
        }
        if (symbol instanceof Symbol.VarSymbol) {
            return symbol.owner instanceof Symbol.ClassSymbol;
        }
        return false;
    }

    private boolean isSerialVersionConstant(JCTree.JCVariableDecl variable) {
        Type.JCPrimitiveType type;
        Type type2;
        long flags = variable.getModifiers().flags;
        return (flags & 0x10L) != 0L && (flags & 8L) != 0L && (type2 = variable.type) instanceof Type.JCPrimitiveType && (type = (Type.JCPrimitiveType)type2).getTag() == TypeTag.LONG && "serialVersionUID".equals(variable.name.toString());
    }

    public java.util.List<CategorizedProblem> getUnusedImports(UnusedProblemFactory problemFactory) {
        return problemFactory.addUnusedImports(this.unit, this.unusedImports);
    }

    public java.util.List<CategorizedProblem> getUnusedPrivateMembers(UnusedProblemFactory problemFactory) {
        ArrayList<Tree> unusedPrivateMembers = new ArrayList<Tree>();
        if (!this.classSuppressUnused && !this.methodSuppressUnused) {
            for (Tree decl : this.privateDecls) {
                Symbol symbol;
                Symbol.VarSymbol varSymbol;
                ElementKind varKind;
                if (decl instanceof JCTree.JCClassDecl) {
                    JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)decl;
                    if (!this.usedElements.contains(classDecl.sym)) {
                        unusedPrivateMembers.add(decl);
                        continue;
                    }
                }
                if (decl instanceof JCTree.JCMethodDecl) {
                    JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)decl;
                    if (!this.usedElements.contains(methodDecl.sym)) {
                        unusedPrivateMembers.add(decl);
                        continue;
                    }
                }
                if (!(decl instanceof JCTree.JCVariableDecl)) continue;
                JCTree.JCVariableDecl variableDecl = (JCTree.JCVariableDecl)decl;
                if (this.usedElements.contains(variableDecl.sym)) continue;
                boolean suppressed = false;
                Iterator<JCTree.JCAnnotation> iterator = variableDecl.mods.annotations.iterator();
                if (iterator.hasNext()) {
                    JCTree.JCAnnotation annot = iterator.next();
                    suppressed = this.isUnusedSuppressed(annot);
                }
                ElementKind elementKind = varKind = (varSymbol = variableDecl.sym) == null ? null : varSymbol.getKind();
                if (varKind == ElementKind.FIELD && (symbol = varSymbol.owner) instanceof Symbol.ClassSymbol) {
                    Symbol.ClassSymbol css = (Symbol.ClassSymbol)symbol;
                    String name = variableDecl.name.toString();
                    if (((List)css.getRecordComponents()).map(x -> x.toString()).contains(name)) {
                        suppressed = true;
                    }
                }
                if (suppressed) continue;
                unusedPrivateMembers.add(decl);
            }
        }
        return problemFactory.addUnusedPrivateMembers(this.unit, unusedPrivateMembers);
    }

    private boolean isUnusedSuppressed(JCTree.JCAnnotation annot) {
        boolean suppressed = false;
        JCTree type = annot.getAnnotationType();
        if (type instanceof JCTree.JCIdent) {
            JCTree.JCIdent id = (JCTree.JCIdent)type;
            if (id.sym.name.contentEquals("SuppressWarnings")) {
                block0: for (JCTree.JCExpression exp : annot.getArguments()) {
                    if (!(exp instanceof JCTree.JCAssign)) continue;
                    JCTree.JCAssign assign = (JCTree.JCAssign)exp;
                    JCTree.JCExpression jCExpression = assign.lhs;
                    if (!(jCExpression instanceof JCTree.JCIdent)) continue;
                    JCTree.JCIdent lhsId = (JCTree.JCIdent)jCExpression;
                    if (!lhsId.sym.name.contentEquals("value")) continue;
                    Object object = assign.rhs;
                    if (object instanceof JCTree.JCLiteral) {
                        JCTree.JCLiteral rhsId = (JCTree.JCLiteral)object;
                        if (rhsId.value.equals("unused")) {
                            suppressed = true;
                            break;
                        }
                    }
                    if (!((object = assign.rhs) instanceof JCTree.JCNewArray)) continue;
                    JCTree.JCNewArray array = (JCTree.JCNewArray)object;
                    for (JCTree.JCExpression el : array.elems) {
                        if (!(el instanceof JCTree.JCLiteral)) continue;
                        JCTree.JCLiteral lit = (JCTree.JCLiteral)el;
                        if (!lit.value.equals("unused")) continue;
                        suppressed = true;
                        continue block0;
                    }
                }
            }
        }
        return suppressed;
    }

    private class UnusedDocTreeScanner
    extends DocTreeScanner<R, P> {
        private UnusedDocTreeScanner() {
        }

        @Override
        public R visitLink(LinkTree node, P p) {
            ReferenceTree referenceTree = node.getReference();
            if (referenceTree instanceof DCTree.DCReference) {
                DCTree.DCReference ref = (DCTree.DCReference)referenceTree;
                this.useImport(ref);
            }
            return super.visitLink(node, p);
        }

        @Override
        public R visitSee(SeeTree node, P p) {
            java.util.List<? extends DocTree> list = node.getReference();
            if (list instanceof java.util.List) {
                java.util.List<? extends DocTree> refs = list;
                for (Object e : refs) {
                    if (!(e instanceof DCTree.DCReference)) continue;
                    this.useImport((DCTree.DCReference)e);
                }
            }
            return super.visitSee(node, p);
        }

        @Override
        public R visitThrows(ThrowsTree node, P p) {
            ReferenceTree referenceTree = node.getExceptionName();
            if (referenceTree instanceof DCTree.DCReference) {
                DCTree.DCReference ref = (DCTree.DCReference)referenceTree;
                this.useImport(ref);
            }
            return super.visitThrows(node, p);
        }

        private void useImport(DCTree.DCReference ref) {
            JCTree jCTree = ref.qualifierExpression;
            if (jCTree instanceof JCTree.JCIdent) {
                JCTree.JCIdent qualifier = (JCTree.JCIdent)jCTree;
                String fieldName = null;
                Name name = ref.memberName;
                if (name instanceof JCTree.JCIdent) {
                    JCTree.JCIdent field = (JCTree.JCIdent)((Object)name);
                    fieldName = field.toString();
                }
                this.checkQualifier(qualifier, fieldName);
                if (ref.paramTypes != null) {
                    for (JCTree paramType : ref.paramTypes) {
                        if (!(paramType instanceof JCTree.JCIdent)) continue;
                        JCTree.JCIdent param = (JCTree.JCIdent)paramType;
                        this.checkQualifier(param, fieldName);
                    }
                }
            }
        }

        private void checkQualifier(JCTree.JCIdent qualifier, String fieldName) {
            if (qualifier.sym == null || qualifier.sym.owner.toString().isBlank()) {
                String suffix = "." + qualifier.getName().toString();
                Optional<String> potentialImport = UnusedTreeScanner.this.unusedImports.keySet().stream().filter(a -> a.endsWith(suffix)).findFirst();
                if (potentialImport.isPresent()) {
                    UnusedTreeScanner.this.unusedImports.remove(potentialImport.get());
                }
                if (fieldName != null) {
                    Optional<String> potentialStaticWildcardImport;
                    String suffixWithField = suffix + "." + fieldName;
                    String suffixWithWildcard = suffix + ".*";
                    Optional<String> potentialStaticImport = UnusedTreeScanner.this.unusedImports.keySet().stream().filter(a -> a.endsWith(suffixWithField)).findFirst();
                    if (potentialStaticImport.isPresent()) {
                        UnusedTreeScanner.this.unusedImports.remove(potentialStaticImport.get());
                    }
                    if ((potentialStaticWildcardImport = UnusedTreeScanner.this.unusedImports.keySet().stream().filter(a -> a.endsWith(suffixWithWildcard)).findFirst()).isPresent()) {
                        UnusedTreeScanner.this.unusedImports.remove(potentialStaticWildcardImport.get());
                    }
                }
            } else {
                String name = qualifier.toString();
                String ownerName = qualifier.sym.owner.toString();
                if (!ownerName.isBlank()) {
                    String starImport = ownerName + ".*";
                    String usualImport = ownerName + "." + name;
                    if (UnusedTreeScanner.this.unusedImports.containsKey(starImport)) {
                        UnusedTreeScanner.this.unusedImports.remove(starImport);
                    } else if (UnusedTreeScanner.this.unusedImports.containsKey(usualImport)) {
                        UnusedTreeScanner.this.unusedImports.remove(usualImport);
                    }
                    if (fieldName != null) {
                        String suffixWithField = usualImport + "." + fieldName;
                        String suffixWithWildcard = usualImport + ".*";
                        if (UnusedTreeScanner.this.unusedImports.containsKey(suffixWithField)) {
                            UnusedTreeScanner.this.unusedImports.remove(suffixWithField);
                        }
                        if (UnusedTreeScanner.this.unusedImports.containsKey(suffixWithWildcard)) {
                            UnusedTreeScanner.this.unusedImports.remove(suffixWithWildcard);
                        }
                    }
                }
            }
        }
    }
}

