/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.core.CompilationUnit;

public class DOMASTNodeUtils {
    public static IJavaElement getEnclosingJavaElement(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof AbstractTypeDeclaration || node instanceof MethodDeclaration || node instanceof FieldDeclaration || node instanceof Initializer || node instanceof ImportDeclaration || node instanceof org.eclipse.jdt.core.dom.CompilationUnit || node instanceof AnnotationTypeMemberDeclaration) {
            return DOMASTNodeUtils.getDeclaringJavaElement(node);
        }
        return DOMASTNodeUtils.getEnclosingJavaElement(node.getParent());
    }

    public static IJavaElement getDeclaringJavaElement(ASTNode key) {
        if (key instanceof org.eclipse.jdt.core.dom.CompilationUnit) {
            org.eclipse.jdt.core.dom.CompilationUnit unit = (org.eclipse.jdt.core.dom.CompilationUnit)key;
            return unit.getJavaElement();
        }
        IJavaElement je = DOMASTNodeUtils.findElementForNodeViaDirectBinding(key);
        if (je != null) {
            return je;
        }
        IJavaElement je2 = DOMASTNodeUtils.findElementForNodeCustom(key);
        return je2;
    }

    private static IJavaElement findElementForNodeCustom(ASTNode key) {
        ImportDeclaration id;
        IJavaElement parentEl;
        ASTNode parentNode;
        VariableDeclarationFragment vdf;
        FieldDeclaration fd;
        List fragments;
        if (key instanceof FieldDeclaration && (fragments = (fd = (FieldDeclaration)key).fragments()).size() > 0 && (vdf = (VariableDeclarationFragment)fragments.get(0)) != null) {
            IJavaElement ret = DOMASTNodeUtils.findElementForNodeViaDirectBinding((ASTNode)vdf);
            return ret;
        }
        if (key instanceof Initializer) {
            Initializer i = (Initializer)key;
            parentNode = i.getParent();
            int domOccurance = -1;
            if (parentNode instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration typeDecl = (AbstractTypeDeclaration)parentNode;
                List parentBody = typeDecl.bodyDeclarations();
                for (int z = 0; z < parentBody.size() && domOccurance == -1; ++z) {
                    if (parentBody.get(z) != key) continue;
                    domOccurance = z + 1;
                }
            }
            if ((parentEl = DOMASTNodeUtils.findElementForNodeViaDirectBinding(parentNode)) instanceof IParent) {
                IParent parentElement = (IParent)parentEl;
                try {
                    IJavaElement[] kiddos = parentElement.getChildren();
                    for (int q = 0; q < kiddos.length; ++q) {
                        IMember kiddoMember;
                        int count;
                        IJavaElement iJavaElement = kiddos[q];
                        if (!(iJavaElement instanceof IMember) || (count = (kiddoMember = (IMember)iJavaElement).getOccurrenceCount()) != domOccurance) continue;
                        return kiddos[q];
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
        if (key instanceof ImportDeclaration && (parentNode = (id = (ImportDeclaration)key).getParent()) instanceof org.eclipse.jdt.core.dom.CompilationUnit) {
            org.eclipse.jdt.core.dom.CompilationUnit unit = (org.eclipse.jdt.core.dom.CompilationUnit)parentNode;
            parentEl = ((org.eclipse.jdt.core.dom.CompilationUnit)id.getParent()).getJavaElement();
            return ((CompilationUnit)parentEl).getImport(id.getName().toString());
        }
        return null;
    }

    private static IJavaElement findElementForNodeViaDirectBinding(ASTNode key) {
        IBinding b;
        if (key != null && (b = DOMASTNodeUtils.getBinding(key)) != null) {
            IJavaElement el = b.getJavaElement();
            return el;
        }
        return null;
    }

    public static IBinding getBinding(ASTNode astNode) {
        if (astNode instanceof Name) {
            Name name = (Name)astNode;
            return name.resolveBinding();
        }
        if (astNode instanceof VariableDeclaration) {
            VariableDeclaration variable = (VariableDeclaration)astNode;
            return variable.resolveBinding();
        }
        if (astNode instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumConstantDeclaration = (EnumConstantDeclaration)astNode;
            return enumConstantDeclaration.resolveVariable();
        }
        if (astNode instanceof FieldAccess) {
            FieldAccess fieldAcces = (FieldAccess)astNode;
            return fieldAcces.resolveFieldBinding();
        }
        if (astNode instanceof MethodInvocation) {
            MethodInvocation method = (MethodInvocation)astNode;
            return method.resolveMethodBinding();
        }
        if (astNode instanceof Type) {
            Type type = (Type)astNode;
            return type.resolveBinding();
        }
        if (astNode instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration type = (AbstractTypeDeclaration)astNode;
            return type.resolveBinding();
        }
        if (astNode instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)astNode;
            return method.resolveBinding();
        }
        if (astNode instanceof SuperFieldAccess) {
            SuperFieldAccess superField = (SuperFieldAccess)astNode;
            return superField.resolveFieldBinding();
        }
        if (astNode instanceof SuperMethodInvocation) {
            SuperMethodInvocation superMethod = (SuperMethodInvocation)astNode;
            return superMethod.resolveMethodBinding();
        }
        if (astNode instanceof SuperMethodReference) {
            SuperMethodReference superRef = (SuperMethodReference)astNode;
            return superRef.resolveMethodBinding();
        }
        if (astNode instanceof SuperConstructorInvocation) {
            SuperConstructorInvocation superRef = (SuperConstructorInvocation)astNode;
            return superRef.resolveConstructorBinding();
        }
        if (astNode instanceof MethodRef) {
            MethodRef methodRef = (MethodRef)astNode;
            return methodRef.resolveBinding();
        }
        if (astNode instanceof MethodReference) {
            MethodReference methodRef = (MethodReference)astNode;
            return methodRef.resolveMethodBinding();
        }
        if (astNode instanceof AnnotationTypeMemberDeclaration) {
            AnnotationTypeMemberDeclaration methodRef = (AnnotationTypeMemberDeclaration)astNode;
            return methodRef.resolveBinding();
        }
        if (astNode instanceof ClassInstanceCreation) {
            ClassInstanceCreation ref = (ClassInstanceCreation)astNode;
            return ref.resolveConstructorBinding();
        }
        if (astNode instanceof TypeParameter) {
            TypeParameter ref = (TypeParameter)astNode;
            return ref.resolveBinding();
        }
        return null;
    }

    public static boolean insideDocComment(ASTNode node) {
        org.eclipse.jdt.core.dom.CompilationUnit unit;
        ASTNode aSTNode = node.getRoot();
        return aSTNode instanceof org.eclipse.jdt.core.dom.CompilationUnit && (unit = (org.eclipse.jdt.core.dom.CompilationUnit)aSTNode).getCommentList().stream().anyMatch(comment -> comment.getStartPosition() <= node.getStartPosition() && comment.getStartPosition() + comment.getLength() >= node.getStartPosition() + node.getLength());
    }

    public static boolean isWithinRange(ASTNode node, IJavaElement el) {
        if (el instanceof ISourceReference) {
            ISourceReference isr = (ISourceReference)el;
            try {
                ISourceRange r = isr.getSourceRange();
                if (r != null) {
                    int astStart = node.getStartPosition();
                    int astLen = node.getLength();
                    int rangeStart = r.getOffset();
                    int rangeLen = r.getLength();
                    return astStart >= rangeStart && astStart + astLen <= rangeStart + rangeLen;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return false;
    }
}

