/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.mapping;

import java.util.HashSet;
import org.eclipse.core.internal.resources.mapping.ShallowContainer;
import org.eclipse.core.internal.resources.mapping.ShallowResourceMapping;
import org.eclipse.core.internal.resources.mapping.SimpleResourceMapping;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public final class ResourceModelProvider
extends ModelProvider {
    @Override
    public ResourceMapping[] getMappings(IResource resource, ResourceMappingContext context, IProgressMonitor monitor) {
        return new ResourceMapping[]{new SimpleResourceMapping(resource)};
    }

    @Override
    public ResourceMapping[] getMappings(ResourceTraversal[] traversals, ResourceMappingContext context, IProgressMonitor monitor) {
        HashSet<IAdaptable> result = new HashSet<IAdaptable>();
        ResourceTraversal[] resourceTraversalArray = traversals;
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceTraversal traversal = resourceTraversalArray[n2];
            IResource[] resources = traversal.getResources();
            int depth = traversal.getDepth();
            IResource[] iResourceArray = resources;
            int n3 = resources.length;
            int n4 = 0;
            while (n4 < n3) {
                IResource resource = iResourceArray[n4];
                switch (depth) {
                    case 2: {
                        result.add(resource);
                        break;
                    }
                    case 1: {
                        if (resource.getType() == 1) {
                            result.add(resource);
                            break;
                        }
                        result.add(new ShallowContainer((IContainer)resource));
                        break;
                    }
                    case 0: {
                        if (resource.getType() != 1) break;
                        result.add(resource);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        ResourceMapping[] mappings = new ResourceMapping[result.size()];
        int i = 0;
        for (IAdaptable element : result) {
            mappings[i++] = element instanceof IResource ? new SimpleResourceMapping((IResource)element) : new ShallowResourceMapping((ShallowContainer)element);
        }
        return mappings;
    }
}

