/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CaseDefaultExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.PatternInstanceofExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypePattern;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.YieldStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.AbortSearchException;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.SwitchExpressionsFixCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.text.edits.TextEditGroup;

public class PatternInstanceofToSwitchFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit) {
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        if (cu == null || !JavaModelUtil.is21OrHigher(cu.getJavaProject())) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        SwitchStatementsFinder finder = new SwitchStatementsFinder(operations);
        compilationUnit.accept((ASTVisitor)finder);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new PatternInstanceofToSwitchFixCore(FixMessages.SwitchFix_convert_if_to_switch, compilationUnit, ops);
    }

    public static PatternInstanceofToSwitchFixCore createPatternInstanceofToSwitchFix(IfStatement ifStmt) {
        CompilationUnit compilationUnit = (CompilationUnit)ifStmt.getRoot();
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        if (cu == null || !JavaModelUtil.is21OrHigher(cu.getJavaProject())) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        SwitchStatementsFinder finder = new SwitchStatementsFinder(operations);
        SwitchStatementsFinder.SeveralIfVisitor visitor = finder.new SwitchStatementsFinder.SeveralIfVisitor();
        ifStmt.accept((ASTVisitor)visitor);
        if (operations.isEmpty()) {
            return null;
        }
        CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] ops = operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]);
        return new PatternInstanceofToSwitchFixCore(FixMessages.PatternInstanceof_convert_if_to_switch, compilationUnit, ops);
    }

    protected PatternInstanceofToSwitchFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static class PatternToSwitchExpressionOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private List<IfStatement> ifStatements;
        private Expression switchExpression;
        private List<SwitchCaseSection> cases;
        private boolean createReturnStatement;
        private String varName;
        private IVariableBinding assignmentBinding;

        public PatternToSwitchExpressionOperation(List<IfStatement> ifStatements, Expression switchExpression, List<SwitchCaseSection> cases, boolean createReturnStatement, String varName, IVariableBinding assignmentBinding) {
            this.ifStatements = ifStatements;
            this.switchExpression = switchExpression;
            this.cases = cases;
            this.createReturnStatement = createReturnStatement;
            this.varName = varName;
            this.assignmentBinding = assignmentBinding;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            AST ast = rewrite.getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.CodeStyleCleanUp_PatternInstanceOfToSwitch_description, cuRewrite);
            SwitchExpression newSwitchExpression = ast.newSwitchExpression();
            Expression newSwitchExpressionExpression = (Expression)rewrite.createCopyTarget((ASTNode)this.switchExpression);
            newSwitchExpression.setExpression(newSwitchExpressionExpression);
            for (SwitchCaseSection switchCaseSection : this.cases) {
                List oldStatements = switchCaseSection.statements;
                SwitchCase switchCase = null;
                SwitchCase newSwitchCase = ast.newSwitchCase();
                newSwitchExpression.statements().add(newSwitchCase);
                newSwitchCase.setSwitchLabeledRule(true);
                switchCase = newSwitchCase;
                if (switchCaseSection.typePattern == null) {
                    NullLiteral nullExpression = ast.newNullLiteral();
                    CaseDefaultExpression defaultExpression = ast.newCaseDefaultExpression();
                    switchCase.expressions().add(nullExpression);
                    switchCase.expressions().add(defaultExpression);
                } else {
                    SingleVariableDeclaration svd;
                    VariableDeclaration variableDeclaration;
                    TypePattern oldExpression = switchCaseSection.typePattern;
                    Expression newExpression = (Expression)rewrite.createCopyTarget((ASTNode)oldExpression);
                    if (!switchCaseSection.isNameUsed && (variableDeclaration = switchCaseSection.typePattern.getPatternVariable2()) instanceof SingleVariableDeclaration && (svd = (SingleVariableDeclaration)variableDeclaration).getType().resolveBinding() != null) {
                        TypePattern newPattern = ast.newTypePattern();
                        SingleVariableDeclaration newDecl = ast.newSingleVariableDeclaration();
                        newDecl.setName(ast.newSimpleName("_"));
                        Type oldType = svd.getType();
                        ITypeBinding typeBinding = oldType.resolveBinding();
                        Type newType = importRewrite.addImport(typeBinding, ast);
                        newDecl.setType(newType);
                        newPattern.setPatternVariable((VariableDeclaration)newDecl);
                        newExpression = newPattern;
                    }
                    switchCase.expressions().add(newExpression);
                }
                if (oldStatements.size() == 1 && oldStatements.get(0) instanceof Block) {
                    oldStatements = ((Block)oldStatements.get(0)).statements();
                }
                if (oldStatements.size() == 1) {
                    Statement oldStatement = oldStatements.get(0);
                    Statement newStatement = null;
                    if (oldStatement instanceof ThrowStatement) {
                        ThrowStatement throwStatement = (ThrowStatement)oldStatement;
                        newStatement = (Statement)rewrite.createCopyTarget((ASTNode)throwStatement);
                    } else {
                        newStatement = oldStatement instanceof ReturnStatement && this.createReturnStatement ? SwitchExpressionsFixCore.SwitchExpressionsFixOperation.getNewStatementFromReturn(cuRewrite, rewrite, (ReturnStatement)oldStatement) : SwitchExpressionsFixCore.SwitchExpressionsFixOperation.getNewStatementForCase(cuRewrite, rewrite, oldStatement);
                    }
                    newSwitchExpression.statements().add(newStatement);
                    continue;
                }
                Block newBlock = ast.newBlock();
                int statementsLen = oldStatements.size();
                int i = 0;
                while (i < statementsLen - 1) {
                    Statement oldSwitchCaseStatement = (Statement)oldStatements.get(i);
                    newBlock.statements().add(rewrite.createCopyTarget((ASTNode)oldSwitchCaseStatement));
                    ++i;
                }
                Statement lastStatement = (Statement)oldStatements.get(statementsLen - 1);
                Statement newStatement = null;
                if (lastStatement instanceof ThrowStatement) {
                    ThrowStatement throwStatement = (ThrowStatement)lastStatement;
                    newStatement = (Statement)rewrite.createCopyTarget((ASTNode)throwStatement);
                } else {
                    newStatement = lastStatement instanceof ReturnStatement ? SwitchExpressionsFixCore.SwitchExpressionsFixOperation.getNewYieldStatementFromReturn(cuRewrite, rewrite, (ReturnStatement)oldStatements.get(statementsLen - 1)) : SwitchExpressionsFixCore.SwitchExpressionsFixOperation.getNewYieldStatement(cuRewrite, rewrite, (ExpressionStatement)oldStatements.get(statementsLen - 1));
                }
                newBlock.statements().add(newStatement);
                newSwitchExpression.statements().add(newBlock);
            }
            ReturnStatement newExpressionStatement = null;
            if (this.createReturnStatement) {
                ReturnStatement newReturnStatement = ast.newReturnStatement();
                newReturnStatement.setExpression((Expression)newSwitchExpression);
                newExpressionStatement = newReturnStatement;
            } else {
                if (this.assignmentBinding != null) {
                    ASTNode parent;
                    VariableDeclarationStatement varDeclarationStatement = null;
                    int varIndex = -2;
                    IVariableBinding binding = this.assignmentBinding;
                    if (!binding.isField() && !binding.isParameter() && !binding.isSynthetic() && (parent = this.ifStatements.get(0).getParent()) instanceof Block) {
                        Block block = (Block)parent;
                        List statements = block.statements();
                        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
                        int i = 0;
                        while (i < statements.size()) {
                            Statement statement = (Statement)statements.get(i);
                            if (statement instanceof VariableDeclarationStatement) {
                                IVariableBinding fragBinding;
                                VariableDeclarationFragment fragment;
                                VariableDeclarationStatement decl = (VariableDeclarationStatement)statement;
                                List fragments = decl.fragments();
                                if (fragments.size() == 1 && (fragment = (VariableDeclarationFragment)fragments.get(0)).getInitializer() == null && (fragBinding = fragment.resolveBinding()) != null && fragBinding.isEqualTo((IBinding)binding)) {
                                    varDeclarationStatement = decl;
                                    varIndex = i;
                                }
                            } else if (statement instanceof IfStatement && statement.subtreeMatch(new ASTMatcher(), (Object)this.ifStatements.get(0))) {
                                if (varIndex != i - 1) break;
                                VariableDeclarationFragment newVarFragment = ast.newVariableDeclarationFragment();
                                newVarFragment.setName(ast.newSimpleName(this.varName));
                                newVarFragment.setInitializer((Expression)newSwitchExpression);
                                VariableDeclarationStatement newVar = ast.newVariableDeclarationStatement(newVarFragment);
                                newVar.setType(importRewrite.addImport(this.assignmentBinding.getType(), ast));
                                if (varDeclarationStatement != null && Modifier.isFinal(varDeclarationStatement.getModifiers())) {
                                    newVar.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
                                }
                                SwitchExpressionsFixCore.SwitchExpressionsFixOperation.replaceWithLeadingComments(cuRewrite, listRewrite, (ASTNode)varDeclarationStatement, group, (ASTNode)newVar);
                                listRewrite.remove((ASTNode)this.ifStatements.get(0), group);
                                return;
                            }
                            ++i;
                        }
                    }
                }
                Assignment newAssignment = ast.newAssignment();
                newExpressionStatement = ast.newExpressionStatement((Expression)newAssignment);
                newAssignment.setLeftHandSide((Expression)ast.newName(this.varName));
                newAssignment.setRightHandSide((Expression)newSwitchExpression);
            }
            ASTNode parent = this.ifStatements.get(0).getParent();
            if (parent instanceof Block) {
                ListRewrite listRewrite = rewrite.getListRewrite(parent, Block.STATEMENTS_PROPERTY);
                SwitchExpressionsFixCore.SwitchExpressionsFixOperation.replaceWithLeadingComments(cuRewrite, listRewrite, (ASTNode)this.ifStatements.get(0), group, (ASTNode)newExpressionStatement);
            } else {
                rewrite.replace((ASTNode)this.ifStatements.get(0), (ASTNode)newExpressionStatement, group);
            }
            int i = 1;
            while (i < this.ifStatements.size()) {
                rewrite.remove((ASTNode)this.ifStatements.get(i), group);
                ++i;
            }
        }
    }

    public static class PatternToSwitchOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final List<IfStatement> ifStatements;
        private final Expression switchExpression;
        private final List<SwitchCaseSection> cases;
        private final Statement remainingStatement;

        public PatternToSwitchOperation(List<IfStatement> ifStatements, Expression switchExpression, List<SwitchCaseSection> cases, Statement remainingStatement) {
            this.ifStatements = ifStatements;
            this.switchExpression = switchExpression;
            this.cases = cases;
            this.remainingStatement = remainingStatement;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            SwitchStatement switchStatement;
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.CodeStyleCleanUp_PatternInstanceOfToSwitch_description, cuRewrite);
            rewrite.setTargetSourceRangeComputer(new TargetSourceRangeComputer(){

                public TargetSourceRangeComputer.SourceRange computeSourceRange(ASTNode nodeWithComment) {
                    if (Boolean.TRUE.equals(nodeWithComment.getProperty("untouchComment"))) {
                        return new TargetSourceRangeComputer.SourceRange(nodeWithComment.getStartPosition(), nodeWithComment.getLength());
                    }
                    return super.computeSourceRange(nodeWithComment);
                }
            });
            SwitchStatement newStatement = switchStatement = ast.newSwitchStatement();
            switchStatement.setExpression((Expression)rewrite.createCopyTarget((ASTNode)this.switchExpression));
            for (SwitchCaseSection aCase : this.cases) {
                this.addCaseWithStatements(rewrite, importRewrite, ast, switchStatement, aCase.typePattern, aCase.isNameUsed, aCase.statements);
            }
            if (this.remainingStatement != null) {
                this.remainingStatement.setProperty("untouchComment", (Object)Boolean.TRUE);
                this.addCaseWithStatements(rewrite, importRewrite, ast, switchStatement, null, false, ASTNodes.asList(this.remainingStatement));
            } else {
                this.addCaseWithStatements(rewrite, importRewrite, ast, switchStatement, null, false, Collections.emptyList());
            }
            int i = 0;
            while (i < this.ifStatements.size() - 1) {
                ASTNodes.removeButKeepComment(rewrite, (ASTNode)this.ifStatements.get(i), group);
                ++i;
            }
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.ifStatements.get(this.ifStatements.size() - 1), (ASTNode)newStatement, group);
        }

        private void addCaseWithStatements(ASTRewrite rewrite, ImportRewrite importRewrite, AST ast, SwitchStatement switchStatement, TypePattern caseValueOrNullForDefault, boolean isNameUsed, List<Statement> innerStatements) {
            boolean needBlock;
            List switchStatements = switchStatement.statements();
            boolean bl = needBlock = innerStatements.size() == 0 || innerStatements.size() > 1 || innerStatements.size() == 1 && !(innerStatements.get(0) instanceof ExpressionStatement) && !(innerStatements.get(0) instanceof ThrowStatement);
            if (caseValueOrNullForDefault != null) {
                TypePattern caseValue = caseValueOrNullForDefault;
                SwitchCase newSwitchCase = ast.newSwitchCase();
                newSwitchCase.setSwitchLabeledRule(true);
                if (isNameUsed) {
                    newSwitchCase.expressions().add(ASTNodes.createMoveTarget(rewrite, caseValue));
                } else {
                    SingleVariableDeclaration svd;
                    VariableDeclaration variableDeclaration = caseValueOrNullForDefault.getPatternVariable2();
                    if (variableDeclaration instanceof SingleVariableDeclaration && (svd = (SingleVariableDeclaration)variableDeclaration).getType().resolveBinding() != null) {
                        TypePattern newPattern = ast.newTypePattern();
                        SingleVariableDeclaration newDecl = ast.newSingleVariableDeclaration();
                        newDecl.setName(ast.newSimpleName("_"));
                        Type oldType = svd.getType();
                        ITypeBinding typeBinding = oldType.resolveBinding();
                        Type newType = importRewrite.addImport(typeBinding, ast);
                        newDecl.setType(newType);
                        newPattern.setPatternVariable((VariableDeclaration)newDecl);
                        newSwitchCase.expressions().add(newPattern);
                    } else {
                        newSwitchCase.expressions().add(ASTNodes.createMoveTarget(rewrite, caseValue));
                    }
                }
                switchStatements.add(newSwitchCase);
            } else {
                SwitchCase newSwitchCase = ast.newSwitchCase();
                newSwitchCase.setSwitchLabeledRule(true);
                newSwitchCase.expressions().add(ast.newNullLiteral());
                newSwitchCase.expressions().add(ast.newCaseDefaultExpression());
                switchStatements.add(newSwitchCase);
            }
            List statementsList = switchStatement.statements();
            Block block = null;
            if (needBlock) {
                block = ast.newBlock();
                statementsList = block.statements();
            }
            if (!innerStatements.isEmpty()) {
                for (Statement statement : innerStatements) {
                    statementsList.add((Statement)rewrite.createCopyTarget((ASTNode)statement));
                }
            }
            if (needBlock) {
                switchStatements.add(block);
            }
        }

        protected boolean getCoreOption(IJavaProject project, String key, boolean def) {
            String option = this.getCoreOption(project, key);
            if ("insert".equals(option)) {
                return true;
            }
            if ("do not insert".equals(option)) {
                return false;
            }
            return def;
        }

        protected String getCoreOption(IJavaProject project, String key) {
            if (project == null) {
                return JavaCore.getOption((String)key);
            }
            return project.getOption(key, true);
        }
    }

    private static final class SwitchCaseSection {
        private final List<Statement> statements;
        private final TypePattern typePattern;
        private final boolean isNameUsed;

        private SwitchCaseSection(TypePattern typePattern, boolean isNameUsed, List<Statement> statements) {
            this.typePattern = typePattern;
            this.isNameUsed = isNameUsed;
            this.statements = statements;
        }
    }

    public static final class SwitchStatementsFinder
    extends ASTVisitor {
        private List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> fResult;

        public SwitchStatementsFinder(List<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> ops) {
            this.fResult = ops;
        }

        public boolean visit(Block visited) {
            SeveralIfVisitor severalIfVisitor = new SeveralIfVisitor();
            visited.accept((ASTVisitor)severalIfVisitor);
            return false;
        }

        final class SeveralIfVisitor
        extends ASTVisitor {
            SeveralIfVisitor() {
            }

            public boolean visit(IfStatement visited) {
                TypeVariable variable = this.extractVariableAndValues((Statement)visited);
                if (variable == null) {
                    return true;
                }
                Expression switchExpression = variable.name;
                ArrayList<IfStatement> ifStatements = new ArrayList<IfStatement>();
                ArrayList<SwitchCaseSection> cases = new ArrayList<SwitchCaseSection>();
                Statement remainingStatement = null;
                IfStatement ifStatement = visited;
                boolean isFallingThrough = true;
                do {
                    IfStatement currentNode = ifStatement;
                    while (ASTNodes.isSameVariable((ASTNode)switchExpression, (ASTNode)variable.name)) {
                        cases.add(new SwitchCaseSection(variable.getTypePattern(), variable.isPatternNameUsed(), ASTNodes.asList(currentNode.getThenStatement())));
                        if (!ASTNodes.fallsThrough(currentNode.getThenStatement())) {
                            isFallingThrough = false;
                        }
                        if ((remainingStatement = currentNode.getElseStatement()) == null || (variable = this.extractVariableAndValues(remainingStatement)) == null) break;
                        currentNode = (IfStatement)remainingStatement;
                    }
                    ifStatements.add(ifStatement);
                    ifStatement = ASTNodes.as(ASTNodes.getNextSibling((Statement)ifStatement), IfStatement.class);
                    variable = this.extractVariableAndValues((Statement)ifStatement);
                } while (isFallingThrough && ifStatement != null && remainingStatement == null && variable != null && ASTNodes.isSameVariable((ASTNode)switchExpression, (ASTNode)variable.name));
                return this.maybeReplaceWithSwitchStatement(ifStatements, switchExpression, cases, remainingStatement);
            }

            private boolean maybeReplaceWithSwitchStatement(List<IfStatement> ifStatements, Expression switchExpression, List<SwitchCaseSection> cases, Statement remainingStatement) {
                if (switchExpression != null && cases.size() > 2) {
                    PatternToSwitchExpressionOperation op = this.getOperation(ifStatements, switchExpression, cases, remainingStatement);
                    if (op != null) {
                        SwitchStatementsFinder.this.fResult.add(op);
                    } else {
                        SwitchStatementsFinder.this.fResult.add(new PatternToSwitchOperation(ifStatements, switchExpression, cases, remainingStatement));
                    }
                    return false;
                }
                return true;
            }

            private boolean isInvalidStatement(Statement statement) {
                return statement instanceof ContinueStatement || statement instanceof ForStatement || statement instanceof IfStatement || statement instanceof DoStatement || statement instanceof EnhancedForStatement || statement instanceof SwitchStatement || statement instanceof YieldStatement || statement instanceof TryStatement || statement instanceof WhileStatement;
            }

            private PatternToSwitchExpressionOperation getOperation(List<IfStatement> ifStatements, Expression switchExpression, List<SwitchCaseSection> cases, Statement remainingStatement) {
                ArrayList<SwitchCaseSection> throwList = new ArrayList<SwitchCaseSection>();
                ArrayList<Assignment> assignmentList = new ArrayList<Assignment>();
                ArrayList<SwitchCaseSection> returnList = new ArrayList<SwitchCaseSection>();
                String assignmentName = null;
                IVariableBinding assignmentBinding = null;
                if (remainingStatement == null || ASTNodes.asList(remainingStatement).size() == 0) {
                    return null;
                }
                ArrayList<SwitchCaseSection> extendedCases = new ArrayList<SwitchCaseSection>(cases);
                SwitchCaseSection defaultSection = new SwitchCaseSection(null, false, ASTNodes.asList(remainingStatement));
                extendedCases.add(defaultSection);
                for (SwitchCaseSection switchCaseSection : extendedCases) {
                    boolean blockExit = false;
                    Iterator<Statement> stmtIterator = switchCaseSection.statements.iterator();
                    while (stmtIterator.hasNext()) {
                        ExpressionStatement expStmt;
                        Expression expression;
                        Statement statement = stmtIterator.next();
                        if (this.isInvalidStatement(statement)) {
                            return null;
                        }
                        if (statement instanceof ReturnStatement) {
                            if (((ReturnStatement)statement).getExpression() == null || stmtIterator.hasNext() || blockExit) {
                                return null;
                            }
                            blockExit = true;
                            returnList.add(switchCaseSection);
                            continue;
                        }
                        if (statement instanceof ThrowStatement) {
                            if (stmtIterator.hasNext() || blockExit) {
                                return null;
                            }
                            blockExit = true;
                            throwList.add(switchCaseSection);
                            continue;
                        }
                        if (statement instanceof ExpressionStatement && (expression = (expStmt = (ExpressionStatement)statement).getExpression()) instanceof Assignment) {
                            Name name;
                            IBinding binding;
                            Expression expression2;
                            Assignment assignment = (Assignment)expression;
                            if (blockExit) {
                                return null;
                            }
                            if (stmtIterator.hasNext() || !((expression2 = assignment.getLeftHandSide()) instanceof Name) || !((binding = (name = (Name)expression2).resolveBinding()) instanceof IVariableBinding)) continue;
                            IVariableBinding varBinding = (IVariableBinding)binding;
                            if (assignmentName != null && !varBinding.getName().equals(assignmentName)) continue;
                            assignmentName = varBinding.getName();
                            assignmentBinding = varBinding;
                            assignmentList.add(assignment);
                            continue;
                        }
                        if (blockExit) {
                            return null;
                        }
                        if (!(statement instanceof Block)) continue;
                        Block block = (Block)statement;
                        Iterator blockIter = block.statements().iterator();
                        while (blockIter.hasNext()) {
                            Name name;
                            IBinding binding;
                            Expression expression3;
                            ExpressionStatement expStmt2;
                            Expression expression4;
                            Statement blockStatement = (Statement)blockIter.next();
                            if (this.isInvalidStatement(blockStatement) || blockStatement instanceof Block) {
                                return null;
                            }
                            if (blockStatement instanceof ThrowStatement) {
                                if (blockIter.hasNext() || blockExit) {
                                    return null;
                                }
                                blockExit = true;
                                throwList.add(switchCaseSection);
                            }
                            if (blockStatement instanceof ReturnStatement) {
                                if (blockIter.hasNext() || blockExit) {
                                    return null;
                                }
                                blockExit = true;
                                returnList.add(switchCaseSection);
                            }
                            if (!(statement instanceof ExpressionStatement) || !((expression4 = (expStmt2 = (ExpressionStatement)statement).getExpression()) instanceof Assignment)) continue;
                            Assignment assignment = (Assignment)expression4;
                            if (blockExit) {
                                return null;
                            }
                            if (blockIter.hasNext() || stmtIterator.hasNext() || !((expression3 = assignment.getLeftHandSide()) instanceof Name) || !((binding = (name = (Name)expression3).resolveBinding()) instanceof IVariableBinding)) continue;
                            IVariableBinding varBinding = (IVariableBinding)binding;
                            if (assignmentName != null && !varBinding.getName().equals(assignmentName)) continue;
                            assignmentName = varBinding.getName();
                            assignmentList.add(assignment);
                        }
                    }
                }
                if (returnList.size() + throwList.size() == extendedCases.size()) {
                    return new PatternToSwitchExpressionOperation(ifStatements, switchExpression, extendedCases, true, null, null);
                }
                if (assignmentList.size() == extendedCases.size()) {
                    return new PatternToSwitchExpressionOperation(ifStatements, switchExpression, extendedCases, false, assignmentName, assignmentBinding);
                }
                return null;
            }

            private TypeVariable extractVariableAndValues(Statement statement) {
                if (statement instanceof IfStatement) {
                    IfStatement ifStmt = (IfStatement)statement;
                    TypeVariable result = this.extractVariableAndValues(((IfStatement)statement).getExpression());
                    if (result != null) {
                        CompilationUnit cu = (CompilationUnit)ifStmt.getRoot();
                        if (JavaModelUtil.is22OrHigher(cu.getJavaElement().getJavaProject())) {
                            TypePattern pattern = result.getTypePattern();
                            VariableDeclaration vd = pattern.getPatternVariable2();
                            SimpleName name = vd.getName();
                            IBinding binding = name.resolveBinding();
                            NameUsedVisitor visitor = new NameUsedVisitor(binding);
                            try {
                                ifStmt.getThenStatement().accept((ASTVisitor)visitor);
                                result.setPatternNameUsed(false);
                            }
                            catch (AbortSearchException e) {
                                result.setPatternNameUsed(true);
                            }
                        }
                        return result;
                    }
                }
                return null;
            }

            private TypeVariable extractVariableAndValues(Expression expression) {
                PatternInstanceofExpression pattern = ASTNodes.as(expression, PatternInstanceofExpression.class);
                if (pattern != null) {
                    return this.extractVariableAndValuesFromPatternExpression(pattern);
                }
                return null;
            }

            private TypeVariable extractVariableAndValuesFromPatternExpression(PatternInstanceofExpression pattern) {
                TypePattern typePattern = ASTNodes.as((Expression)pattern.getPattern(), TypePattern.class);
                if (typePattern != null) {
                    return new TypeVariable(pattern.getLeftOperand(), typePattern);
                }
                return null;
            }

            private class NameUsedVisitor
            extends ASTVisitor {
                private final IBinding nameBinding;

                public NameUsedVisitor(IBinding nameBinding) {
                    this.nameBinding = nameBinding;
                }

                public boolean visit(SimpleName node) {
                    IBinding nodeBinding = node.resolveBinding();
                    if (nodeBinding != null && nodeBinding.isEqualTo(this.nameBinding)) {
                        throw new AbortSearchException();
                    }
                    return false;
                }
            }
        }

        static final class TypeVariable {
            private final Expression name;
            private final TypePattern typePattern;
            private boolean patternNameUsed;

            private TypeVariable(Expression firstOp, TypePattern typePattern) {
                this(firstOp, typePattern, true);
            }

            private TypeVariable(Expression firstOp, TypePattern typePattern, boolean patternNameUsed) {
                this.name = firstOp;
                this.typePattern = typePattern;
                this.patternNameUsed = patternNameUsed;
            }

            public boolean isSameVariable(TypeVariable other) {
                return other != null && ASTNodes.isSameVariable((ASTNode)this.name, (ASTNode)other.name);
            }

            public TypePattern getTypePattern() {
                return this.typePattern;
            }

            public boolean isPatternNameUsed() {
                return this.patternNameUsed;
            }

            public void setPatternNameUsed(boolean value) {
                this.patternNameUsed = value;
            }
        }
    }
}

