/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.InvisibleProjectImporter;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.IPreferencesChangeListener;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;

public class InvisibleProjectPreferenceChangeListener
implements IPreferencesChangeListener {
    @Override
    public void preferencesChange(Preferences oldPreferences, Preferences newPreferences) {
        try {
            if (!Objects.equals(oldPreferences.getInvisibleProjectSourcePaths(), newPreferences.getInvisibleProjectSourcePaths())) {
                IJavaProject[] iJavaProjectArray = ProjectUtils.getJavaProjects();
                int n = iJavaProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFolder workspaceLinkFolder;
                    IPath rootPath;
                    IJavaProject javaProject = iJavaProjectArray[n2];
                    IProject project = javaProject.getProject();
                    if (!ProjectUtils.isVisibleProject(project) && !project.equals((Object)ProjectsManager.getDefaultProject()) && (rootPath = ProjectUtils.findBelongedWorkspaceRoot((workspaceLinkFolder = javaProject.getProject().getFolder("_")).getLocation())) != null) {
                        List<IPath> sourcePaths = InvisibleProjectImporter.getSourcePaths(newPreferences.getInvisibleProjectSourcePaths(), workspaceLinkFolder);
                        List<IPath> excludingPaths = InvisibleProjectImporter.getExcludingPath(javaProject, rootPath, workspaceLinkFolder);
                        IPath outputPath = InvisibleProjectImporter.getOutputPath(javaProject, newPreferences.getInvisibleProjectOutputPath(), true);
                        IClasspathEntry[] classpathEntries = InvisibleProjectImporter.resolveClassPathEntries(javaProject, sourcePaths, excludingPaths, outputPath);
                        javaProject.setRawClasspath(classpathEntries, outputPath, (IProgressMonitor)new NullProgressMonitor());
                        ProjectUtils.refreshDiagnostics((IProgressMonitor)new NullProgressMonitor());
                    }
                    ++n2;
                }
            } else if (!Objects.equals(oldPreferences.getInvisibleProjectOutputPath(), newPreferences.getInvisibleProjectOutputPath())) {
                IJavaProject[] iJavaProjectArray = ProjectUtils.getJavaProjects();
                int n = iJavaProjectArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IJavaProject javaProject = iJavaProjectArray[n3];
                    IProject project = javaProject.getProject();
                    if (!ProjectUtils.isVisibleProject(project) && !project.equals((Object)ProjectsManager.getDefaultProject())) {
                        IPath outputPath = InvisibleProjectImporter.getOutputPath(javaProject, newPreferences.getInvisibleProjectOutputPath(), true);
                        javaProject.setOutputLocation(outputPath, (IProgressMonitor)new NullProgressMonitor());
                    }
                    ++n3;
                }
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.getProjectsManager().getConnection().showMessage(new MessageParams(MessageType.Error, e.getMessage()));
        }
    }
}

