"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_test_lib_browser_test-execution-progress-service_js"],{

/***/ "../../node_modules/@theia/test/lib/browser/test-execution-progress-service.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@theia/test/lib/browser/test-execution-progress-service.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 STMicroelectronics and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DefaultTestExecutionProgressService = exports.TestExecutionProgressService = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const test_result_view_contribution_1 = __webpack_require__(/*! ./view/test-result-view-contribution */ "../../node_modules/@theia/test/lib/browser/view/test-result-view-contribution.js");
const test_view_contribution_1 = __webpack_require__(/*! ./view/test-view-contribution */ "../../node_modules/@theia/test/lib/browser/view/test-view-contribution.js");
const test_preferences_1 = __webpack_require__(/*! ./test-preferences */ "../../node_modules/@theia/test/lib/browser/test-preferences.js");
exports.TestExecutionProgressService = Symbol('TestExecutionProgressService');
let DefaultTestExecutionProgressService = class DefaultTestExecutionProgressService {
    async onTestRunRequested(preserveFocus) {
        if (!preserveFocus) {
            const openTesting = this.testPreferences['testing.openTesting'];
            if (openTesting === 'openOnTestStart') {
                this.openTestResultView();
            }
        }
    }
    async openTestResultView() {
        return this.testResultView.openView({ activate: true });
    }
};
exports.DefaultTestExecutionProgressService = DefaultTestExecutionProgressService;
tslib_1.__decorate([
    (0, inversify_1.inject)(test_result_view_contribution_1.TestResultViewContribution),
    tslib_1.__metadata("design:type", test_result_view_contribution_1.TestResultViewContribution)
], DefaultTestExecutionProgressService.prototype, "testResultView", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(test_view_contribution_1.TestViewContribution),
    tslib_1.__metadata("design:type", test_view_contribution_1.TestViewContribution)
], DefaultTestExecutionProgressService.prototype, "testView", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(test_preferences_1.TestPreferences),
    tslib_1.__metadata("design:type", Object)
], DefaultTestExecutionProgressService.prototype, "testPreferences", void 0);
exports.DefaultTestExecutionProgressService = DefaultTestExecutionProgressService = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], DefaultTestExecutionProgressService);


/***/ }),

/***/ "../../node_modules/@theia/test/lib/browser/test-preferences.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@theia/test/lib/browser/test-preferences.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 STMicroelectronics and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.bindTestPreferences = exports.createTestPreferences = exports.TestPreferences = exports.TestPreferenceContribution = exports.TestConfigSchema = void 0;
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const nls_1 = __webpack_require__(/*! @theia/core/lib/common/nls */ "../../node_modules/@theia/core/lib/common/nls.js");
exports.TestConfigSchema = {
    type: 'object',
    properties: {
        'testing.openTesting': {
            type: 'string',
            enum: ['neverOpen', 'openOnTestStart'],
            enumDescriptions: [
                nls_1.nls.localizeByDefault('Never automatically open the testing views'),
                nls_1.nls.localizeByDefault('Open the test results view when tests start'),
            ],
            description: nls_1.nls.localizeByDefault('Controls when the testing view should open.'),
            default: 'neverOpen',
            scope: 'resource',
        }
    }
};
exports.TestPreferenceContribution = Symbol('TestPreferenceContribution');
exports.TestPreferences = Symbol('TestPreferences');
function createTestPreferences(preferences, schema = exports.TestConfigSchema) {
    return (0, browser_1.createPreferenceProxy)(preferences, schema);
}
exports.createTestPreferences = createTestPreferences;
const bindTestPreferences = (bind) => {
    bind(exports.TestPreferences).toDynamicValue(ctx => {
        const preferences = ctx.container.get(browser_1.PreferenceService);
        const contribution = ctx.container.get(exports.TestPreferenceContribution);
        return createTestPreferences(preferences, contribution.schema);
    }).inSingletonScope();
    bind(exports.TestPreferenceContribution).toConstantValue({ schema: exports.TestConfigSchema });
    bind(browser_1.PreferenceContribution).toService(exports.TestPreferenceContribution);
};
exports.bindTestPreferences = bindTestPreferences;


/***/ }),

/***/ "../../node_modules/@theia/test/lib/browser/view/test-result-view-contribution.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/test/lib/browser/view/test-result-view-contribution.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 STMicroelectronics and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TestResultViewContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const test_result_widget_1 = __webpack_require__(/*! ./test-result-widget */ "../../node_modules/@theia/test/lib/browser/view/test-result-widget.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
let TestResultViewContribution = class TestResultViewContribution extends browser_1.AbstractViewContribution {
    constructor() {
        super({
            widgetId: test_result_widget_1.TestResultWidget.ID,
            widgetName: core_1.nls.localizeByDefault('Test Results'),
            defaultWidgetOptions: {
                area: 'bottom'
            }
        });
    }
};
exports.TestResultViewContribution = TestResultViewContribution;
exports.TestResultViewContribution = TestResultViewContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__metadata("design:paramtypes", [])
], TestResultViewContribution);


/***/ }),

/***/ "../../node_modules/@theia/test/lib/browser/view/test-result-widget.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@theia/test/lib/browser/view/test-result-widget.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2023 STMicroelectronics and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var TestResultWidget_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TestResultWidget = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const test_output_ui_model_1 = __webpack_require__(/*! ./test-output-ui-model */ "../../node_modules/@theia/test/lib/browser/view/test-output-ui-model.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const test_service_1 = __webpack_require__(/*! ../test-service */ "../../node_modules/@theia/test/lib/browser/test-service.js");
const markdown_renderer_1 = __webpack_require__(/*! @theia/core/lib/browser/markdown-rendering/markdown-renderer */ "../../node_modules/@theia/core/lib/browser/markdown-rendering/markdown-renderer.js");
const markdown_rendering_1 = __webpack_require__(/*! @theia/core/lib/common/markdown-rendering */ "../../node_modules/@theia/core/lib/common/markdown-rendering/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const navigation_location_service_1 = __webpack_require__(/*! @theia/editor/lib/browser/navigation/navigation-location-service */ "../../node_modules/@theia/editor/lib/browser/navigation/navigation-location-service.js");
const navigation_location_1 = __webpack_require__(/*! @theia/editor/lib/browser/navigation/navigation-location */ "../../node_modules/@theia/editor/lib/browser/navigation/navigation-location.js");
let TestResultWidget = TestResultWidget_1 = class TestResultWidget extends browser_1.BaseWidget {
    constructor() {
        super();
        this.toDisposeOnRender = new core_1.DisposableCollection();
        this.input = [];
        this.addClass('theia-test-result-view');
        this.id = TestResultWidget_1.ID;
        this.title.label = core_1.nls.localizeByDefault('Test Results');
        this.title.caption = core_1.nls.localizeByDefault('Test Results');
        this.title.iconClass = (0, browser_1.codicon)('checklist');
        this.title.closable = true;
        this.scrollOptions = {
            minScrollbarLength: 35,
        };
    }
    init() {
        this.uiModel.onDidChangeSelectedTestState(e => {
            if (test_service_1.TestFailure.is(e)) {
                this.setInput(e.messages);
            }
        });
    }
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        this.content = this.node.ownerDocument.createElement('div');
        this.node.append(this.content);
    }
    setInput(messages) {
        this.input = messages;
        this.update();
    }
    onUpdateRequest(msg) {
        this.render();
        super.onUpdateRequest(msg);
    }
    render() {
        this.toDisposeOnRender.dispose();
        this.toDisposeOnRender = new core_1.DisposableCollection();
        this.content.innerHTML = '';
        this.input.forEach(message => {
            if (markdown_rendering_1.MarkdownString.is(message.message)) {
                const line = this.markdownRenderer.render(message.message);
                this.content.append(line.element);
                this.toDisposeOnRender.push(line);
            }
            else {
                this.content.append(this.node.ownerDocument.createTextNode(message.message));
            }
            if (message.stackTrace) {
                const stackTraceElement = this.node.ownerDocument.createElement('div');
                message.stackTrace.map(frame => this.renderFrame(frame, stackTraceElement));
                this.content.append(stackTraceElement);
            }
        });
    }
    renderFrame(stackFrame, stackTraceElement) {
        const frameElement = stackTraceElement.ownerDocument.createElement('div');
        frameElement.classList.add('debug-frame');
        frameElement.append(`    ${core_1.nls.localize('theia/test/stackFrameAt', 'at')} ${stackFrame.label}`);
        // Add URI information as clickable links
        if (stackFrame.uri) {
            frameElement.append(' (');
            const uri = new uri_1.URI(stackFrame.uri);
            const link = this.node.ownerDocument.createElement('a');
            let content = `${this.labelProvider.getName(uri)}`;
            if (stackFrame.position) {
                // Display Position as a 1-based position, similar to Monaco ones.
                const monacoPosition = {
                    lineNumber: stackFrame.position.line + 1,
                    column: stackFrame.position.character + 1
                };
                content += `:${monacoPosition.lineNumber}:${monacoPosition.column}`;
            }
            link.textContent = content;
            link.href = `${uri}`;
            link.onclick = () => this.openUriInWorkspace(uri, stackFrame.position);
            frameElement.append(link);
            frameElement.append(')');
        }
        stackTraceElement.append(frameElement);
    }
    async openUriInWorkspace(uri, position) {
        this.fileService.resolve(uri).then(stat => {
            if (stat.isFile) {
                this.navigationService.reveal(navigation_location_1.NavigationLocation.create(uri, position !== null && position !== void 0 ? position : { line: 0, character: 0 }));
            }
        });
    }
    dispose() {
        this.toDisposeOnRender.dispose();
    }
};
exports.TestResultWidget = TestResultWidget;
TestResultWidget.ID = 'test-result-widget';
tslib_1.__decorate([
    (0, inversify_1.inject)(test_output_ui_model_1.TestOutputUIModel),
    tslib_1.__metadata("design:type", test_output_ui_model_1.TestOutputUIModel)
], TestResultWidget.prototype, "uiModel", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(markdown_renderer_1.MarkdownRenderer),
    tslib_1.__metadata("design:type", Object)
], TestResultWidget.prototype, "markdownRenderer", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], TestResultWidget.prototype, "openerService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], TestResultWidget.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(navigation_location_service_1.NavigationLocationService),
    tslib_1.__metadata("design:type", navigation_location_service_1.NavigationLocationService)
], TestResultWidget.prototype, "navigationService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.LabelProvider),
    tslib_1.__metadata("design:type", browser_1.LabelProvider)
], TestResultWidget.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.postConstruct)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TestResultWidget.prototype, "init", null);
exports.TestResultWidget = TestResultWidget = TestResultWidget_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)(),
    tslib_1.__metadata("design:paramtypes", [])
], TestResultWidget);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_test_lib_browser_test-execution-progress-service_js.js.map