"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_callhierarchy_lib_browser_index_js-node_modules_theia_plugin-ext_l-68477f"],{

/***/ "../../node_modules/@theia/callhierarchy/lib/browser/index.js":
/*!********************************************************************!*\
  !*** ../../node_modules/@theia/callhierarchy/lib/browser/index.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2018 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
tslib_1.__exportStar(__webpack_require__(/*! ./callhierarchy */ "../../node_modules/@theia/callhierarchy/lib/browser/callhierarchy.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./callhierarchy-contribution */ "../../node_modules/@theia/callhierarchy/lib/browser/callhierarchy-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./callhierarchy-frontend-module */ "../../node_modules/@theia/callhierarchy/lib/browser/callhierarchy-frontend-module.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./callhierarchy-service */ "../../node_modules/@theia/callhierarchy/lib/browser/callhierarchy-service.js"), exports);


/***/ }),

/***/ "../../node_modules/@theia/plugin-ext/lib/main/browser/comments/comment-glyph-widget.js":
/*!**********************************************************************************************!*\
  !*** ../../node_modules/@theia/plugin-ext/lib/main/browser/comments/comment-glyph-widget.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CommentGlyphWidget = void 0;
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// some code copied and modified from https://github.com/microsoft/vscode/blob/1.49.3/src/vs/workbench/contrib/comments/browser/commentGlyphWidget.ts
class CommentGlyphWidget {
    constructor(editor) {
        this.commentsDecorations = [];
        this.commentsOptions = {
            isWholeLine: true,
            linesDecorationsClassName: 'comment-range-glyph comment-thread'
        };
        this.editor = editor;
    }
    getPosition() {
        const model = this.editor.getModel();
        const range = model && this.commentsDecorations && this.commentsDecorations.length
            ? model.getDecorationRange(this.commentsDecorations[0])
            : null;
        return range ? range.startLineNumber : this.lineNumber;
    }
    setLineNumber(lineNumber) {
        this.lineNumber = lineNumber;
        const commentsDecorations = [{
                range: {
                    startLineNumber: lineNumber, startColumn: 1,
                    endLineNumber: lineNumber, endColumn: 1
                },
                options: this.commentsOptions
            }];
        this.commentsDecorations = this.editor.deltaDecorations(this.commentsDecorations, commentsDecorations);
    }
    dispose() {
        if (this.commentsDecorations) {
            this.editor.deltaDecorations(this.commentsDecorations, []);
        }
    }
}
exports.CommentGlyphWidget = CommentGlyphWidget;


/***/ }),

/***/ "../../node_modules/@theia/plugin-ext/lib/main/browser/comments/comment-thread-widget.js":
/*!***********************************************************************************************!*\
  !*** ../../node_modules/@theia/plugin-ext/lib/main/browser/comments/comment-thread-widget.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CommentAction = exports.CommentActions = exports.CommentsInlineAction = exports.CommentEditContainer = exports.CommentBody = exports.ReviewComment = exports.CommentForm = exports.CommentThreadWidget = exports.COMMENT_TITLE = exports.COMMENT_CONTEXT = exports.COMMENT_THREAD_CONTEXT = void 0;
// *****************************************************************************
// Copyright (C) 2020 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const monaco_editor_zone_widget_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-editor-zone-widget */ "../../node_modules/@theia/monaco/lib/browser/monaco-editor-zone-widget.js");
const plugin_api_rpc_model_1 = __webpack_require__(/*! ../../../common/plugin-api-rpc-model */ "../../node_modules/@theia/plugin-ext/lib/common/plugin-api-rpc-model.js");
const comment_glyph_widget_1 = __webpack_require__(/*! ./comment-glyph-widget */ "../../node_modules/@theia/plugin-ext/lib/main/browser/comments/comment-glyph-widget.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const React = __webpack_require__(/*! @theia/core/shared/react */ "../../node_modules/@theia/core/shared/react/index.js");
const browser_2 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
const client_1 = __webpack_require__(/*! @theia/core/shared/react-dom/client */ "../../node_modules/@theia/core/shared/react-dom/client/index.js");
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// some code copied and modified from https://github.com/microsoft/vscode/blob/1.49.3/src/vs/workbench/contrib/comments/browser/commentThreadWidget.ts
exports.COMMENT_THREAD_CONTEXT = ['comment_thread-context-menu'];
exports.COMMENT_CONTEXT = ['comment-context-menu'];
exports.COMMENT_TITLE = ['comment-title-menu'];
class CommentThreadWidget extends browser_1.BaseWidget {
    constructor(editor, _owner, _commentThread, commentService, menus, contextKeyService, commands) {
        super();
        this._owner = _owner;
        this._commentThread = _commentThread;
        this.commentService = commentService;
        this.menus = menus;
        this.contextKeyService = contextKeyService;
        this.commands = commands;
        this.commentFormRef = React.createRef();
        this.toDispose.push(this.zoneWidget = new monaco_editor_zone_widget_1.MonacoEditorZoneWidget(editor));
        this.containerNodeRoot = (0, client_1.createRoot)(this.zoneWidget.containerNode);
        this.toDispose.push(this.commentGlyphWidget = new comment_glyph_widget_1.CommentGlyphWidget(editor));
        this.toDispose.push(this._commentThread.onDidChangeCollapsibleState(state => {
            var _a, _b;
            if (state === plugin_api_rpc_model_1.CommentThreadCollapsibleState.Expanded && !this.isExpanded) {
                const lineNumber = (_b = (_a = this._commentThread.range) === null || _a === void 0 ? void 0 : _a.startLineNumber) !== null && _b !== void 0 ? _b : 0;
                this.display({ afterLineNumber: lineNumber, afterColumn: 1, heightInLines: 2 });
                return;
            }
            if (state === plugin_api_rpc_model_1.CommentThreadCollapsibleState.Collapsed && this.isExpanded) {
                this.hide();
                return;
            }
        }));
        this.contextKeyService.commentIsEmpty.set(true);
        this.toDispose.push(this.zoneWidget.editor.onMouseDown(e => this.onEditorMouseDown(e)));
        this.toDispose.push(this.contextKeyService.onDidChange(() => {
            const commentForm = this.commentFormRef.current;
            if (commentForm) {
                commentForm.update();
            }
        }));
        this.toDispose.push(this._commentThread.onDidChangeCanReply(_canReply => {
            const commentForm = this.commentFormRef.current;
            if (commentForm) {
                commentForm.update();
            }
        }));
        this.toDispose.push(this._commentThread.onDidChangeState(_state => {
            this.update();
        }));
        this.contextMenu = this.menus.getMenu(exports.COMMENT_THREAD_CONTEXT);
        this.contextMenu.children.map(node => node instanceof common_1.ActionMenuNode && node.when).forEach(exp => {
            if (typeof exp === 'string') {
                this.contextKeyService.setExpression(exp);
            }
        });
    }
    getGlyphPosition() {
        return this.commentGlyphWidget.getPosition();
    }
    collapse() {
        this._commentThread.collapsibleState = plugin_api_rpc_model_1.CommentThreadCollapsibleState.Collapsed;
        if (this._commentThread.comments && this._commentThread.comments.length === 0) {
            this.deleteCommentThread();
        }
        this.hide();
    }
    deleteCommentThread() {
        this.dispose();
        this.commentService.disposeCommentThread(this.owner, this._commentThread.threadId);
    }
    dispose() {
        super.dispose();
        if (this.commentGlyphWidget) {
            this.commentGlyphWidget.dispose();
        }
    }
    toggleExpand(lineNumber) {
        if (this.isExpanded) {
            this._commentThread.collapsibleState = plugin_api_rpc_model_1.CommentThreadCollapsibleState.Collapsed;
            this.hide();
            if (!this._commentThread.comments || !this._commentThread.comments.length) {
                this.deleteCommentThread();
            }
        }
        else {
            this._commentThread.collapsibleState = plugin_api_rpc_model_1.CommentThreadCollapsibleState.Expanded;
            this.display({ afterLineNumber: lineNumber, afterColumn: 1, heightInLines: 2 });
        }
    }
    hide() {
        this.zoneWidget.hide();
        this.isExpanded = false;
        super.hide();
    }
    display(options) {
        this.isExpanded = true;
        if (this._commentThread.collapsibleState && this._commentThread.collapsibleState !== plugin_api_rpc_model_1.CommentThreadCollapsibleState.Expanded) {
            return;
        }
        this.commentGlyphWidget.setLineNumber(options.afterLineNumber);
        this._commentThread.collapsibleState = plugin_api_rpc_model_1.CommentThreadCollapsibleState.Expanded;
        this.zoneWidget.show(options);
        this.update();
    }
    onEditorMouseDown(e) {
        const range = e.target.range;
        if (!range) {
            return;
        }
        if (!e.event.leftButton) {
            return;
        }
        if (e.target.type !== browser_2.MouseTargetType.GUTTER_LINE_DECORATIONS) {
            return;
        }
        const data = e.target.detail;
        const gutterOffsetX = data.offsetX - data.glyphMarginWidth - data.lineNumbersWidth - data.glyphMarginLeft;
        // don't collide with folding and git decorations
        if (gutterOffsetX > 14) {
            return;
        }
        const mouseDownInfo = { lineNumber: range.startLineNumber };
        const { lineNumber } = mouseDownInfo;
        if (!range || range.startLineNumber !== lineNumber) {
            return;
        }
        if (e.target.type !== browser_2.MouseTargetType.GUTTER_LINE_DECORATIONS) {
            return;
        }
        if (!e.target.element) {
            return;
        }
        if (this.commentGlyphWidget && this.commentGlyphWidget.getPosition() !== lineNumber) {
            return;
        }
        if (e.target.element.className.indexOf('comment-thread') >= 0) {
            this.toggleExpand(lineNumber);
            return;
        }
        if (this._commentThread.collapsibleState === plugin_api_rpc_model_1.CommentThreadCollapsibleState.Collapsed) {
            this.display({ afterLineNumber: mouseDownInfo.lineNumber, heightInLines: 2 });
        }
        else {
            this.hide();
        }
    }
    get owner() {
        return this._owner;
    }
    get commentThread() {
        return this._commentThread;
    }
    getThreadLabel() {
        let label;
        label = this._commentThread.label;
        if (label === undefined) {
            if (this._commentThread.comments && this._commentThread.comments.length) {
                const onlyUnique = (value, index, self) => self.indexOf(value) === index;
                const participantsList = this._commentThread.comments.filter(onlyUnique).map(comment => `@${comment.userName}`).join(', ');
                const resolutionState = this._commentThread.state === plugin_api_rpc_model_1.CommentThreadState.Resolved ? '(Resolved)' : '(Unresolved)';
                label = `Participants: ${participantsList} ${resolutionState}`;
            }
            else {
                label = 'Start discussion';
            }
        }
        return label;
    }
    update() {
        var _a, _b, _c;
        if (!this.isExpanded) {
            return;
        }
        this.render();
        const headHeight = Math.ceil(this.zoneWidget.editor.getOption(monaco.editor.EditorOption.lineHeight) * 1.2);
        const lineHeight = this.zoneWidget.editor.getOption(monaco.editor.EditorOption.lineHeight);
        const arrowHeight = Math.round(lineHeight / 3);
        const frameThickness = Math.round(lineHeight / 9) * 2;
        const body = this.zoneWidget.containerNode.getElementsByClassName('body')[0];
        const computedLinesNumber = Math.ceil((headHeight + ((_a = body === null || body === void 0 ? void 0 : body.clientHeight) !== null && _a !== void 0 ? _a : 0) + arrowHeight + frameThickness + 8 /** margin bottom to avoid margin collapse */)
            / lineHeight);
        this.zoneWidget.show({ afterLineNumber: (_c = (_b = this._commentThread.range) === null || _b === void 0 ? void 0 : _b.startLineNumber) !== null && _c !== void 0 ? _c : 0, heightInLines: computedLinesNumber });
    }
    render() {
        var _a;
        const headHeight = Math.ceil(this.zoneWidget.editor.getOption(monaco.editor.EditorOption.lineHeight) * 1.2);
        this.containerNodeRoot.render(React.createElement("div", { className: 'review-widget' },
            React.createElement("div", { className: 'head', style: { height: headHeight, lineHeight: `${headHeight}px` } },
                React.createElement("div", { className: 'review-title' },
                    React.createElement("span", { className: 'filename' }, this.getThreadLabel())),
                React.createElement("div", { className: 'review-actions' },
                    React.createElement("div", { className: 'monaco-action-bar animated' },
                        React.createElement("ul", { className: 'actions-container', role: 'toolbar' },
                            React.createElement("li", { className: 'action-item', role: 'presentation' },
                                React.createElement("a", { className: 'action-label codicon expand-review-action codicon-chevron-up', role: 'button', tabIndex: 0, title: 'Collapse', onClick: () => this.collapse() })))))),
            React.createElement("div", { className: 'body' },
                React.createElement("div", { className: 'comments-container', role: 'presentation', tabIndex: 0 }, (_a = this._commentThread.comments) === null || _a === void 0 ? void 0 : _a.map((comment, index) => React.createElement(ReviewComment, { key: index, contextKeyService: this.contextKeyService, menus: this.menus, comment: comment, commentForm: this.commentFormRef, commands: this.commands, commentThread: this._commentThread }))),
                React.createElement(CommentForm, { contextKeyService: this.contextKeyService, commands: this.commands, commentThread: this._commentThread, menus: this.menus, widget: this, ref: this.commentFormRef }))));
    }
}
exports.CommentThreadWidget = CommentThreadWidget;
class CommentForm extends React.Component {
    update() {
        this.setState(this.state);
    }
    componentDidMount() {
        // Wait for the widget to be rendered.
        setTimeout(() => {
            var _a;
            (_a = this.inputRef.current) === null || _a === void 0 ? void 0 : _a.focus();
        }, 100);
    }
    constructor(props) {
        super(props);
        this.inputRef = React.createRef();
        this.inputValue = '';
        this.getInput = () => this.inputValue;
        this.clearInput = () => {
            const input = this.inputRef.current;
            if (input) {
                this.inputValue = '';
                input.value = this.inputValue;
                this.props.contextKeyService.commentIsEmpty.set(true);
            }
        };
        this.expand = () => {
            this.setState({ expanded: true });
            // Wait for the widget to be rendered.
            setTimeout(() => {
                var _a;
                // Update the widget's height.
                this.props.widget.update();
                (_a = this.inputRef.current) === null || _a === void 0 ? void 0 : _a.focus();
            }, 100);
        };
        this.collapse = () => {
            this.setState({ expanded: false });
            // Wait for the widget to be rendered.
            setTimeout(() => {
                // Update the widget's height.
                this.props.widget.update();
            }, 100);
        };
        this.onInput = (event) => {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            const value = event.target.value;
            if (this.inputValue.length === 0 || value.length === 0) {
                this.props.contextKeyService.commentIsEmpty.set(value.length === 0);
            }
            this.inputValue = value;
        };
        this.state = {
            expanded: false
        };
        const setState = this.setState.bind(this);
        this.setState = newState => {
            setState(newState);
        };
        this.menu = this.props.menus.getMenu(exports.COMMENT_THREAD_CONTEXT);
        this.menu.children.map(node => node instanceof common_1.ActionMenuNode && node.when).forEach(exp => {
            if (typeof exp === 'string') {
                this.props.contextKeyService.setExpression(exp);
            }
        });
    }
    render() {
        const { commands, commentThread, contextKeyService } = this.props;
        const hasExistingComments = commentThread.comments && commentThread.comments.length > 0;
        return commentThread.canReply ? React.createElement("div", { className: 'comment-form' + (this.state.expanded || commentThread.comments && commentThread.comments.length === 0 ? ' expand' : '') },
            React.createElement("div", { className: 'theia-comments-input-message-container' },
                React.createElement("textarea", { className: 'theia-comments-input-message theia-input', spellCheck: false, placeholder: hasExistingComments ? 'Reply...' : 'Type a new comment', onInput: this.onInput, 
                    // eslint-disable-next-line @typescript-eslint/no-explicit-any
                    onBlur: (event) => {
                        if (event.target.value.length > 0) {
                            return;
                        }
                        if (event.relatedTarget && event.relatedTarget.className === 'comments-button comments-text-button theia-button') {
                            this.state = { expanded: false };
                            return;
                        }
                        this.collapse();
                    }, ref: this.inputRef })),
            React.createElement(CommentActions, { menu: this.menu, contextKeyService: contextKeyService, commands: commands, commentThread: commentThread, getInput: this.getInput, clearInput: this.clearInput }),
            React.createElement("button", { className: 'review-thread-reply-button', title: 'Reply...', onClick: this.expand }, "Reply...")) : null;
    }
}
exports.CommentForm = CommentForm;
class ReviewComment extends React.Component {
    constructor(props) {
        super(props);
        this.detectHover = (element) => {
            if (element) {
                window.requestAnimationFrame(() => {
                    const hover = element.matches(':hover');
                    this.setState({ hover });
                });
            }
        };
        this.showHover = () => this.setState({ hover: true });
        this.hideHover = () => this.setState({ hover: false });
        this.state = {
            hover: false
        };
        const setState = this.setState.bind(this);
        this.setState = newState => {
            setState(newState);
        };
    }
    render() {
        const { comment, commentForm, contextKeyService, menus, commands, commentThread } = this.props;
        const commentUniqueId = comment.uniqueIdInThread;
        const { hover } = this.state;
        contextKeyService.comment.set(comment.contextValue);
        return React.createElement("div", { className: 'review-comment', tabIndex: -1, "aria-label": `${comment.userName}, ${comment.body.value}`, ref: this.detectHover, onMouseEnter: this.showHover, onMouseLeave: this.hideHover },
            React.createElement("div", { className: 'avatar-container' },
                React.createElement("img", { className: 'avatar', src: comment.userIconPath })),
            React.createElement("div", { className: 'review-comment-contents' },
                React.createElement("div", { className: 'comment-title monaco-mouse-cursor-text' },
                    React.createElement("strong", { className: 'author' }, comment.userName),
                    React.createElement("small", { className: 'timestamp' }, this.localeDate(comment.timestamp)),
                    React.createElement("span", { className: 'isPending' }, comment.label),
                    React.createElement("div", { className: 'theia-comments-inline-actions-container' },
                        React.createElement("div", { className: 'theia-comments-inline-actions', role: 'toolbar' }, hover && menus.getMenu(exports.COMMENT_TITLE).children.map((node, index) => node instanceof common_1.ActionMenuNode &&
                            React.createElement(CommentsInlineAction, { key: index, node, commands, commentThread, commentUniqueId, contextKeyService }))))),
                React.createElement(CommentBody, { value: comment.body.value, isVisible: comment.mode === undefined || comment.mode === plugin_api_rpc_model_1.CommentMode.Preview }),
                React.createElement(CommentEditContainer, { contextKeyService: contextKeyService, menus: menus, comment: comment, commentThread: commentThread, commentForm: commentForm, commands: commands })));
    }
    localeDate(timestamp) {
        if (timestamp === undefined) {
            return '';
        }
        const date = new Date(timestamp);
        if (!isNaN(date.getTime())) {
            return date.toLocaleString();
        }
        return '';
    }
}
exports.ReviewComment = ReviewComment;
class CommentBody extends React.Component {
    render() {
        const { value, isVisible } = this.props;
        if (!isVisible) {
            return false;
        }
        return React.createElement("div", { className: 'comment-body monaco-mouse-cursor-text' },
            React.createElement("div", null,
                React.createElement("p", null, value)));
    }
}
exports.CommentBody = CommentBody;
class CommentEditContainer extends React.Component {
    constructor() {
        super(...arguments);
        this.inputRef = React.createRef();
    }
    componentDidUpdate(prevProps, prevState) {
        var _a;
        const commentFormState = (_a = this.props.commentForm.current) === null || _a === void 0 ? void 0 : _a.state;
        const mode = this.props.comment.mode;
        if (this.dirtyCommentMode !== mode || (this.dirtyCommentFormState !== (commentFormState === null || commentFormState === void 0 ? void 0 : commentFormState.expanded) && !(commentFormState === null || commentFormState === void 0 ? void 0 : commentFormState.expanded))) {
            const currentInput = this.inputRef.current;
            if (currentInput) {
                // Wait for the widget to be rendered.
                setTimeout(() => {
                    currentInput.focus();
                    currentInput.setSelectionRange(currentInput.value.length, currentInput.value.length);
                }, 50);
            }
        }
        this.dirtyCommentMode = mode;
        this.dirtyCommentFormState = commentFormState === null || commentFormState === void 0 ? void 0 : commentFormState.expanded;
    }
    render() {
        const { menus, comment, commands, commentThread, contextKeyService } = this.props;
        if (!(comment.mode === plugin_api_rpc_model_1.CommentMode.Editing)) {
            return false;
        }
        return React.createElement("div", { className: 'edit-container' },
            React.createElement("div", { className: 'edit-textarea' },
                React.createElement("div", { className: 'theia-comments-input-message-container' },
                    React.createElement("textarea", { className: 'theia-comments-input-message theia-input', spellCheck: false, defaultValue: comment.body.value, ref: this.inputRef }))),
            React.createElement("div", { className: 'form-actions' }, menus.getMenu(exports.COMMENT_CONTEXT).children.map((node, index) => {
                const onClick = () => {
                    commands.executeCommand(node.id, {
                        commentControlHandle: commentThread.controllerHandle,
                        commentThreadHandle: commentThread.commentThreadHandle,
                        commentUniqueId: comment.uniqueIdInThread,
                        text: this.inputRef.current ? this.inputRef.current.value : ''
                    });
                };
                return node instanceof common_1.ActionMenuNode &&
                    React.createElement(CommentAction, { key: index, node, commands, onClick, contextKeyService });
            })));
    }
}
exports.CommentEditContainer = CommentEditContainer;
class CommentsInlineAction extends React.Component {
    render() {
        const { node, commands, contextKeyService, commentThread, commentUniqueId } = this.props;
        if (node.when && !contextKeyService.match(node.when)) {
            return false;
        }
        return React.createElement("div", { className: 'theia-comments-inline-action' },
            React.createElement("a", { className: node.icon, title: node.label, onClick: () => {
                    commands.executeCommand(node.id, {
                        commentControlHandle: commentThread.controllerHandle,
                        commentThreadHandle: commentThread.commentThreadHandle,
                        commentUniqueId
                    });
                } }));
    }
}
exports.CommentsInlineAction = CommentsInlineAction;
class CommentActions extends React.Component {
    render() {
        const { contextKeyService, commands, menu, commentThread, getInput, clearInput } = this.props;
        return React.createElement("div", { className: 'form-actions' }, menu.children.map((node, index) => node instanceof common_1.ActionMenuNode &&
            React.createElement(CommentAction, { key: index, commands: commands, node: node, onClick: () => {
                    commands.executeCommand(node.id, {
                        commentControlHandle: commentThread.controllerHandle,
                        commentThreadHandle: commentThread.commentThreadHandle,
                        text: getInput()
                    });
                    clearInput();
                }, contextKeyService: contextKeyService })));
    }
}
exports.CommentActions = CommentActions;
class CommentAction extends React.Component {
    render() {
        const classNames = ['comments-button', 'comments-text-button', 'theia-button'];
        const { node, commands, contextKeyService, onClick } = this.props;
        if (node.when && !contextKeyService.match(node.when)) {
            return false;
        }
        const isEnabled = commands.isEnabled(node.command);
        if (!isEnabled) {
            classNames.push(browser_1.DISABLED_CLASS);
        }
        return React.createElement("button", { className: classNames.join(' '), tabIndex: 0, role: 'button', onClick: () => {
                if (isEnabled) {
                    onClick();
                }
            } }, node.label);
    }
}
exports.CommentAction = CommentAction;


/***/ }),

/***/ "../../node_modules/@theia/plugin-ext/lib/main/browser/custom-editors/custom-editor-opener.js":
/*!****************************************************************************************************!*\
  !*** ../../node_modules/@theia/plugin-ext/lib/main/browser/custom-editors/custom-editor-opener.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2021 SAP SE or an SAP affiliate company and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CustomEditorOpener = void 0;
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const common_1 = __webpack_require__(/*! ../../../common */ "../../node_modules/@theia/plugin-ext/lib/common/index.js");
const custom_editor_widget_1 = __webpack_require__(/*! ./custom-editor-widget */ "../../node_modules/@theia/plugin-ext/lib/main/browser/custom-editors/custom-editor-widget.js");
const uuid_1 = __webpack_require__(/*! @theia/core/lib/common/uuid */ "../../node_modules/@theia/core/lib/common/uuid.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const glob_1 = __webpack_require__(/*! @theia/core/lib/common/glob */ "../../node_modules/@theia/core/lib/common/glob.js");
class CustomEditorOpener {
    constructor(editor, shell, widgetManager, editorRegistry, preferenceService) {
        this.editor = editor;
        this.shell = shell;
        this.widgetManager = widgetManager;
        this.editorRegistry = editorRegistry;
        this.preferenceService = preferenceService;
        this.onDidOpenCustomEditorEmitter = new core_1.Emitter();
        this.onDidOpenCustomEditor = this.onDidOpenCustomEditorEmitter.event;
        this.pendingWidgetPromises = new Map();
        this.id = CustomEditorOpener.toCustomEditorId(this.editor.viewType);
        this.label = this.editor.displayName;
    }
    static toCustomEditorId(editorViewType) {
        return `custom-editor-${editorViewType}`;
    }
    canHandle(uri, options) {
        let priority = 0;
        const { selector } = this.editor;
        if (browser_1.DiffUris.isDiffUri(uri)) {
            const [left, right] = browser_1.DiffUris.decode(uri);
            if (this.matches(selector, right) && this.matches(selector, left)) {
                priority = this.getPriority();
            }
        }
        else if (this.matches(selector, uri)) {
            if ((0, browser_1.getDefaultHandler)(uri, this.preferenceService) === this.editor.viewType) {
                priority = browser_1.defaultHandlerPriority;
            }
            else {
                priority = this.getPriority();
            }
        }
        return priority;
    }
    canOpenWith(uri) {
        if (this.matches(this.editor.selector, uri)) {
            return this.getPriority();
        }
        return 0;
    }
    getPriority() {
        switch (this.editor.priority) {
            case common_1.CustomEditorPriority.default: return 500;
            case common_1.CustomEditorPriority.builtin: return 400;
            /** `option` should not open the custom-editor by default. */
            case common_1.CustomEditorPriority.option: return 1;
            default: return 200;
        }
    }
    async openCustomEditor(uri, options) {
        let widget;
        let isNewWidget = false;
        const uriString = uri.toString();
        let widgetPromise = this.pendingWidgetPromises.get(uriString);
        if (widgetPromise) {
            widget = await widgetPromise;
        }
        else {
            const widgets = this.widgetManager.getWidgets(custom_editor_widget_1.CustomEditorWidget.FACTORY_ID);
            widget = widgets.find(w => w.viewType === this.editor.viewType && w.resource.toString() === uriString);
            if (!widget) {
                isNewWidget = true;
                const id = (0, uuid_1.generateUuid)();
                widgetPromise = this.widgetManager.getOrCreateWidget(custom_editor_widget_1.CustomEditorWidget.FACTORY_ID, { id }).then(async (w) => {
                    try {
                        w.viewType = this.editor.viewType;
                        w.resource = uri;
                        await this.editorRegistry.resolveWidget(w);
                        if (options === null || options === void 0 ? void 0 : options.widgetOptions) {
                            await this.shell.addWidget(w, options.widgetOptions);
                        }
                        return w;
                    }
                    catch (e) {
                        w.dispose();
                        throw e;
                    }
                }).finally(() => this.pendingWidgetPromises.delete(uriString));
                this.pendingWidgetPromises.set(uriString, widgetPromise);
                widget = await widgetPromise;
            }
        }
        if ((options === null || options === void 0 ? void 0 : options.mode) === 'activate') {
            await this.shell.activateWidget(widget.id);
        }
        else if ((options === null || options === void 0 ? void 0 : options.mode) === 'reveal') {
            await this.shell.revealWidget(widget.id);
        }
        if (isNewWidget) {
            this.onDidOpenCustomEditorEmitter.fire([widget, options]);
        }
        return widget;
    }
    async openSideBySide(uri, options) {
        const [leftUri, rightUri] = browser_1.DiffUris.decode(uri);
        const widget = await this.widgetManager.getOrCreateWidget(custom_editor_widget_1.CustomEditorWidget.SIDE_BY_SIDE_FACTORY_ID, { uri: uri.toString(), viewType: this.editor.viewType });
        if (!widget.panes.length) { // a new widget
            const trackedDisposables = new core_1.DisposableCollection(widget);
            try {
                const createPane = async (paneUri) => {
                    let pane = await this.openCustomEditor(paneUri);
                    if (pane.isAttached) {
                        await this.shell.closeWidget(pane.id);
                        if (!pane.isDisposed) { // user canceled
                            return undefined;
                        }
                        pane = await this.openCustomEditor(paneUri);
                    }
                    return pane;
                };
                const rightPane = await createPane(rightUri);
                if (!rightPane) {
                    trackedDisposables.dispose();
                    return undefined;
                }
                trackedDisposables.push(rightPane);
                const leftPane = await createPane(leftUri);
                if (!leftPane) {
                    trackedDisposables.dispose();
                    return undefined;
                }
                trackedDisposables.push(leftPane);
                widget.addPane(leftPane);
                widget.addPane(rightPane);
                // dispose the widget if either of its panes gets externally disposed
                leftPane.disposed.connect(() => widget.dispose());
                rightPane.disposed.connect(() => widget.dispose());
                if (options === null || options === void 0 ? void 0 : options.widgetOptions) {
                    await this.shell.addWidget(widget, options.widgetOptions);
                }
            }
            catch (e) {
                trackedDisposables.dispose();
                console.error(e);
                throw e;
            }
        }
        if ((options === null || options === void 0 ? void 0 : options.mode) === 'activate') {
            await this.shell.activateWidget(widget.id);
        }
        else if ((options === null || options === void 0 ? void 0 : options.mode) === 'reveal') {
            await this.shell.revealWidget(widget.id);
        }
        return widget;
    }
    async open(uri, options) {
        var _a, _b;
        options = { ...options };
        (_a = options.mode) !== null && _a !== void 0 ? _a : (options.mode = 'activate');
        (_b = options.widgetOptions) !== null && _b !== void 0 ? _b : (options.widgetOptions = { area: 'main' });
        return browser_1.DiffUris.isDiffUri(uri) ? this.openSideBySide(uri, options) : this.openCustomEditor(uri, options);
    }
    matches(selectors, resource) {
        return selectors.some(selector => this.selectorMatches(selector, resource));
    }
    selectorMatches(selector, resource) {
        if (selector.filenamePattern) {
            if ((0, glob_1.match)(selector.filenamePattern.toLowerCase(), resource.path.name.toLowerCase() + resource.path.ext.toLowerCase())) {
                return true;
            }
        }
        return false;
    }
}
exports.CustomEditorOpener = CustomEditorOpener;


/***/ }),

/***/ "../../node_modules/@theia/plugin-ext/lib/main/browser/documents-main.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@theia/plugin-ext/lib/main/browser/documents-main.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DocumentsMainImpl = exports.ModelReferenceCollection = void 0;
// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
const plugin_api_rpc_1 = __webpack_require__(/*! ../../common/plugin-api-rpc */ "../../node_modules/@theia/plugin-ext/lib/common/plugin-api-rpc.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const vscode_uri_1 = __webpack_require__(/*! @theia/core/shared/vscode-uri */ "../../node_modules/@theia/core/shared/vscode-uri/index.js");
const disposable_util_1 = __webpack_require__(/*! ../../common/disposable-util */ "../../node_modules/@theia/plugin-ext/lib/common/disposable-util.js");
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
const types_impl_1 = __webpack_require__(/*! ../../plugin/types-impl */ "../../node_modules/@theia/plugin-ext/lib/plugin/types-impl.js");
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
class ModelReferenceCollection {
    constructor(maxAge = 1000 * 60 * 3, maxLength = 1024 * 1024 * 80) {
        this.maxAge = maxAge;
        this.maxLength = maxLength;
        this.data = new Array();
        this.length = 0;
    }
    dispose() {
        this.data = (0, disposable_util_1.dispose)(this.data) || [];
    }
    add(ref) {
        const length = ref.object.textEditorModel.getValueLength();
        const handle = setTimeout(_dispose, this.maxAge);
        const entry = { length, dispose: _dispose };
        const self = this;
        function _dispose() {
            const idx = self.data.indexOf(entry);
            if (idx >= 0) {
                self.length -= length;
                ref.dispose();
                clearTimeout(handle);
                self.data.splice(idx, 1);
            }
        }
        ;
        this.data.push(entry);
        this.length += length;
        this.cleanup();
    }
    cleanup() {
        while (this.length > this.maxLength) {
            this.data[0].dispose();
        }
    }
}
exports.ModelReferenceCollection = ModelReferenceCollection;
class DocumentsMainImpl {
    constructor(editorsAndDocuments, notebookDocuments, modelService, rpc, openerService, shell, untitledResourceResolver, languageService) {
        this.modelService = modelService;
        this.openerService = openerService;
        this.shell = shell;
        this.untitledResourceResolver = untitledResourceResolver;
        this.languageService = languageService;
        this.syncedModels = new Map();
        this.modelReferenceCache = new ModelReferenceCollection();
        this.saveTimeout = 1750;
        this.toDispose = new core_1.DisposableCollection(this.modelReferenceCache);
        this.proxy = rpc.getProxy(plugin_api_rpc_1.MAIN_RPC_CONTEXT.DOCUMENTS_EXT);
        this.toDispose.push(editorsAndDocuments);
        this.toDispose.push(editorsAndDocuments.onDocumentAdd(documents => documents.forEach(this.onModelAdded, this)));
        this.toDispose.push(editorsAndDocuments.onDocumentRemove(documents => documents.forEach(this.onModelRemoved, this)));
        this.toDispose.push(modelService.onModelModeChanged(this.onModelChanged, this));
        this.toDispose.push(notebookDocuments.onDidAddNotebookCellModel(this.onModelAdded, this));
        this.toDispose.push(modelService.onModelSaved(m => {
            this.proxy.$acceptModelSaved(m.textEditorModel.uri);
        }));
        this.toDispose.push(modelService.onModelWillSave(onWillSaveModelEvent => {
            onWillSaveModelEvent.waitUntil(new Promise(async (resolve, reject) => {
                setTimeout(() => reject(new Error(`Aborted onWillSaveTextDocument-event after ${this.saveTimeout}ms`)), this.saveTimeout);
                const edits = await this.proxy.$acceptModelWillSave(onWillSaveModelEvent.model.textEditorModel.uri, onWillSaveModelEvent.reason, this.saveTimeout);
                const editOperations = [];
                for (const edit of edits) {
                    const { range, text } = edit;
                    if (!range && !text) {
                        continue;
                    }
                    if (range && range.startLineNumber === range.endLineNumber && range.startColumn === range.endColumn && !edit.text) {
                        continue;
                    }
                    editOperations.push({
                        range: range ? monaco.Range.lift(range) : onWillSaveModelEvent.model.textEditorModel.getFullModelRange(),
                        /* eslint-disable-next-line no-null/no-null */
                        text: text || null,
                        forceMoveMarkers: edit.forceMoveMarkers
                    });
                }
                resolve(editOperations);
            }));
        }));
        this.toDispose.push(modelService.onModelDirtyChanged(m => {
            this.proxy.$acceptDirtyStateChanged(m.textEditorModel.uri, m.dirty);
        }));
    }
    dispose() {
        this.toDispose.dispose();
    }
    onModelChanged(event) {
        const modelUrl = event.model.textEditorModel.uri;
        if (this.syncedModels.has(modelUrl.toString())) {
            this.proxy.$acceptModelModeChanged(modelUrl, event.oldModeId, event.model.languageId);
        }
    }
    onModelAdded(model) {
        const modelUri = model.textEditorModel.uri;
        const key = modelUri.toString();
        const toDispose = new core_1.DisposableCollection(model.textEditorModel.onDidChangeContent(e => this.proxy.$acceptModelChanged(modelUri, {
            eol: e.eol,
            versionId: e.versionId,
            reason: e.isRedoing ? types_impl_1.TextDocumentChangeReason.Redo : e.isUndoing ? types_impl_1.TextDocumentChangeReason.Undo : undefined,
            changes: e.changes.map(c => ({
                text: c.text,
                range: c.range,
                rangeLength: c.rangeLength,
                rangeOffset: c.rangeOffset
            }))
        }, model.dirty)), core_1.Disposable.create(() => this.syncedModels.delete(key)));
        this.syncedModels.set(key, toDispose);
        this.toDispose.push(toDispose);
    }
    onModelRemoved(url) {
        const model = this.syncedModels.get(url.toString());
        if (model) {
            model.dispose();
        }
    }
    async $tryCreateDocument(options) {
        const language = (options === null || options === void 0 ? void 0 : options.language) && this.languageService.getExtension(options.language);
        const content = options === null || options === void 0 ? void 0 : options.content;
        const resource = await this.untitledResourceResolver.createUntitledResource(content, language);
        return monaco.Uri.parse(resource.uri.toString());
    }
    async $tryShowDocument(uri, options) {
        // Removing try-catch block here makes it not possible to handle errors.
        // Following message is appeared in browser console
        //   - Uncaught (in promise) Error: Cannot read property 'message' of undefined.
        try {
            const editorOptions = DocumentsMainImpl.toEditorOpenerOptions(this.shell, options);
            const uriArg = new uri_1.default(vscode_uri_1.URI.revive(uri));
            const opener = await this.openerService.getOpener(uriArg, editorOptions);
            await opener.open(uriArg, editorOptions);
        }
        catch (err) {
            throw new Error(err);
        }
    }
    async $trySaveDocument(uri) {
        return this.modelService.save(new uri_1.default(vscode_uri_1.URI.revive(uri)));
    }
    async $tryOpenDocument(uri) {
        const ref = await this.modelService.createModelReference(new uri_1.default(vscode_uri_1.URI.revive(uri)));
        if (ref.object) {
            this.modelReferenceCache.add(ref);
            return true;
        }
        else {
            ref.dispose();
            return false;
        }
    }
    static toEditorOpenerOptions(shell, options) {
        if (!options) {
            return undefined;
        }
        let range;
        if (options.selection) {
            const selection = options.selection;
            range = {
                start: { line: selection.startLineNumber - 1, character: selection.startColumn - 1 },
                end: { line: selection.endLineNumber - 1, character: selection.endColumn - 1 }
            };
        }
        /* fall back to side group -> split relative to the active widget */
        let widgetOptions = { mode: 'split-right' };
        let viewColumn = options.viewColumn;
        if (viewColumn === -2) {
            /* show besides -> compute current column and adjust viewColumn accordingly */
            const tabBars = shell.mainAreaTabBars;
            const currentTabBar = shell.currentTabBar;
            if (currentTabBar) {
                const currentColumn = tabBars.indexOf(currentTabBar);
                if (currentColumn > -1) {
                    // +2 because conversion from 0-based to 1-based index and increase of 1
                    viewColumn = currentColumn + 2;
                }
            }
        }
        if (viewColumn === undefined || viewColumn === -1) {
            /* active group -> skip (default behaviour) */
            widgetOptions = undefined;
        }
        else if (viewColumn > 0 && shell.mainAreaTabBars.length > 0) {
            const tabBars = shell.mainAreaTabBars;
            if (viewColumn <= tabBars.length) {
                // convert to zero-based index
                const tabBar = tabBars[viewColumn - 1];
                if (tabBar === null || tabBar === void 0 ? void 0 : tabBar.currentTitle) {
                    widgetOptions = { ref: tabBar.currentTitle.owner };
                }
            }
            else {
                const tabBar = tabBars[tabBars.length - 1];
                if (tabBar === null || tabBar === void 0 ? void 0 : tabBar.currentTitle) {
                    widgetOptions.ref = tabBar.currentTitle.owner;
                }
            }
        }
        return {
            selection: range,
            mode: options.preserveFocus ? 'reveal' : 'activate',
            preview: options.preview,
            widgetOptions
        };
    }
}
exports.DocumentsMainImpl = DocumentsMainImpl;


/***/ }),

/***/ "../../node_modules/@theia/plugin-ext/lib/main/browser/menus/vscode-theia-menu-mappings.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@theia/plugin-ext/lib/main/browser/menus/vscode-theia-menu-mappings.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2022 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CodeEditorWidgetUtil = exports.codeToTheiaMappings = exports.implementedVSCodeContributionPoints = exports.PLUGIN_VIEW_TITLE_MENU = exports.PLUGIN_SCM_TITLE_MENU = exports.PLUGIN_EDITOR_TITLE_RUN_MENU = exports.PLUGIN_EDITOR_TITLE_MENU = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const navigatable_1 = __webpack_require__(/*! @theia/core/lib/browser/navigatable */ "../../node_modules/@theia/core/lib/browser/navigatable.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const debug_stack_frames_widget_1 = __webpack_require__(/*! @theia/debug/lib/browser/view/debug-stack-frames-widget */ "../../node_modules/@theia/debug/lib/browser/view/debug-stack-frames-widget.js");
const debug_threads_widget_1 = __webpack_require__(/*! @theia/debug/lib/browser/view/debug-threads-widget */ "../../node_modules/@theia/debug/lib/browser/view/debug-threads-widget.js");
const debug_toolbar_widget_1 = __webpack_require__(/*! @theia/debug/lib/browser/view/debug-toolbar-widget */ "../../node_modules/@theia/debug/lib/browser/view/debug-toolbar-widget.js");
const debug_variables_widget_1 = __webpack_require__(/*! @theia/debug/lib/browser/view/debug-variables-widget */ "../../node_modules/@theia/debug/lib/browser/view/debug-variables-widget.js");
const browser_2 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const navigator_contribution_1 = __webpack_require__(/*! @theia/navigator/lib/browser/navigator-contribution */ "../../node_modules/@theia/navigator/lib/browser/navigator-contribution.js");
const scm_tree_widget_1 = __webpack_require__(/*! @theia/scm/lib/browser/scm-tree-widget */ "../../node_modules/@theia/scm/lib/browser/scm-tree-widget.js");
const dirty_diff_widget_1 = __webpack_require__(/*! @theia/scm/lib/browser/dirty-diff/dirty-diff-widget */ "../../node_modules/@theia/scm/lib/browser/dirty-diff/dirty-diff-widget.js");
const timeline_tree_widget_1 = __webpack_require__(/*! @theia/timeline/lib/browser/timeline-tree-widget */ "../../node_modules/@theia/timeline/lib/browser/timeline-tree-widget.js");
const comment_thread_widget_1 = __webpack_require__(/*! ../comments/comment-thread-widget */ "../../node_modules/@theia/plugin-ext/lib/main/browser/comments/comment-thread-widget.js");
const tree_view_widget_1 = __webpack_require__(/*! ../view/tree-view-widget */ "../../node_modules/@theia/plugin-ext/lib/main/browser/view/tree-view-widget.js");
const webview_1 = __webpack_require__(/*! ../webview/webview */ "../../node_modules/@theia/plugin-ext/lib/main/browser/webview/webview.js");
const editor_linenumber_contribution_1 = __webpack_require__(/*! @theia/editor/lib/browser/editor-linenumber-contribution */ "../../node_modules/@theia/editor/lib/browser/editor-linenumber-contribution.js");
const test_view_contribution_1 = __webpack_require__(/*! @theia/test/lib/browser/view/test-view-contribution */ "../../node_modules/@theia/test/lib/browser/view/test-view-contribution.js");
const test_run_view_contribution_1 = __webpack_require__(/*! @theia/test/lib/browser/view/test-run-view-contribution */ "../../node_modules/@theia/test/lib/browser/view/test-run-view-contribution.js");
const terminal_frontend_contribution_1 = __webpack_require__(/*! @theia/terminal/lib/browser/terminal-frontend-contribution */ "../../node_modules/@theia/terminal/lib/browser/terminal-frontend-contribution.js");
exports.PLUGIN_EDITOR_TITLE_MENU = ['plugin_editor/title'];
exports.PLUGIN_EDITOR_TITLE_RUN_MENU = ['plugin_editor/title/run'];
exports.PLUGIN_SCM_TITLE_MENU = ['plugin_scm/title'];
exports.PLUGIN_VIEW_TITLE_MENU = ['plugin_view/title'];
exports.implementedVSCodeContributionPoints = [
    'comments/comment/context',
    'comments/comment/title',
    'comments/commentThread/context',
    'debug/callstack/context',
    'debug/variables/context',
    'debug/toolBar',
    'editor/context',
    'editor/title',
    'editor/title/context',
    'editor/title/run',
    'editor/lineNumber/context',
    'explorer/context',
    'scm/change/title',
    'scm/resourceFolder/context',
    'scm/resourceGroup/context',
    'scm/resourceState/context',
    'scm/title',
    'timeline/item/context',
    'testing/item/context',
    'testing/message/context',
    'testing/profiles/context',
    'view/item/context',
    'view/title',
    'webview/context',
    'extension/context',
    'terminal/context',
    'terminal/title/context'
];
/** The values are menu paths to which the VSCode contribution points correspond */
exports.codeToTheiaMappings = new Map([
    ['comments/comment/context', [comment_thread_widget_1.COMMENT_CONTEXT]],
    ['comments/comment/title', [comment_thread_widget_1.COMMENT_TITLE]],
    ['comments/commentThread/context', [comment_thread_widget_1.COMMENT_THREAD_CONTEXT]],
    ['debug/callstack/context', [debug_stack_frames_widget_1.DebugStackFramesWidget.CONTEXT_MENU, debug_threads_widget_1.DebugThreadsWidget.CONTEXT_MENU]],
    ['debug/variables/context', [debug_variables_widget_1.DebugVariablesWidget.CONTEXT_MENU]],
    ['debug/toolBar', [debug_toolbar_widget_1.DebugToolBar.MENU]],
    ['editor/context', [browser_2.EDITOR_CONTEXT_MENU]],
    ['editor/title', [exports.PLUGIN_EDITOR_TITLE_MENU]],
    ['editor/title/context', [browser_1.SHELL_TABBAR_CONTEXT_MENU]],
    ['editor/title/run', [exports.PLUGIN_EDITOR_TITLE_RUN_MENU]],
    ['editor/lineNumber/context', [editor_linenumber_contribution_1.EDITOR_LINENUMBER_CONTEXT_MENU]],
    ['explorer/context', [navigator_contribution_1.NAVIGATOR_CONTEXT_MENU]],
    ['scm/change/title', [dirty_diff_widget_1.PLUGIN_SCM_CHANGE_TITLE_MENU]],
    ['scm/resourceFolder/context', [scm_tree_widget_1.ScmTreeWidget.RESOURCE_FOLDER_CONTEXT_MENU]],
    ['scm/resourceGroup/context', [scm_tree_widget_1.ScmTreeWidget.RESOURCE_GROUP_CONTEXT_MENU]],
    ['scm/resourceState/context', [scm_tree_widget_1.ScmTreeWidget.RESOURCE_CONTEXT_MENU]],
    ['scm/title', [exports.PLUGIN_SCM_TITLE_MENU]],
    ['testing/item/context', [test_view_contribution_1.TEST_VIEW_CONTEXT_MENU]],
    ['testing/message/context', [test_run_view_contribution_1.TEST_RUNS_CONTEXT_MENU]],
    ['testing/profiles/context', [test_view_contribution_1.PLUGIN_TEST_VIEW_TITLE_MENU]],
    ['timeline/item/context', [timeline_tree_widget_1.TIMELINE_ITEM_CONTEXT_MENU]],
    ['view/item/context', [tree_view_widget_1.VIEW_ITEM_CONTEXT_MENU]],
    ['view/title', [exports.PLUGIN_VIEW_TITLE_MENU]],
    ['webview/context', [webview_1.WEBVIEW_CONTEXT_MENU]],
    ['extension/context', [['extensions_context_menu', '3_contribution']]],
    ['terminal/context', [terminal_frontend_contribution_1.TerminalMenus.TERMINAL_CONTRIBUTIONS]],
    ['terminal/title/context', [terminal_frontend_contribution_1.TerminalMenus.TERMINAL_TITLE_CONTRIBUTIONS]]
]);
let CodeEditorWidgetUtil = class CodeEditorWidgetUtil {
    is(arg) {
        return arg instanceof browser_2.EditorWidget || arg instanceof webview_1.WebviewWidget;
    }
    getResourceUri(editor) {
        const resourceUri = navigatable_1.Navigatable.is(editor) && editor.getResourceUri();
        return resourceUri ? resourceUri['codeUri'] : undefined;
    }
};
exports.CodeEditorWidgetUtil = CodeEditorWidgetUtil;
exports.CodeEditorWidgetUtil = CodeEditorWidgetUtil = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], CodeEditorWidgetUtil);


/***/ }),

/***/ "../../node_modules/@theia/typehierarchy/lib/browser/index.js":
/*!********************************************************************!*\
  !*** ../../node_modules/@theia/typehierarchy/lib/browser/index.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2022 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
tslib_1.__exportStar(__webpack_require__(/*! ./typehierarchy */ "../../node_modules/@theia/typehierarchy/lib/browser/typehierarchy.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./typehierarchy-contribution */ "../../node_modules/@theia/typehierarchy/lib/browser/typehierarchy-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./typehierarchy-frontend-module */ "../../node_modules/@theia/typehierarchy/lib/browser/typehierarchy-frontend-module.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./typehierarchy-service */ "../../node_modules/@theia/typehierarchy/lib/browser/typehierarchy-service.js"), exports);


/***/ }),

/***/ "../../node_modules/@theia/typehierarchy/lib/browser/typehierarchy.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@theia/typehierarchy/lib/browser/typehierarchy.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2022 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_callhierarchy_lib_browser_index_js-node_modules_theia_plugin-ext_l-68477f.js.map