/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.encoding;

import com.sun.corba.se.impl.encoding.CDROutputStream;
import com.sun.corba.se.impl.encoding.EncapsOutputStream;
import com.sun.corba.se.impl.encoding.TypeCodeInputStream;
import com.sun.corba.se.spi.orb.ORB;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import sun.corba.EncapsInputStreamFactory;
import sun.corba.OutputStreamFactory;

public final class TypeCodeOutputStream
extends EncapsOutputStream {
    private OutputStream enclosure = null;
    private Map typeMap = null;
    private boolean isEncapsulation = false;

    public TypeCodeOutputStream(ORB oRB) {
        super(oRB, false);
    }

    public TypeCodeOutputStream(ORB oRB, boolean bl) {
        super(oRB, bl);
    }

    @Override
    public InputStream create_input_stream() {
        TypeCodeInputStream typeCodeInputStream = EncapsInputStreamFactory.newTypeCodeInputStream((org.omg.CORBA.ORB)((ORB)this.orb()), this.getByteBuffer(), this.getIndex(), this.isLittleEndian(), this.getGIOPVersion());
        return typeCodeInputStream;
    }

    public void setEnclosingOutputStream(OutputStream outputStream) {
        this.enclosure = outputStream;
    }

    public TypeCodeOutputStream getTopLevelStream() {
        if (this.enclosure == null) {
            return this;
        }
        if (this.enclosure instanceof TypeCodeOutputStream) {
            return ((TypeCodeOutputStream)this.enclosure).getTopLevelStream();
        }
        return this;
    }

    public int getTopLevelPosition() {
        if (this.enclosure != null && this.enclosure instanceof TypeCodeOutputStream) {
            int n = ((TypeCodeOutputStream)this.enclosure).getTopLevelPosition() + this.getPosition();
            if (this.isEncapsulation) {
                n += 4;
            }
            return n;
        }
        return this.getPosition();
    }

    public void addIDAtPosition(String string, int n) {
        if (this.typeMap == null) {
            this.typeMap = new HashMap(16);
        }
        this.typeMap.put(string, new Integer(n));
    }

    public int getPositionForID(String string) {
        if (this.typeMap == null) {
            throw this.wrapper.refTypeIndirType(CompletionStatus.COMPLETED_NO);
        }
        return (Integer)this.typeMap.get(string);
    }

    public void writeRawBuffer(org.omg.CORBA.portable.OutputStream outputStream, int n) {
        outputStream.write_long(n);
        ByteBuffer byteBuffer = this.getByteBuffer();
        if (byteBuffer.hasArray()) {
            outputStream.write_octet_array(byteBuffer.array(), 4, this.getIndex() - 4);
        } else {
            byte[] byArray = new byte[byteBuffer.limit()];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = byteBuffer.get(i);
            }
            outputStream.write_octet_array(byArray, 4, this.getIndex() - 4);
        }
    }

    public TypeCodeOutputStream createEncapsulation(org.omg.CORBA.ORB oRB) {
        TypeCodeOutputStream typeCodeOutputStream = OutputStreamFactory.newTypeCodeOutputStream((ORB)oRB, this.isLittleEndian());
        typeCodeOutputStream.setEnclosingOutputStream(this);
        typeCodeOutputStream.makeEncapsulation();
        return typeCodeOutputStream;
    }

    protected void makeEncapsulation() {
        this.putEndian();
        this.isEncapsulation = true;
    }

    public static TypeCodeOutputStream wrapOutputStream(OutputStream outputStream) {
        boolean bl = outputStream instanceof CDROutputStream ? ((CDROutputStream)outputStream).isLittleEndian() : false;
        TypeCodeOutputStream typeCodeOutputStream = OutputStreamFactory.newTypeCodeOutputStream((ORB)outputStream.orb(), bl);
        typeCodeOutputStream.setEnclosingOutputStream(outputStream);
        return typeCodeOutputStream;
    }

    public int getPosition() {
        return this.getIndex();
    }

    @Override
    public int getRealIndex(int n) {
        int n2 = this.getTopLevelPosition();
        return n2;
    }

    public byte[] getTypeCodeBuffer() {
        ByteBuffer byteBuffer = this.getByteBuffer();
        byte[] byArray = new byte[this.getIndex() - 4];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = byteBuffer.get(i + 4);
        }
        return byArray;
    }

    public void printTypeMap() {
        System.out.println("typeMap = {");
        for (String string : this.typeMap.keySet()) {
            Integer n = (Integer)this.typeMap.get(string);
            System.out.println("  key = " + string + ", value = " + n);
        }
        System.out.println("}");
    }
}

